//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

//Systemwide includes
#include <qlayout.h>
#include <qlabel.h>
#include <qfont.h>
#include <qcheckbox.h>
#include <qframe.h>
#include <qvgroupbox.h>
#include <qapplication.h>

//Projectwide includes
#include "alertsWidget.h"
#include "configuration.h"
#include "../config.h"
#include "../gui/window.h"
#include "../gui/statusWidget.h"

//==============================================
AlertsWidget::AlertsWidget( Configuration* config, QWidget* parent,
                            const char* name ) : QWidget( parent, name)
{
  this->config = config;

  categoryLabel = new QLabel( tr("Alerts:"), this);
  QFont labelFont = categoryLabel->font();
  labelFont.setWeight(QFont::Bold);
  categoryLabel->setFont( labelFont );

  horizontalLine = new QFrame(this);
  horizontalLine->setLineWidth(2);
  horizontalLine->setMidLineWidth(1);
  horizontalLine->setFrameStyle( QFrame::HLine | QFrame::Raised );

  behavior = new QVGroupBox( tr("Behavior"), this);
  showDestructiveAlerts = new QCheckBox( tr("Alert me to destructive actions"), behavior);
  showSoftwareUpdateAlerts = new QCheckBox( tr("Alert me to software updates"), behavior);

  grid = new QGridLayout( this, 4, 1, 0);
  grid->setSpacing( WIDGET_SPACING );

  grid->addWidget( categoryLabel,  0, 0, Qt::AlignLeft );
  grid->addWidget( horizontalLine,  1, 0 );
  grid->addWidget( behavior,  2, 0 );
  grid->setRowStretch( 3, 1 );
}
//==============================================
void AlertsWidget::setDefaults(Configuration* config)
{
  config->setBool( "alerts", "showDestructiveAlerts", true );
  config->setBool( "alerts", "showSoftwareUpdateAlerts", true );
  config->setString( "alerts", "loadSaveDir", QString(ALBUMSHAPER_VERSION) );
}
//==============================================
void AlertsWidget::loadSettings()
{
  showDestructiveAlerts->setChecked( config->getBool( "alerts", "showDestructiveAlerts" ));
  showSoftwareUpdateAlerts->setChecked( config->getBool( "alerts", "showSoftwareUpdateAlerts" ));
}
//==============================================
void AlertsWidget::saveSettings()
{
  config->setBool( "alerts", "showDestructiveAlerts", showDestructiveAlerts->isChecked() );
  config->setBool( "alerts", "showSoftwareUpdateAlerts", showSoftwareUpdateAlerts->isChecked() );

  //either check for and show or remove updates availble icon
  if(showSoftwareUpdateAlerts->isChecked())
    ((Window*)qApp->mainWidget())->getStatus()->checkForUpdates();
  else
    ((Window*)qApp->mainWidget())->getStatus()->removeUpdatesIcon();
}
//==============================================
