// ---------------------------------------------------------------------------
// - Cramer.hpp                                                              -
// - afnix:mth module - cramer system solver class definitions               -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2011 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  AFNIX_CRAMER_HPP
#define  AFNIX_CRAMER_HPP

#ifndef  AFNIX_RMI_HPP
#include "Rmi.hpp"
#endif
 
namespace afnix {

  /// The Cramer class is a class that implements a sparse determinant
  /// representation and provides the resolution of a linear system.
  /// In particular, the computation of a determinant is part of this
  /// class as soon as the representation is done. Since the determinant
  /// requires at most n! terms, it should only used with small or sparse
  /// matrix. You have been warned!
  /// @author amaury darsch

  class Cramer : public Object {
  public:
    /// solver a system with the cramer method
    /// @param x the result vector
    /// @param m the system matrix
    /// @param b the system vector
    static bool solve (Rvi& x, const Rmi& m, const Rvi& b);

  protected:
    /// the system size
    t_long d_size;
    /// the row cofactor
    struct s_rcf* p_rcf;

    /// internally set the rcf in unlock mode
    /// @param val the value to set
    /// @param row the row coordinate
    /// @param col the column coordinate
    void iset (const t_real val, const t_long row, const t_long col);

  public:
    /// create an empty system
    Cramer (void);

    /// create a system by matrix
    /// @param m the system matrix
    Cramer (const Rmi& m);

    /// create a system by matrix and vector
    /// @param m   the system matrix
    /// @param b   the system vector
    /// @param cfp the cofactor position
    Cramer (const Rmi& m, const Rvi& b, const t_long cfp);

    /// destroy this system
    ~Cramer (void);

    /// @return the  the class name
    String repr (void) const;

    /// reset this system
    virtual void reset (void);

    /// set the system by matrix
    /// @param m the system matrix
    virtual void set (const Rmi& m);

    /// set the system by matrix and vector
    /// @param m   the system matrix
    /// @param b   the system vector
    /// @param cfp the cofactor position
    virtual void set (const Rmi& m, const Rvi& b, const t_long cfp);

    /// compute the determinant of the system
    virtual t_real det (void) const;

  private:
    // make the copy constructor private
    Cramer (const Cramer&);
    // make the assignment operator private
    Cramer& operator = (const Cramer&);
  };
}

#endif
