// ---------------------------------------------------------------------------
// - Libmth.cpp                                                              -
// - afnix:mth module - declaration & implementation                         -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2011 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "Meta.hpp"
#include "Mpia.hpp"
#include "Random.hpp"
#include "Libmth.hpp"
#include "Predmth.hpp"
#include "Rvector.hpp"
#include "Rmatrix.hpp"
#include "Rsparse.hpp"
#include "Function.hpp"
#include "MthCalls.hpp"
#include "Primality.hpp"

namespace afnix {

  // initialize the afnix:mth module

  Object* init_afnix_mth (Interp* interp, Vector* argv) {
    // make sure we are not called from something crazy
    if (interp == nilp) return nilp;

    // create the afnix:mth nameset
    Nameset* aset = interp->mknset ("afnix");
    Nameset* mset = aset->mknset   ("mth");

    // bind all symbols in the afnix:nwg nameset
    mset->symcst ("Rvector",             new Meta (Rvector::mknew));
    mset->symcst ("Rmatrix",             new Meta (Rmatrix::mknew));
    mset->symcst ("Rsparse",             new Meta (Rsparse::mknew));
    
    // bind the predicates
    mset->symcst ("rvi-p",               new Function (mth_rvip));
    mset->symcst ("rmi-p",               new Function (mth_rmip));
    mset->symcst ("rsi-p",               new Function (mth_rsip));
    mset->symcst ("r-vector-p",          new Function (mth_rvectp));
    mset->symcst ("r-matrix-p",          new Function (mth_rmtrxp));
    mset->symcst ("r-sparse-p",          new Function (mth_rsprsp));

    // bind all mth calls in the afnix:mth nameset
    mset->symcst ("gcd",                 new Function (mth_gcd));
    mset->symcst ("lcm",                 new Function (mth_lcm));
    mset->symcst ("mmi",                 new Function (mth_mmi));
    
    mset->symcst ("get-random-integer",  new Function (mth_longrnd));
    mset->symcst ("get-random-real",     new Function (mth_realrnd));
    mset->symcst ("get-random-relatif",  new Function (mth_relnrnd));
    mset->symcst ("get-random-prime",    new Function (mth_primrnd));
    mset->symcst ("get-random-bitset",   new Function (mth_bitsrnd));
    mset->symcst ("get-random-r-vector", new Function (mth_rvecrnd));
    mset->symcst ("get-random-r-matrix", new Function (mth_rmtxrnd));

    mset->symcst ("fermat-p",            new Function (mth_frmtp));
    mset->symcst ("miller-rabin-p",      new Function (mth_mrptp));
    mset->symcst ("prime-probable-p",    new Function (mth_ppntp));

    mset->symcst ("det",                 new Function (mth_det));
    mset->symcst ("solver-crm",          new Function (mth_crm));
    mset->symcst ("solver-cgs",          new Function (mth_cgs));
    mset->symcst ("solver-bcs",          new Function (mth_bcs));

    // not used but needed
    return nilp;
  }
}

extern "C" {
  afnix::Object* dli_afnix_mth (afnix::Interp* interp, afnix::Vector* argv) {
    return init_afnix_mth (interp, argv);
  }
}
