// ---------------------------------------------------------------------------
// - HttpRequest.hpp                                                         -
// - afnix:nwg module - http request class definition                        -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2007 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  AFNIX_HTTPREQUEST_HPP
#define  AFNIX_HTTPREQUEST_HPP

#ifndef  AFNIX_URI_HPP
#include "Uri.hpp"
#endif

#ifndef  AFNIX_HTTPPROTO_HPP
#include "HttpProto.hpp"
#endif

namespace afnix {

  /// The HttpRequest class is a base class designed to handle a http
  /// request. The class operates with the protocol version 1.1 as defined
  /// by RFC 2616. A request is formatted with a request command and a uri.
  /// @author amaury darsch

  class HttpRequest : public HttpProto {
  protected:
    /// the request command
    String d_rcmd;
    /// the request uri
    String d_ruri;

  public:
    /// create a request by command
    /// @param rcmd the request command
    HttpRequest (const String& rcmd);

    /// create a request by uri
    /// @param uri the requested uri 
    HttpRequest (const Uri& uri);

    /// create a request by command and uri path
    /// @param rcmd the request command
    /// @param ruri the request uri
    HttpRequest (const String& rcmd, const String& ruri);

    /// create a request by command uri
    /// @param rcmd the request command
    /// @param uri the requested uri 
    HttpRequest (const String& rcmd, const Uri& uri);

    /// @return the class name
    String repr (void) const;

    /// set the request command
    /// @param rcmd the request command
    virtual void setrcmd (const String& rcmd);

    /// @return the request command
    virtual String getrcmd (void) const;

    /// set the request uri
    /// @param ruri the request uri to set
    virtual void setruri (const String& ruri);

    /// @return the request uri
    virtual String getruri (void) const;

    /// write the http request to an output stream
    /// @param os the output stream
    void write (Output& os) const;

    /// write the http request to a buffer
    /// @param buf the target buffer
    void write (Buffer& buf) const;

  private:
    // make the copy constructor private
    HttpRequest (const HttpRequest&);
    // make the assignment operator private
    HttpRequest& operator = (const HttpRequest&);

  public:
    /// create a new object in a generic object
    /// @param argv the argument vector
    static Object* mknew (Vector* argv);

    /// @return true if the given quark is defined
    bool isquark (const long quark, const bool hflg) const;

    /// apply this object with a set of arguments and a quark
    /// @param robj  the current runnable
    /// @param nset  the current nameset    
    /// @param quark the quark to apply these arguments
    /// @param argv  the arguments to apply
    Object* apply (Runnable* robj, Nameset* nset, const long quark,
                   Vector* argv);
  };
}

#endif
