# ----------------------------------------------------------------------------
# - mkhtml.als                                                               -
# - afnix cross spreadsheet - data importation and html exportation          -
# ----------------------------------------------------------------------------
# - This program is  free software;  you can  redistribute it and/or  modify -
# - it provided that this copyright notice is kept intact.                   -
# -                                                                          -
# - This  program  is  distributed in the hope  that it  will be useful, but -
# - without  any   warranty;  without  even   the   implied    warranty   of -
# - merchantability  or fitness for a particular purpose. In not event shall -
# - the copyright holder be  liable for  any direct, indirect, incidental or -
# - special damages arising in any way out of the use of this software.      -
# ----------------------------------------------------------------------------
# - copyright (c) 1999-2007 amaury darsch                                    -
# ----------------------------------------------------------------------------

# This example performs a data importation using the afnix api instead of
# the axs environment. Note that this example does not use a folio

# open the sio, odb and www libraries
interp:library "afnix-sio"
interp:library "afnix-sps"
interp:library "afnix-www"

# create a new sheet called elements
const tbl (afnix:sps:Sheet "elements")

# open the element file and import it in the sheet
const is (afnix:sio:InputMapped "elements.tbl")
tbl:import is

# uncomment the next line if you want to sort it in descending order
# tbl:sort 1 false

# create a html table from the data
const htbl (afnix:www:HtmlTable (tbl:convert))
htbl:set-caption "Periodic table of the elements"
htbl:add-tag "width"  "100%"
htbl:add-tag "border" "1px"

# create a html page and add the table
const page (afnix:www:HtmlPage)
page:add-title "Periodic table of elements"
page:emit-body htbl

# open the output file and write the page
const os (afnix:sio:OutputFile "elements.htm")
page:write-page os
os:close
