/*
    Copyright (C) 2003 Fons Adriaensen <fons.adriaensen@skynet.be>
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef __LFQUEUE_H
#define __LFQUEUE_H


#include "itypes.h"


class Lfq_u32
{
public:

    Lfq_u32 (int size);
    ~Lfq_u32 (void); 

    int  wr_avail (void) const { return _size - _nwr + _nrd; } 
    U32 *wr_ptr (void) { return _data + (_nwr & _mask); }
    void wr_commit (void) { _nwr++; }

    int  rd_avail (void) const { return _nwr - _nrd; } 
    U32 *rd_ptr (void) { return _data + (_nrd & _mask); }
    void rd_commit (void) { _nrd++; }

private:

    U32   *_data;
    int    _size;
    int    _mask;
    int    _nwr;
    int    _nrd;
};


#endif

