/*--- vector_free.h -------------------------------------------------------------
Copyright (C) 2004, 2005, 2006 Sylvain Fourmanoit <syfou@users.sourceforge.net>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.   
------------------------------------------------------------------------------*/
/* Set of all vector_free_items routines.
 */

/*----------------------------------------------------------------------------*/
#ifndef HAVE_VECTOR_FREE_H
#define HAVE_VECTOR_FREE_H

#ifndef HAVE_CONFIG_H
#error Autogenerated config.h should be used.
#endif

/*----------------------------------------------------------------------------*/
#include "config.h"			/* Autoconf */
#include "xwindow.h"                    /* Graphic includes */
#include "vector.h"                     /* Vector API */

/*----------------------------------------------------------------------------*/
void * image_vector_free_item(void*);
void * font_vector_free_item(void*);
void * color_range_vector_free_item(void*);
void * color_modifier_vector_free_item(void*);
void * filter_vector_free_item(void*);
void * polygon_vector_free_item(void*);

/*----------------------------------------------------------------------------*/
/* External vector_free_item function: defined in variable.c */
extern void * variable_vector_free_item(void*);

/*----------------------------------------------------------------------------*/
#endif
