/*--- cfgfile.h ----------------------------------------------------------------
Copyright (C) 2004, 2005, 2006 Sylvain Fourmanoit <syfou@users.sourceforge.net>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.   
------------------------------------------------------------------------------*/
/* Management routines for adesklets configuration file
 */

/*----------------------------------------------------------------------------*/
#ifndef HAVE_CFGFILE_H
#define HAVE_CFGFILE_H

#ifndef HAVE_CONFIG_H
#error Autogenerated config.h should be used.
#endif

/*----------------------------------------------------------------------------*/
#include "config.h"			/* Autoconf header */

#ifdef HAVE_STDLIB_H			/* setenv function */
#include <stdlib.h>			
#endif

#ifdef HAVE_STDIO_H
#include <stdio.h>			/* Standard IO routines  */
#endif

#ifdef HAVE_STRING_H			/* Strncat, strncpy functions */
#include <string.h>
#endif

#ifdef HAVE_UNISTD_H			/* File locking routines, */ 
					/* fork(), execve() functions */
#include <unistd.h>		
#endif

#ifdef HAVE_FCNTL_H
#include <fcntl.h>
#endif

#ifdef HAVE_SYS_TYPES_H			/* /etc/passwd management, ftruncate */
#include <sys/types.h>
#endif

#ifdef HAVE_SIGNAL_H			/* kill() */
#include <signal.h>
#endif 

#ifdef HAVE_PWD_H
#include <pwd.h>
#endif

#ifdef HAVE_DIRENT_H			/* opendir(), readdir(), closedir() */
#include <dirent.h>
#endif

#include "types.h"			/* Various typedef */
#include "error.h"			/* Error wrapper */

#include "vector.h"			/* Vector API */

/*----------------------------------------------------------------------------*/
#define CFGFILE_NAME "/.adesklets"	/* Name of the config. file */
#define CFGFILE_NAME_SIZE 256		/* Max lenght of filename, including
					   the path. WARNING: manual modifs.
					   have to be done in cfg_parser.y 
                                           and cfg_scanner.l if changed. Sorry!
                                         */

/*----------------------------------------------------------------------------*/
typedef struct s_cfgfile_item {
  char applet[CFGFILE_NAME_SIZE];
  uint id;
  int  scr;
  uint x, y;
  int  no_update;
} cfgfile_item;

/*----------------------------------------------------------------------------*/
/* Get an applet caracteristics from configuration file
 */
cfgfile_item * cfgfile_getinfo(char *, uint);

/* Add or modify a desklet description into the configuration file
 */
int cfgfile_update(cfgfile_item *);

/* Just 'exexve' in sequence all desklets in the configuration file
 */
int cfgfile_loadall(void);

/*----------------------------------------------------------------------------*/
#endif
