// -*- C++ -*-

//=============================================================================
/**
 *  @file     PortableGroup_Loader.h
 *
 *  PortableGroup_Loader.h,v 1.10 2005/07/04 12:05:40 jwillemsen Exp
 *
 *  Loads and initializes the PortableGroup extensions to TAO.
 *
 *  @author Frank Hunleth <fhunleth@cs.wustl.edu>
 */
//=============================================================================

#ifndef TAO_PORTABLEGROUP_LOADER_H
#define TAO_PORTABLEGROUP_LOADER_H

#include /**/ "ace/pre.h"
#include "ace/Service_Config.h"

#if !defined (ACE_LACKS_PRAGMA_ONCE)
# pragma once
#endif /* ACE_LACKS_PRAGMA_ONCE */

#include "ace/Service_Object.h"

#include "portablegroup_export.h"

/**
 * @class TAO_PortableGroup_Adapter
 *
 * @brief TAO_PortableGroup_Adapter.
 *
 * This class acts as a facade for the PortableGroup library to the
 * ORB.
 */
class TAO_PortableGroup_Export TAO_PortableGroup_Loader
  : public ACE_Service_Object
{
public:
  /// Constructor.
  TAO_PortableGroup_Loader (void);

  /// Initialize the PortableGroup loader hooks.
  virtual int init (int argc,
                    char *[]);

  /// Used to force the initialization of the ORB code.
  static int Initializer (void);
};

ACE_STATIC_SVC_DECLARE (TAO_PortableGroup_Loader)
ACE_FACTORY_DECLARE (TAO_PortableGroup, TAO_PortableGroup_Loader)

static int
TAO_Requires_PortableGroup_Initializer =
  TAO_PortableGroup_Loader::Initializer ();

#include /**/ "ace/post.h"

#endif /* TAO_PORTABLEGROUP_LOADER_H */
