!{\src2tex{textfont=tt}}
!!****p* ABINIT/mrgscr
!! NAME
!! mrgscr
!!
!! PROGRAM
!! Reads _SCR files for different q points, and then merges them in a
!! single file
!!
!! FUNCTION
!!
!! COPYRIGHT
!! Copyright (C) 2005-2007 ABINIT group (R. Shaltaf)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!
!!
!! OUTPUT
!!
!!
!! PARENTS
!!
!! CHILDREN
!!      findnq,findq,hdr_check,hdr_clean,hdr_io,hdr_io_netcdf,herald,identk
!!      lattice,leave_new,matr3inv,rdscr,setmesh,surot,testscr,wrscr,wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

program mrgscr

 use defs_basis
 use defs_datatypes
 use defs_infos

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
 use interfaces_11util
 use interfaces_13io_mpi
 use interfaces_14iowfdenpot
 use interfaces_15gw
#else
 use defs_interfaces
#endif
!End of the abilint section

 implicit none

!Arguments -----------------------------------

!Local variables-------------------------------
!scalars
 integer :: fform,fform1,ifile,ii,iq,iq1,iqmissed,iqs,is,is1,is2,istat,isym
 integer :: isymend,isymin,jj,kk,nbnds,nbnds1,nfile,ngfft1,ngfft1a,ngfft2
 integer :: ngfft2a,ngfft3,ngfft3a,ninv,nkbz,nkbzx,nkibz,nkpt,nmerge,nomega
 integer :: nomega1,nop,npw,npw1,npweps,npwfn1,npwvec,npwwfn,npwwfn1,nq,nq_last
 integer :: nqf,nqf1,nqmissed,nr,nsym,nsym1,nsym2,rdwr,readnetcdf,restart
 integer :: restartpaw,unitem1,unitnum=10
 real(dp) :: bzvol,dtnons,ucvol
 logical :: found,log,nonlocal
 character(len=20) :: temp_file
 character(len=24) :: codename
 character(len=500) :: message
 type(MPI_type) :: mpi_enreg
 type(datafiles_type) :: dtfil0,dtfil1
 type(dataset_type) :: dtset
 type(hdr_type) :: hdr,hdr1
!arrays
 integer :: ngfft(3)
 integer,allocatable :: grottb(:,:,:),grottbm1(:,:,:),gvec(:,:),irottb(:,:)
 integer,allocatable :: ktab(:),ktabi(:),ktabo(:),ktabr(:,:)
 real(dp) :: a1(3),a2(3),a3(3),b1(3),b2(3),b3(3),gmet(3,3),gprimd(3,3),qdiff(3)
 real(dp) :: rprimd(3,3)
 real(dp),allocatable :: kbz(:,:),kibz(:,:),op(:,:,:),q(:,:),q_last(:,:)
 real(dp),allocatable :: qf(:,:),qf1(:,:),qmissed(:,:),symrel2(:,:,:)
 real(dp),allocatable :: tnons2(:,:),wtk(:)
 complex,allocatable :: epsm1(:,:,:,:),omega(:)
 logical,allocatable :: foundq(:),repetition(:,:)
 character(len=20),allocatable :: filename(:)
 character(len=80) :: titem1(2)

! *************************************************************************
!Note: in case the number of files (nfile== 1), the program will check
!only the status of the file whether it is complete or not, in the later
!case it will give detailed information about the needed q points
!to be complete

! start execution

 unitem1=24
 codename='MRGSCR'//repeat(' ',18)

! write greating,read the file names, etc.

 call herald(codename,abinit_version,std_out)
 write(*,*)'please enter how many files you want to merge'
 read(*,*)nfile
 write(*,*)nfile
 allocate(filename(nfile))
 if(nfile>1)then
  write(*,*)'please enter a root name for the full output file'
  read(*,*)temp_file
  dtfil1%filnam_ds(4)=trim(temp_file)
  write(*,*)trim(dtfil1%filnam_ds(4))
  do ifile=1,nfile
   write(*,*)'please enter the name of file',ifile
   read(*,*)temp_file
   filename(ifile)=trim(temp_file)
   write(*,*)trim(filename(ifile))
   inquire(file=filename(ifile),exist=log)
   if(.not.log)then
    write(message, '(i4,a,a,a,a,a,a,a)' )nfile, ch10,&
&  'ERROR -',ch10,&
&  'the file named', filename(ifile),'doesnot exist',ch10
    call wrtout(6,message,'COLL')
    call leave_new('COLL')
   end if
  end do
 else if(nfile==1) then
  read(*,*)temp_file
  filename(1)=trim(temp_file)
  write(message, '(a,a,a,a,a,a,a)' ) ch10,&
 ' since the number of files is only one',ch10,&
&' the only thing that mrgscr can do is to check to status',ch10,&
&' of the file ', filename(1)
  call wrtout(6,message,'COLL')
 else
  write(message, '(i4,a,a,a,a,a)' )nfile, ch10,&
&' ERROR -',ch10,&
&' number of files should be >0 ',ch10
  call wrtout(6,message,'COLL')
  call leave_new('COLL')
 end if

!read the header of the first file and on the basis of its
!header calculate the complete q list
!hdr0 is the header of the first file, it will be kept in memory for
!sake of comparison
!wherase for hdr1 which is the header of any other file it will updated

 do ifile=1,nfile
  unitem1= unitem1+1
  open(unit=unitem1,file=filename(ifile),status='unknown',form='unformatted')
  rdwr=1  ! reading
  readnetcdf = 0

! for the first file

  if(ifile==1)then ! treatment of the first file
   write(message, '(a,a,a,a,a,a,a)' ) ch10,&
 ' reading and analysing the header of file ',filename(ifile),ch10,&
&' and calculating the full q list',ch10,ch10
   call wrtout(6,message,'COLL')


   if (readnetcdf == 0) then
    call hdr_io(fform,hdr,rdwr,unitem1)
   else if (readnetcdf == 1) then
    call hdr_io_netcdf(fform,hdr,rdwr,unitem1)
   end if
   read(unitem1) ! skip title
   read(unitem1) npw,npwwfn,nbnds,nqf,nomega
   npweps=npw
   if(npw<npwwfn)then
    npweps=npwwfn
   end if
   allocate(gvec(3,npweps))
   read(unitem1) gvec(1:3,1:npweps)
   allocate(qf(3,nqf))
   read(unitem1)qf(1:3,1:nqf)
   close(unitem1)

   rprimd(:,:)=hdr%rprimd(:,:)
   ngfft1=hdr%ngfft(1)
   ngfft2=hdr%ngfft(2)
   ngfft3=hdr%ngfft(3)
   nop=hdr%nsym
   nkpt=hdr%nkpt

   allocate(op(3,3,hdr%nsym))
   rprimd(:,:)=hdr%rprimd(:,:)
   op(:,:,:)=hdr%symrel(:,:,:)

   call matr3inv(rprimd,gprimd)

   do ii=1,3
      gmet(ii,:)=gprimd(1,ii)*gprimd(1,:)+&
&            gprimd(2,ii)*gprimd(2,:)+&
&            gprimd(3,ii)*gprimd(3,:)
   end do
   call setmesh(gmet,gvec,ngfft1,ngfft2,ngfft3,&
&   ngfft1a,ngfft2a,ngfft3a,npweps,npwwfn,nr,1)
   ninv=2
   allocate(irottb(nr,nop),stat=istat)
   allocate(grottb(npweps,2,nop),stat=istat)
   allocate(grottbm1(npweps,2,nop),stat=istat)
   call surot(op,nop,ninv,ngfft1,ngfft1a,ngfft2,ngfft3,&
&   nr,npweps,gvec,grottb,irottb,grottbm1)

   nkbzx=nkpt*nop*2

   allocate(kibz(3,nkpt),stat=istat)
   allocate(kbz(3,nkbzx),stat=istat)
   allocate(wtk(nkpt),stat=istat)
   allocate(ktab(nkbzx),stat=istat)
   allocate(ktabi(nkbzx),stat=istat)
   allocate(ktabo(nkbzx),stat=istat)
   allocate(ktabr(nr,nkbzx),stat=istat)

   kibz(:,:)=hdr%kptns(:,:)

   call identk(kibz,nkpt,nkbzx,nr,nop,ninv,irottb,op,kbz,ktab,&
&   ktabr,ktabi,ktabo,nkbz,wtk)
   call findnq(nkbz,kbz,nop,op,nq,ninv)
   allocate(q(3,nq))
   call lattice(rprimd(:,1),rprimd(:,2),rprimd(:,3),&
&  b1,b2,b3,ucvol,bzvol)
   call findq(nkbz,kbz,nop,op,nq,q,ninv,b1,b2,b3)

   deallocate(irottb,grottb,grottbm1,kibz,kbz,wtk,ktab,ktabi,ktabo)
   deallocate(ktabr)
   allocate(foundq(nq),repetition(nfile,nq))
   allocate(q_last(3,nq))

   foundq(:)=.false.
   repetition(:,:)=.false.


!find the needed q points
   nqmissed=0
   nq_last=0
   allocate(qmissed(3,nq-nqf))
   do iq=1,nq
    do jj=1,nqf
     qdiff(:)=q(:,iq)-qf(:,jj)
     if(all(abs(qdiff(:))<1.0e-3))then
      foundq(iq)=.true.
      nq_last=nq_last+1
      q_last(:,nq_last)=qf(:,jj)
      exit  ! jj
     end if
    end do
    if(.not.foundq(iq))then
     nqmissed=nqmissed+1
     qmissed(:,nqmissed)=q(:,iq)
    end if
   end do

   if(nfile==1)then ! only checking not merging

    write(message, '(a,a,i4,a,a,a,a,i4,a,a)' ) ch10,&
& ' out of',nq,' q points',' your file contains',ch10,&
& ' only',nqf,' q points in [reduced coordinates]',ch10
    call wrtout(6,message,'COLL')
    do jj=1,nqf
     write(*,'(3f12.6)') (qf(ii,jj),ii=1,3)
    end do

    if(nqf<nq)then
     write(message, '(a,a,a,a,i4,a,a,a)' ) ch10,&
&  ' your file needs to be merged with one or more files',ch10,&
&  ' that contain eps1 calculated on the folowing',nqmissed,ch10,&
&  ' q-points to be complete',ch10
     call wrtout(6,message,'COLL')
     do jj=1,nqmissed
      write(*,'(3f12.6)') (qmissed(ii,jj),ii=1,3)
     end do

    else if(nqf==nq)then
     write(message, '(a,a,a,a,a)' ) ch10,&
&  ' Error -',ch10,&
&  ' your file is complete, nothing to do!',ch10
     call wrtout(6,message,'COLL')
     call leave_new('COLL')

    else if(nqf>nq)then
     write(message, '(a,a,a,a,a,a,a)' ) ch10,&
&  ' BUG -',ch10,&
&  ' nqf>nq in ',filename(ifile),ch10,&
&  ' action: contact ABINIT group'
     call wrtout(6,message,'COLL')
     call leave_new('COLL')
    end if
   end if ! nfile

    write(message, '(a,a,a,a)' ) ch10,ch10,&
& ' checking and analysing the first file finished',ch10
    call wrtout(6,message,'COLL')

   else if(ifile>1)then  ! treatment of other files

! compare the headers of the other files with the first one to see
! whether they are consistent

    if (readnetcdf == 0) then
     call hdr_io(fform1,hdr1,rdwr,unitem1)
    else if (readnetcdf == 1) then
     call hdr_io_netcdf(fform1,hdr1,rdwr,unitem1)
    end if
    read(unitem1) ! skip title
    read(unitem1) npw1,npwwfn1,nbnds1,nqf1,nomega1
    read(unitem1) ! skip g
    allocate(qf1(3,nqf1))
    read(unitem1)qf1(1:3,1:nqf1)
    close(unitem1)

    if(ifile==2)then  ! it is enough to write this once
     write(message, '(a,a,a,a,a)' ) ch10,ch10,&
&  ' checking if the other files are consistent with file ',&
&    filename(1),ch10
     call wrtout(6,message,'COLL')
    end if

    write(message, '(a,a,a,a,a,a,a)' ) ch10,ch10,&
& ' checking the header of file ',filename(ifile),ch10,&
& ' and comparing to the header of file ',filename(1)

    write(message,&
&  '(a1,80a,2a1,10x,a,3a1,13x,a,25x,a,a1,8x,19a,25x,12a,a1)' )&
&   ch10,('=',ii=1,80),ch10,ch10,&
& ' checking file headers for consistency -',&
&  (ch10,ii=1,3),filename(1),&
&   filename(ifile),ch10,('-',ii=1,19),('-',ii=1,12),ch10
    call wrtout(06,message,'COLL')
    call hdr_check(fform,fform1,hdr,hdr1,'COLL',&
 &  restart,restartpaw)

    if(restart/=1)then
     write(message, '(a,a,a,a,a)' ) ch10,&
&  ' ERROR -',ch10,&
&  ' the file headers are not consistent',ch10
     call wrtout(6,message,'COLL')
     call leave_new('COLL')
    end if

    if(npw1/=npw)then
     write(message, '(a,a,a,a,a)' ) ch10,&
&  ' ERROR -',ch10,&
&  ' size of eps matrix is not equal in the two files',ch10
     call wrtout(6,message,'COLL')
     call leave_new('COLL')
    end if

    if(npwwfn1/=npwwfn)then
     write(message, '(a,a,a,a,a)' ) ch10,&
&  ' ERROR -',ch10,&
&  ' number of planewaves used is not equal in the two files',ch10
     call wrtout(6,message,'COLL')
     call leave_new('COLL')
    end if

    if(nomega1/=nomega)then
     write(message, '(a,a,a,a,a)' ) ch10,&
&  ' ERROR -',ch10,&
&  ' number of omega is not equal in the two files',ch10
     call wrtout(6,message,'COLL')
     call leave_new('COLL')
    end if
! check wether the q points included in the other files are the
! correct ones that should be included

   nmerge=0

    write(message, '(a,a,a,a)' ) ch10,&
& ' analyzing existing q points in file ',filename(ifile),ch10
    call wrtout(6,message,'COLL')

    do iq=1,nq
     do iq1=1,nqf1
      qdiff(:)=q(:,iq)-qf1(:,iq1)
      if(all(abs(qdiff(:))<1.0e-3))then
       if(.not.foundq(iq))then
        foundq(iq)=.true.
        nmerge=nmerge+1
        nq_last=nq_last+1
        q_last(:,nq_last)=qf1(:,iq1)
       else ! repition
        repetition(ifile,iq1)=.true.
        write(message, '(a,a,a,a,3f12.6,a,a,a,a,a)' ) ch10,&
&     ' WARNING -',ch10,&
&     ' the q point',q(:,iq),ch10,&
&     ' already exist in another file, any further processsing of',ch10,&
&     ' this q point from this file will be ignored ', ch10
        call wrtout(6,message,'COLL')
       end if
       if(foundq(iq))exit
      end if
     end do ! iq1
    end do  ! iq

    if(nmerge<nqf1)then
     write(message, '(a,a,a,a,i4,a,a,a,a,i4,a)' ) ch10,&
&  ' WARNING -',ch10,&
&  ' out of',nqf1,' already exit in file ',filename(ifile),ch10,&
&  ' the number of q points to be merged from this file is',&
&    nmerge,ch10
     call wrtout(6,message,'COLL')
    end if
    call hdr_clean(hdr1)
    deallocate(qf1)

   end if  ! ifile
 end do   ! ifile

! write some error massage if exist
 if(nfile>1)then
  if(nq_last<nq)then
   write(message, '(a,a,a,a,a,a,a)' ) ch10,&
&' ERROR -',ch10,&
&' your files do not include enough q points',ch10,&
&' please check your files',ch10
   call wrtout(6,message,'COLL')
   call leave_new('COLL')
  end if
  write(message, '(a,a,a,a,a)' ) ch10,&
&' eps1 will appear in the output file according to',ch10,&
&' the following order of q list',ch10
  call wrtout(6,message,'COLL')
  do jj=1,nq_last
   write(*,'(3f12.6)') (q_last(ii,jj),ii=1,3)
  end do
 end if

 deallocate(qf)

! start merging

 if(nfile>1)then
  write(message, '(a,a,a)' ) ch10,&
&' start merging',ch10
  call wrtout(6,message,'COLL')
  iqs=0
  dtset%nqptdm=0
  do ifile=1,nfile
   write(message, '(a,a,a,a)' ) ch10,&
&' start merging file ',filename(ifile),ch10
   call wrtout(6,message,'COLL')
   dtfil0%filscr=filename(ifile)
   call testscr(dtfil0,nqf1,nomega,npwvec,npwwfn,nbnds,titem1,fform,mpi_enreg,nonlocal)
   allocate(epsm1(npwvec,npwvec,nomega,nqf1),omega(nomega))
   allocate(qf1(3,nqf1))
   call rdscr(dtfil0,npwvec,nqf1,nomega,qf1,omega,epsm1,mpi_enreg,nonlocal)
   do iq=1,nqf1
    if(repetition(ifile,iq))cycle
    iqs=iqs+1
    call wrscr(dtfil1,hdr,dtset,npwvec,npwwfn,npwvec,nbnds,nq_last,&
&   nomega,q_last,omega,gvec,iqs,epsm1(:,:,:,iq),titem1,10,nop,op)
   end do
   deallocate(epsm1,omega,qf1)
  end do
  deallocate(op,filename)
  write(message, '(a,a,a)' ) ch10,&
&' Merging files finished successfully',ch10
  call wrtout(6,message,'COLL')
 else
  write(message, '(a,a,a)' ) ch10,&
&' Checking file finished successfully',ch10
  call wrtout(6,message,'COLL')
 end if

 call hdr_clean(hdr)

end program mrgscr
!!***
