/** BEGIN COPYRIGHT BLOCK
 * This Program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; version 2 of the License.
 * 
 * This Program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this Program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA 02111-1307 USA.
 * 
 * In addition, as a special exception, Red Hat, Inc. gives You the additional
 * right to link the code of this Program with code not covered under the GNU
 * General Public License ("Non-GPL Code") and to distribute linked combinations
 * including the two, subject to the limitations in this paragraph. Non-GPL Code
 * permitted under this exception must only link to the code of this Program
 * through those well defined interfaces identified in the file named EXCEPTION
 * found in the source code files (the "Approved Interfaces"). The files of
 * Non-GPL Code may instantiate templates or use macros or inline functions from
 * the Approved Interfaces without causing the resulting work to be covered by
 * the GNU General Public License. Only Red Hat, Inc. may make changes or
 * additions to the list of Approved Interfaces. You must obey the GNU General
 * Public License in all respects for all of the Program code and other code used
 * in conjunction with the Program except the Non-GPL Code covered by this
 * exception. If you modify this file, you may extend this exception to your
 * version of the file, but you are not obligated to do so. If you do not wish to
 * provide this exception without modification, you must delete this exception
 * statement from your version and license this file solely under the GPL without
 * exception. 
 * 
 * 
 * Copyright (C) 2001 Sun Microsystems, Inc. Used by permission.
 * Copyright (C) 2005 Red Hat, Inc.
 * All rights reserved.
 * END COPYRIGHT BLOCK **/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define ACL_FLEX_MAJOR_VERSION 2
#define ACL_FLEX_MINOR_VERSION 5

#include <stdio.h>


/* cfront 1.2 defines "c_plusplus" instead of "__cplusplus" */
#ifdef c_plusplus
#ifndef __cplusplus
#define __cplusplus
#endif
#endif


#ifdef __cplusplus

#include <stdlib.h>

/* Use prototypes in function declarations. */
#define ACL_USE_PROTOS

/* The "const" storage-class-modifier is valid. */
#define ACL_USE_CONST

#else	/* ! __cplusplus */

#if __STDC__

#define ACL_USE_PROTOS
#define ACL_USE_CONST

#endif	/* __STDC__ */
#endif	/* ! __cplusplus */

#ifdef __TURBOC__
 #pragma warn -rch
 #pragma warn -use
#include <io.h>
#include <stdlib.h>
#define ACL_USE_CONST
#define ACL_USE_PROTOS
#endif

#ifdef ACL_USE_CONST
#define aclconst const
#else
#define aclconst
#endif


#ifdef ACL_USE_PROTOS
#define ACL_PROTO(proto) proto
#else
#define ACL_PROTO(proto) ()
#endif

/* Returned upon end-of-file. */
#define ACL_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define ACL_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN acl_start = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The ACLSTATE alias is for lex
 * compatibility.
 */
#define ACL_START ((acl_start - 1) / 2)
#define ACLSTATE ACL_START

/* Action number for EOF rule of a given start state. */
#define ACL_STATE_EOF(state) (ACL_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define ACL_NEW_FILE aclrestart( aclin )

#define ACL_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#define ACL_BUF_SIZE 16384

typedef struct acl_buffer_state *ACL_BUFFER_STATE;

extern int aclleng;
extern FILE *aclin, *aclout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

/* The funky do-while in the following #define is used to turn the definition
 * int a single C statement (which needs a semi-colon terminator).  This
 * avoids problems with code like:
 *
 * 	if ( condition_holds )
 *		aclless( 5 );
 *	else
 *		do_something_else();
 *
 * Prior to using the do-while the compiler would get upset at the
 * "else" because it interpreted the "if" statement as being all
 * done when it reached the ';' after the aclless() call.
 */

/* Return all but the first 'n' matched characters back to the input stream. */

#define aclless(n) \
	do \
		{ \
		/* Undo effects of setting up acltext. */ \
		*acl_cp = acl_hold_char; \
		ACL_RESTORE_ACL_MORE_OFFSET \
		acl_c_buf_p = acl_cp = acl_bp + n - ACL_MORE_ADJ; \
		ACL_DO_BEFORE_ACTION; /* set up acltext again */ \
		} \
	while ( 0 )

#define unput(c) aclunput( c, acltext_ptr )

/* The following is because we cannot portably get our hands on size_t
 * (without autoconf's help, which isn't available because we want
 * flex-generated scanners to compile on their own).
 */
typedef unsigned int acl_size_t;


struct acl_buffer_state
	{
	FILE *acl_input_file;

	char *acl_ch_buf;		/* input buffer */
	char *acl_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	acl_size_t acl_buf_size;

	/* Number of characters read into acl_ch_buf, not including EOB
	 * characters.
	 */
	int acl_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can PERM_REALLOC() it to grow it, and should PERM_FREE() it to
	 * delete it.
	 */
	int acl_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int acl_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int acl_at_bol;

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int acl_fill_buffer;

	int acl_buffer_status;
#define ACL_BUFFER_NEW 0
#define ACL_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as ACL_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via aclrestart()), so that the user can continue scanning by
	 * just pointing aclin at a new input file.
	 */
#define ACL_BUFFER_EOF_PENDING 2
	};

static ACL_BUFFER_STATE acl_current_buffer = 0;

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 */
#define ACL_CURRENT_BUFFER acl_current_buffer


/* acl_hold_char holds the character lost when acltext is formed. */
static char acl_hold_char;

static int acl_n_chars;		/* number of characters read into acl_ch_buf */


int aclleng;

/* Points to current character in buffer. */
static char *acl_c_buf_p = (char *) 0;
static int acl_init = 1;		/* whether we need to initialize */
static int acl_start = 0;	/* start state number */

/* Flag which is used to allow aclwrap()'s to do buffer switches
 * instead of setting up a fresh aclin.  A bit of a hack ...
 */
static int acl_did_buffer_switch_on_eof;

void aclrestart ACL_PROTO(( FILE *input_file ));

void acl_switch_to_buffer ACL_PROTO(( ACL_BUFFER_STATE new_buffer ));
void acl_load_buffer_state ACL_PROTO(( void ));
ACL_BUFFER_STATE acl_create_buffer ACL_PROTO(( FILE *file, int size ));
void acl_delete_buffer ACL_PROTO(( ACL_BUFFER_STATE b ));
void acl_init_buffer ACL_PROTO(( ACL_BUFFER_STATE b, FILE *file ));
void acl_flush_buffer ACL_PROTO(( ACL_BUFFER_STATE b ));
#define ACL_FLUSH_BUFFER acl_flush_buffer( acl_current_buffer )

ACL_BUFFER_STATE acl_scan_buffer ACL_PROTO(( char *base, acl_size_t size ));
ACL_BUFFER_STATE acl_scan_string ACL_PROTO(( aclconst char *str ));
ACL_BUFFER_STATE acl_scan_bytes ACL_PROTO(( aclconst char *bytes, int len ));

static void *ACL_FLEX_ALLOC ACL_PROTO(( acl_size_t ));
static void *ACL_FLEX_REALLOC ACL_PROTO(( void *, acl_size_t ));
static void ACL_FLEX_FREE ACL_PROTO(( void * ));

#define acl_new_buffer acl_create_buffer

#define acl_set_interactive(is_interactive) \
	{ \
	if ( ! acl_current_buffer ) \
		acl_current_buffer = acl_create_buffer( aclin, ACL_BUF_SIZE ); \
	acl_current_buffer->acl_is_interactive = is_interactive; \
	}

#define acl_set_bol(at_bol) \
	{ \
	if ( ! acl_current_buffer ) \
		acl_current_buffer = acl_create_buffer( aclin, ACL_BUF_SIZE ); \
	acl_current_buffer->acl_at_bol = at_bol; \
	}

#define ACL_AT_BOL() (acl_current_buffer->acl_at_bol)

typedef unsigned char ACL_CHAR;
FILE *aclin = (FILE *) 0, *aclout = (FILE *) 0;
typedef int acl_state_type;
extern char *acltext;
#define acltext_ptr acltext

static acl_state_type acl_get_previous_state ACL_PROTO(( void ));
static acl_state_type acl_try_NUL_trans ACL_PROTO(( acl_state_type current_state ));
static int acl_get_next_buffer ACL_PROTO(( void ));
static void acl_fatal_error ACL_PROTO(( aclconst char msg[] ));

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up acltext.
 */
#define ACL_DO_BEFORE_ACTION \
	acltext_ptr = acl_bp; \
	aclleng = (int) (acl_cp - acl_bp); \
	acl_hold_char = *acl_cp; \
	*acl_cp = '\0'; \
	acl_c_buf_p = acl_cp;

#define ACL_NUM_RULES 30
#define ACL_END_OF_BUFFER 31
static aclconst short int acl_accept[104] =
    {   0,
        0,    0,   31,   30,    2,    1,   30,   30,    3,   28,
       29,   25,   22,   24,   29,   29,   29,   29,   29,   29,
       29,   29,   29,    2,    1,   27,    0,    4,    3,   29,
       26,   23,   29,   29,   29,   29,    9,   29,   29,   29,
       14,   29,   21,   29,   29,   29,   29,    6,   29,   29,
       20,   29,   29,   29,   29,   29,   19,   29,   29,   29,
       29,   29,   29,   29,   29,   29,   13,   29,   29,   29,
       18,   29,    7,   29,   29,   29,   29,   29,   29,   29,
       29,    8,   29,   29,   29,   29,   29,   29,   29,   29,
       11,   12,   15,   29,   17,    5,   29,   16,   29,   29,

       29,   10,    0
    } ;

static aclconst int acl_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    4,    5,    6,    1,    1,    1,    1,    7,
        7,    8,    1,    7,    8,    8,    1,    8,    8,    8,
        8,    8,    8,    8,    8,    8,    8,    1,    7,    9,
       10,   11,    1,    1,   12,   13,   14,   15,   16,   17,
        8,   18,   19,    8,    8,   20,   21,   22,   23,    8,
        8,   24,   25,   26,   27,   28,   29,    8,   30,    8,
        1,    1,    1,    1,    8,    1,   12,   13,   14,   15,

       16,   17,    8,   18,   19,    8,    8,   20,   21,   22,
       23,    8,    8,   24,   25,   26,   27,   28,   29,    8,
       30,    8,    7,    1,    7,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static aclconst int acl_meta[31] =
    {   0,
        1,    1,    2,    1,    1,    1,    1,    3,    1,    1,
        1,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3
    } ;

static aclconst short int acl_base[108] =
    {   0,
        0,    0,  118,  119,  115,    0,  106,   28,    0,  119,
        0,  105,  119,  104,   21,   90,   96,   89,   87,   85,
       92,   91,   87,  103,    0,  119,   33,  119,    0,    0,
      119,  119,   79,   83,   17,   87,    0,   75,   78,   22,
       81,   72,    0,   73,   72,   69,   71,    0,   70,   80,
        0,   73,   64,   77,   58,   71,    0,   65,   60,   66,
       63,   53,   51,   64,   63,   51,    0,   53,   57,   56,
        0,   47,    0,   48,   50,   49,   50,   50,   46,   44,
       40,    0,   39,   38,   37,   36,   49,   38,   43,   39,
        0,    0,    0,   36,    0,    0,   36,    0,   33,   16,

       24,    0,  119,   48,   51,   54,   29
    } ;

static aclconst short int acl_def[108] =
    {   0,
      103,    1,  103,  103,  103,  104,  103,  105,  106,  103,
      107,  103,  103,  103,  107,  107,  107,  107,  107,  107,
      107,  107,  107,  103,  104,  103,  105,  103,  106,  107,
      103,  103,  107,  107,  107,  107,  107,  107,  107,  107,
      107,  107,  107,  107,  107,  107,  107,  107,  107,  107,
      107,  107,  107,  107,  107,  107,  107,  107,  107,  107,
      107,  107,  107,  107,  107,  107,  107,  107,  107,  107,
      107,  107,  107,  107,  107,  107,  107,  107,  107,  107,
      107,  107,  107,  107,  107,  107,  107,  107,  107,  107,
      107,  107,  107,  107,  107,  107,  107,  107,  107,  107,

      107,  107,    0,  103,  103,  103,  103
    } ;

static aclconst short int acl_nxt[150] =
    {   0,
        4,    5,    6,    7,    8,    9,   10,   11,   12,   13,
       14,   15,   11,   16,   17,   11,   11,   11,   18,   11,
       11,   19,   20,   11,   11,   21,   11,   22,   23,   11,
       28,   30,   28,   33,   34,   28,   49,   28,   54,  102,
       35,  101,   36,   55,  100,   50,   37,   38,   25,   99,
       25,   27,   27,   27,   29,   98,   29,   97,   96,   95,
       94,   93,   92,   91,   90,   89,   88,   87,   86,   85,
       84,   83,   82,   81,   80,   79,   78,   77,   76,   75,
       74,   73,   72,   71,   70,   69,   68,   67,   66,   65,
       64,   63,   62,   61,   60,   59,   58,   57,   56,   53,

       52,   51,   48,   47,   24,   46,   45,   44,   43,   42,
       41,   40,   39,   32,   31,   26,   24,  103,    3,  103,
      103,  103,  103,  103,  103,  103,  103,  103,  103,  103,
      103,  103,  103,  103,  103,  103,  103,  103,  103,  103,
      103,  103,  103,  103,  103,  103,  103,  103,  103
    } ;

static aclconst short int acl_chk[150] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        8,  107,    8,   15,   15,   27,   35,   27,   40,  101,
       15,  100,   15,   40,   99,   35,   15,   15,  104,   97,
      104,  105,  105,  105,  106,   94,  106,   90,   89,   88,
       87,   86,   85,   84,   83,   81,   80,   79,   78,   77,
       76,   75,   74,   72,   70,   69,   68,   66,   65,   64,
       63,   62,   61,   60,   59,   58,   56,   55,   54,   53,
       52,   50,   49,   47,   46,   45,   44,   42,   41,   39,

       38,   36,   34,   33,   24,   23,   22,   21,   20,   19,
       18,   17,   16,   14,   12,    7,    5,    3,  103,  103,
      103,  103,  103,  103,  103,  103,  103,  103,  103,  103,
      103,  103,  103,  103,  103,  103,  103,  103,  103,  103,
      103,  103,  103,  103,  103,  103,  103,  103,  103
    } ;

static acl_state_type acl_last_accepting_state;
static char *acl_last_accepting_cpos;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define aclmore() aclmore_used_but_not_detected
#define ACL_MORE_ADJ 0
#define ACL_RESTORE_ACL_MORE_OFFSET
char *acltext;
#line 1 "aclscan.l"
#define INITIAL 0
/*
 * Lexical analyzer for ACL
 */
#line 6 "aclscan.l"
#include "acl.tab.h"	/* token codes */
#include <base/file.h>
#include <libaccess/acl.h>
#include <libaccess/nserror.h>
#include "aclpriv.h"
#include <string.h>
#include <stdio.h>
#include <ctype.h>
#include <libaccess/aclerror.h>
#ifdef XP_WIN32
#include <io.h>
#endif
#include "plstr.h"

#include "parse.h"
#include "aclscan.h"

static int acl_scanner_input(char *buffer, int max_size);

#define ACL_NEVER_INTERACTIVE 1
#undef ACL_INPUT
#define ACL_INPUT(buf, result, max) (result = acl_scanner_input(buf, max))

static int acl_lineno;
static int acl_tokenpos;
static char acl_filename[500];
static NSErr_t *acl_errp;
static int acl_use_buffer;
static char *acl_buffer;
static int acl_buffer_length;
static int acl_buffer_offset;
static char *last_string;
static SYS_FILE acl_prfd;


#line 466 "acl.yy.cpp"

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef ACL_SKIP_ACLWRAP
#ifdef __cplusplus
extern "C" int aclwrap ACL_PROTO(( void ));
#else
extern int aclwrap ACL_PROTO(( void ));
#endif
#endif

#ifndef ACL_NO_UNPUT
static void aclunput ACL_PROTO(( int c, char *buf_ptr ));
#endif

#ifndef acltext_ptr
static void acl_flex_strncpy ACL_PROTO(( char *, aclconst char *, int ));
#endif

#ifdef ACL_NEED_STRLEN
static int acl_flex_strlen ACL_PROTO(( aclconst char * ));
#endif

#ifndef ACL_NO_INPUT
#ifdef __cplusplus
static int aclinput ACL_PROTO(( void ));
#else
static int input ACL_PROTO(( void ));
#endif
#endif

#if ACL_STACK_USED
static int acl_start_stack_ptr = 0;
static int acl_start_stack_depth = 0;
static int *acl_start_stack = 0;
#ifndef ACL_NO_PUSH_STATE
static void acl_push_state ACL_PROTO(( int new_state ));
#endif
#ifndef ACL_NO_POP_STATE
static void acl_pop_state ACL_PROTO(( void ));
#endif
#ifndef ACL_NO_TOP_STATE
static int acl_top_state ACL_PROTO(( void ));
#endif

#else
#define ACL_NO_PUSH_STATE 1
#define ACL_NO_POP_STATE 1
#define ACL_NO_TOP_STATE 1
#endif

#ifdef ACL_MALLOC_DECL
ACL_MALLOC_DECL
#else
#if __STDC__
#ifndef __cplusplus
#include <stdlib.h>
#endif
#else
/* Just try to get by without declaring the routines.  This will fail
 * miserably on non-ANSI systems for which sizeof(size_t) != sizeof(int)
 * or sizeof(void*) != sizeof(int).
 */
#endif
#endif

/* Amount of stuff to slurp up with each read. */
#ifndef ACL_READ_BUF_SIZE
#define ACL_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */

#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO (void) fwrite( acltext, aclleng, 1, aclout )
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or ACL_NULL,
 * is returned in "result".
 */
#ifndef ACL_INPUT
#define ACL_INPUT(buf,result,max_size) \
	if ( acl_current_buffer->acl_is_interactive ) \
		{ \
		int c = '*', n; \
		for ( n = 0; n < max_size && \
			     (c = getc( aclin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( aclin ) ) \
			ACL_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else if ( ((result = fread( buf, 1, max_size, aclin )) == 0) \
		  && ferror( aclin ) ) \
		ACL_FATAL_ERROR( "input in flex scanner failed" );
#endif

/* No semi-colon after return; correct usage is to write "aclterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef aclterminate
#define aclterminate() return ACL_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef ACL_START_STACK_INCR
#define ACL_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef ACL_FATAL_ERROR
#define ACL_FATAL_ERROR(msg) acl_fatal_error( msg )
#endif

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef ACL_DECL
#define ACL_DECL int acllex ACL_PROTO(( void ))
#endif

/* Code executed at the beginning of each rule, after acltext and aclleng
 * have been set up.
 */
#ifndef ACL_USER_ACTION
#define ACL_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef ACL_BREAK
#define ACL_BREAK break;
#endif

#define ACL_RULE_SETUP \
	ACL_USER_ACTION

ACL_DECL
	{
	register acl_state_type acl_current_state;
	register char *acl_cp, *acl_bp;
	register int acl_act;

#line 47 "aclscan.l"


#line 620 "acl.yy.cpp"

	if ( acl_init )
		{
		acl_init = 0;

#ifdef ACL_USER_INIT
		ACL_USER_INIT;
#endif

		if ( ! acl_start )
			acl_start = 1;	/* first start state */

		if ( ! aclin )
			aclin = stdin;

		if ( ! aclout )
			aclout = stdout;

		if ( ! acl_current_buffer )
			acl_current_buffer =
				acl_create_buffer( aclin, ACL_BUF_SIZE );

		acl_load_buffer_state();
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		acl_cp = acl_c_buf_p;

		/* Support of acltext. */
		*acl_cp = acl_hold_char;

		/* acl_bp points to the position in acl_ch_buf of the start of
		 * the current run.
		 */
		acl_bp = acl_cp;

		acl_current_state = acl_start;
acl_match:
		do
			{
			register ACL_CHAR acl_c = acl_ec[ACL_SC_TO_UI(*acl_cp)];
			if ( acl_accept[acl_current_state] )
				{
				acl_last_accepting_state = acl_current_state;
				acl_last_accepting_cpos = acl_cp;
				}
			while ( acl_chk[acl_base[acl_current_state] + acl_c] != acl_current_state )
				{
				acl_current_state = (int) acl_def[acl_current_state];
				if ( acl_current_state >= 104 )
					acl_c = acl_meta[(unsigned int) acl_c];
				}
			acl_current_state = acl_nxt[acl_base[acl_current_state] + (unsigned int) acl_c];
			++acl_cp;
			}
		while ( acl_base[acl_current_state] != 119 );

acl_find_action:
		acl_act = acl_accept[acl_current_state];
		if ( acl_act == 0 )
			{ /* have to back up */
			acl_cp = acl_last_accepting_cpos;
			acl_current_state = acl_last_accepting_state;
			acl_act = acl_accept[acl_current_state];
			}

		ACL_DO_BEFORE_ACTION;


do_action:	/* This label is used only to access EOF actions. */


		switch ( acl_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of ACL_DO_BEFORE_ACTION */
			*acl_cp = acl_hold_char;
			acl_cp = acl_last_accepting_cpos;
			acl_current_state = acl_last_accepting_state;
			goto acl_find_action;

case 1:
ACL_RULE_SETUP
#line 49 "aclscan.l"
{ 
			acl_lineno++;
			acl_tokenpos = 0;
			aclless(1);
		}
	ACL_BREAK
case 2:
ACL_RULE_SETUP
#line 55 "aclscan.l"
;
	ACL_BREAK
case 3:
ACL_RULE_SETUP
#line 57 "aclscan.l"
;
	ACL_BREAK
case ACL_STATE_EOF(INITIAL):
#line 59 "aclscan.l"
{	
			acllval.string = NULL;
			last_string = acllval.string;
			return(0);
		}
	ACL_BREAK
case 4:
ACL_RULE_SETUP
#line 65 "aclscan.l"
{ 
			acllval.string = PERM_STRDUP( acltext+1 );
			last_string = acllval.string;
			if ( acllval.string[aclleng-2] != '"' )
				fprintf(stderr, "Unterminated string\n") ;
			else
				acllval.string[aclleng-2] = '\0';
			acl_tokenpos += aclleng;
			return ACL_QSTRING_TOK;
		}
	ACL_BREAK
case 5:
ACL_RULE_SETUP
#line 77 "aclscan.l"
{ 
			last_string = NULL;
			acl_tokenpos += aclleng; 
			return ACL_ABSOLUTE_TOK; 
		}
	ACL_BREAK
case 6:
ACL_RULE_SETUP
#line 83 "aclscan.l"
{ 
			last_string = NULL;
			acl_tokenpos += aclleng; 
			return ACL_ACL_TOK; 
		}
	ACL_BREAK
case 7:
ACL_RULE_SETUP
#line 89 "aclscan.l"
{ 
			last_string = NULL;
			acl_tokenpos += aclleng; 
			return ACL_ALLOW_TOK; 
		}
	ACL_BREAK
case 8:
ACL_RULE_SETUP
#line 95 "aclscan.l"
{ 
			last_string = NULL;
			acl_tokenpos += aclleng; 
			return ACL_ALWAYS_TOK; 
		}
	ACL_BREAK
case 9:
ACL_RULE_SETUP
#line 101 "aclscan.l"
{ 
			last_string = NULL;
			acl_tokenpos += aclleng; 
			return ACL_AT_TOK; 
		}
	ACL_BREAK
case 10:
ACL_RULE_SETUP
#line 107 "aclscan.l"
{ 
			last_string = NULL;
			acl_tokenpos += aclleng; 
			return ACL_AUTHENTICATE_TOK; 
		}
	ACL_BREAK
case 11:
ACL_RULE_SETUP
#line 113 "aclscan.l"
{ 
			last_string = NULL;
			acl_tokenpos += aclleng; 
			return ACL_CONTENT_TOK; 
		}
	ACL_BREAK
case 12:
ACL_RULE_SETUP
#line 119 "aclscan.l"
{ 
			last_string = NULL;
			acl_tokenpos += aclleng; 
			return ACL_DEFAULT_TOK; 
		}
	ACL_BREAK
case 13:
ACL_RULE_SETUP
#line 125 "aclscan.l"
{ 
			last_string = NULL;
			acl_tokenpos += aclleng; 
			return ACL_DENY_TOK; 
		}
	ACL_BREAK
case 14:
ACL_RULE_SETUP
#line 131 "aclscan.l"
{ 
			last_string = NULL;
			acl_tokenpos += aclleng; 
			return ACL_IN_TOK; 
		}
	ACL_BREAK
case 15:
ACL_RULE_SETUP
#line 137 "aclscan.l"
{ 
			last_string = NULL;
			acl_tokenpos += aclleng; 
			return ACL_INHERIT_TOK; 
		}
	ACL_BREAK
case 16:
ACL_RULE_SETUP
#line 143 "aclscan.l"
{ 
			last_string = NULL;
			acl_tokenpos += aclleng; 
			return ACL_TERMINAL_TOK; 
		}
	ACL_BREAK
case 17:
ACL_RULE_SETUP
#line 149 "aclscan.l"
{ 
			last_string = NULL;
			acl_tokenpos += aclleng; 
			return ACL_VERSION_TOK; 
		}
	ACL_BREAK
case 18:
ACL_RULE_SETUP
#line 155 "aclscan.l"
{ 
			last_string = NULL;
			acl_tokenpos += aclleng; 
			return ACL_WITH_TOK; 
		}
	ACL_BREAK
case 19:
ACL_RULE_SETUP
#line 161 "aclscan.l"
{ 
			last_string = NULL;
			acl_tokenpos += aclleng; 
			return ACL_NOT_TOK; 
		}
	ACL_BREAK
case 20:
ACL_RULE_SETUP
#line 167 "aclscan.l"
{ 
			last_string = NULL;
			acllval.ival = ACL_EXPR_OP_AND;
			acl_tokenpos += aclleng; 
			return ACL_AND_TOK; 
		}
	ACL_BREAK
case 21:
ACL_RULE_SETUP
#line 174 "aclscan.l"
{ 
			last_string = NULL;
			acllval.ival = ACL_EXPR_OP_OR;
			acl_tokenpos += aclleng; 
			return ACL_OR_TOK; 
		}
	ACL_BREAK
case 22:
ACL_RULE_SETUP
#line 181 "aclscan.l"
{ 
			last_string = NULL;
			acllval.ival = CMP_OP_EQ;
			acl_tokenpos += aclleng; 
			return ACL_EQ_TOK; 
		}
	ACL_BREAK
case 23:
ACL_RULE_SETUP
#line 188 "aclscan.l"
{ 
			last_string = NULL;
			acllval.ival = CMP_OP_GE; 
			acl_tokenpos += aclleng; 
			return ACL_GE_TOK; 
		}
	ACL_BREAK
case 24:
ACL_RULE_SETUP
#line 195 "aclscan.l"
{ 
			last_string = NULL;
			acllval.ival = CMP_OP_GT; 
			acl_tokenpos += aclleng; 
			return ACL_GT_TOK; 
		}
	ACL_BREAK
case 25:
ACL_RULE_SETUP
#line 202 "aclscan.l"
{ 	
			last_string = NULL;
			acllval.ival = CMP_OP_LT; 
			acl_tokenpos += aclleng; 
			return ACL_LT_TOK; 
		}
	ACL_BREAK
case 26:
ACL_RULE_SETUP
#line 209 "aclscan.l"
{ 
			last_string = NULL;
			acllval.ival = CMP_OP_LE; 
			acl_tokenpos += aclleng; 
			return ACL_LE_TOK; 
		}
	ACL_BREAK
case 27:
ACL_RULE_SETUP
#line 216 "aclscan.l"
{ 
			last_string = NULL;
			acllval.ival = CMP_OP_NE;
			acl_tokenpos += aclleng; 
			return ACL_NE_TOK; 
		}
	ACL_BREAK
case 28:
ACL_RULE_SETUP
#line 223 "aclscan.l"
{ 
			last_string = NULL;
			acl_tokenpos += aclleng; 
			return acltext[0]; 
		}
	ACL_BREAK
case 29:
ACL_RULE_SETUP
#line 229 "aclscan.l"
{ 
			acl_tokenpos += aclleng; 
			acllval.string = PERM_STRDUP( acltext );
			last_string = acllval.string;
			return ACL_VARIABLE_TOK;
		}
	ACL_BREAK
case 30:
ACL_RULE_SETUP
#line 235 "aclscan.l"
ECHO;
	ACL_BREAK
#line 983 "acl.yy.cpp"

	case ACL_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int acl_amount_of_matched_text = (int) (acl_cp - acltext_ptr) - 1;

		/* Undo the effects of ACL_DO_BEFORE_ACTION. */
		*acl_cp = acl_hold_char;
		ACL_RESTORE_ACL_MORE_OFFSET

		if ( acl_current_buffer->acl_buffer_status == ACL_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed aclin at a new source and called
			 * acllex().  If so, then we have to assure
			 * consistency between acl_current_buffer and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			acl_n_chars = acl_current_buffer->acl_n_chars;
			acl_current_buffer->acl_input_file = aclin;
			acl_current_buffer->acl_buffer_status = ACL_BUFFER_NORMAL;
			}

		/* Note that here we test for acl_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since acl_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( acl_c_buf_p <= &acl_current_buffer->acl_ch_buf[acl_n_chars] )
			{ /* This was really a NUL. */
			acl_state_type acl_next_state;

			acl_c_buf_p = acltext_ptr + acl_amount_of_matched_text;

			acl_current_state = acl_get_previous_state();

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * acl_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			acl_next_state = acl_try_NUL_trans( acl_current_state );

			acl_bp = acltext_ptr + ACL_MORE_ADJ;

			if ( acl_next_state )
				{
				/* Consume the NUL. */
				acl_cp = ++acl_c_buf_p;
				acl_current_state = acl_next_state;
				goto acl_match;
				}

			else
				{
				acl_cp = acl_c_buf_p;
				goto acl_find_action;
				}
			}

		else switch ( acl_get_next_buffer() )
			{
			case EOB_ACT_END_OF_FILE:
				{
				acl_did_buffer_switch_on_eof = 0;

				if ( aclwrap() )
					{
					/* Note: because we've taken care in
					 * acl_get_next_buffer() to have set up
					 * acltext, we can now set up
					 * acl_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * ACL_NULL, it'll still work - another
					 * ACL_NULL will get returned.
					 */
					acl_c_buf_p = acltext_ptr + ACL_MORE_ADJ;

					acl_act = ACL_STATE_EOF(ACL_START);
					goto do_action;
					}

				else
					{
					if ( ! acl_did_buffer_switch_on_eof )
						ACL_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				acl_c_buf_p =
					acltext_ptr + acl_amount_of_matched_text;

				acl_current_state = acl_get_previous_state();

				acl_cp = acl_c_buf_p;
				acl_bp = acltext_ptr + ACL_MORE_ADJ;
				goto acl_match;

			case EOB_ACT_LAST_MATCH:
				acl_c_buf_p =
				&acl_current_buffer->acl_ch_buf[acl_n_chars];

				acl_current_state = acl_get_previous_state();

				acl_cp = acl_c_buf_p;
				acl_bp = acltext_ptr + ACL_MORE_ADJ;
				goto acl_find_action;
			}
		break;
		}

	default:
		ACL_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of acllex */


/* acl_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */

static int acl_get_next_buffer()
	{
	register char *dest = acl_current_buffer->acl_ch_buf;
	register char *source = acltext_ptr;
	register int number_to_move, i;
	int ret_val;

	if ( acl_c_buf_p > &acl_current_buffer->acl_ch_buf[acl_n_chars + 1] )
		ACL_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( acl_current_buffer->acl_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( acl_c_buf_p - acltext_ptr - ACL_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) (acl_c_buf_p - acltext_ptr) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( acl_current_buffer->acl_buffer_status == ACL_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		acl_n_chars = 0;

	else
		{
		int num_to_read =
			acl_current_buffer->acl_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */
#ifdef ACL_USES_REJECT
			ACL_FATAL_ERROR(
"input buffer overflow, can't enlarge buffer because scanner uses REJECT" );
#else

			/* just a shorter name for the current buffer */
			ACL_BUFFER_STATE b = acl_current_buffer;

			int acl_c_buf_p_offset =
				(int) (acl_c_buf_p - b->acl_ch_buf);

			if ( b->acl_is_our_buffer )
				{
				int new_size = b->acl_buf_size * 2;

				if ( new_size <= 0 )
					b->acl_buf_size += b->acl_buf_size / 8;
				else
					b->acl_buf_size *= 2;

				b->acl_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					ACL_FLEX_REALLOC( (void *) b->acl_ch_buf,
							 b->acl_buf_size + 2 );
				}
			else
				/* Can't grow it, we don't own it. */
				b->acl_ch_buf = 0;

			if ( ! b->acl_ch_buf )
				ACL_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			acl_c_buf_p = &b->acl_ch_buf[acl_c_buf_p_offset];

			num_to_read = acl_current_buffer->acl_buf_size -
						number_to_move - 1;
#endif
			}

		if ( num_to_read > ACL_READ_BUF_SIZE )
			num_to_read = ACL_READ_BUF_SIZE;

		/* Read in more data. */
		ACL_INPUT( (&acl_current_buffer->acl_ch_buf[number_to_move]),
			acl_n_chars, num_to_read );
		}

	if ( acl_n_chars == 0 )
		{
		if ( number_to_move == ACL_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			aclrestart( aclin );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			acl_current_buffer->acl_buffer_status =
				ACL_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	acl_n_chars += number_to_move;
	acl_current_buffer->acl_ch_buf[acl_n_chars] = ACL_END_OF_BUFFER_CHAR;
	acl_current_buffer->acl_ch_buf[acl_n_chars + 1] = ACL_END_OF_BUFFER_CHAR;

	acltext_ptr = &acl_current_buffer->acl_ch_buf[0];

	return ret_val;
	}


/* acl_get_previous_state - get the state just before the EOB char was reached */

static acl_state_type acl_get_previous_state()
	{
	register acl_state_type acl_current_state;
	register char *acl_cp;

	acl_current_state = acl_start;

	for ( acl_cp = acltext_ptr + ACL_MORE_ADJ; acl_cp < acl_c_buf_p; ++acl_cp )
		{
		register ACL_CHAR acl_c = (*acl_cp ? acl_ec[ACL_SC_TO_UI(*acl_cp)] : 1);
		if ( acl_accept[acl_current_state] )
			{
			acl_last_accepting_state = acl_current_state;
			acl_last_accepting_cpos = acl_cp;
			}
		while ( acl_chk[acl_base[acl_current_state] + acl_c] != acl_current_state )
			{
			acl_current_state = (int) acl_def[acl_current_state];
			if ( acl_current_state >= 104 )
				acl_c = acl_meta[(unsigned int) acl_c];
			}
		acl_current_state = acl_nxt[acl_base[acl_current_state] + (unsigned int) acl_c];
		}

	return acl_current_state;
	}


/* acl_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = acl_try_NUL_trans( current_state );
 */

#ifdef ACL_USE_PROTOS
static acl_state_type acl_try_NUL_trans( acl_state_type acl_current_state )
#else
static acl_state_type acl_try_NUL_trans( acl_current_state )
acl_state_type acl_current_state;
#endif
	{
	register int acl_is_jam;
	register char *acl_cp = acl_c_buf_p;

	register ACL_CHAR acl_c = 1;
	if ( acl_accept[acl_current_state] )
		{
		acl_last_accepting_state = acl_current_state;
		acl_last_accepting_cpos = acl_cp;
		}
	while ( acl_chk[acl_base[acl_current_state] + acl_c] != acl_current_state )
		{
		acl_current_state = (int) acl_def[acl_current_state];
		if ( acl_current_state >= 104 )
			acl_c = acl_meta[(unsigned int) acl_c];
		}
	acl_current_state = acl_nxt[acl_base[acl_current_state] + (unsigned int) acl_c];
	acl_is_jam = (acl_current_state == 103);

	return acl_is_jam ? 0 : acl_current_state;
	}


#ifndef ACL_NO_UNPUT
#ifdef ACL_USE_PROTOS
static void aclunput( int c, register char *acl_bp )
#else
static void aclunput( c, acl_bp )
int c;
register char *acl_bp;
#endif
	{
	register char *acl_cp = acl_c_buf_p;

	/* undo effects of setting up acltext */
	*acl_cp = acl_hold_char;

	if ( acl_cp < acl_current_buffer->acl_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		register int number_to_move = acl_n_chars + 2;
		register char *dest = &acl_current_buffer->acl_ch_buf[
					acl_current_buffer->acl_buf_size + 2];
		register char *source =
				&acl_current_buffer->acl_ch_buf[number_to_move];

		while ( source > acl_current_buffer->acl_ch_buf )
			*--dest = *--source;

		acl_cp += (int) (dest - source);
		acl_bp += (int) (dest - source);
		acl_n_chars = acl_current_buffer->acl_buf_size;

		if ( acl_cp < acl_current_buffer->acl_ch_buf + 2 )
			ACL_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--acl_cp = (char) c;


	acltext_ptr = acl_bp;
	acl_hold_char = *acl_cp;
	acl_c_buf_p = acl_cp;
	}
#endif	/* ifndef ACL_NO_UNPUT */


#ifdef __cplusplus
static int aclinput()
#else
static int input()
#endif
	{
	int c;

	*acl_c_buf_p = acl_hold_char;

	if ( *acl_c_buf_p == ACL_END_OF_BUFFER_CHAR )
		{
		/* acl_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( acl_c_buf_p < &acl_current_buffer->acl_ch_buf[acl_n_chars] )
			/* This was really a NUL. */
			*acl_c_buf_p = '\0';

		else
			{ /* need more input */
			int offset = acl_c_buf_p - acltext_ptr;
			++acl_c_buf_p;

			switch ( acl_get_next_buffer() )
				{
				case EOB_ACT_END_OF_FILE:
					{
					if ( aclwrap() )
						{
						acl_c_buf_p = acltext_ptr + offset;
						return EOF;
						}

					if ( ! acl_did_buffer_switch_on_eof )
						ACL_NEW_FILE;
#ifdef __cplusplus
					return aclinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					acl_c_buf_p = acltext_ptr + offset;
					break;

				case EOB_ACT_LAST_MATCH:
#ifdef __cplusplus
					ACL_FATAL_ERROR(
					"unexpected last match in aclinput()" );
#else
					ACL_FATAL_ERROR(
					"unexpected last match in input()" );
#endif
				}
			}
		}

	c = *(unsigned char *) acl_c_buf_p;	/* cast for 8-bit char's */
	*acl_c_buf_p = '\0';	/* preserve acltext */
	acl_hold_char = *++acl_c_buf_p;


	return c;
	}


#ifdef ACL_USE_PROTOS
void aclrestart( FILE *input_file )
#else
void aclrestart( input_file )
FILE *input_file;
#endif
	{
	if ( ! acl_current_buffer )
		acl_current_buffer = acl_create_buffer( aclin, ACL_BUF_SIZE );

	acl_init_buffer( acl_current_buffer, input_file );
	acl_load_buffer_state();
	}


#ifdef ACL_USE_PROTOS
void acl_switch_to_buffer( ACL_BUFFER_STATE new_buffer )
#else
void acl_switch_to_buffer( new_buffer )
ACL_BUFFER_STATE new_buffer;
#endif
	{
	if ( acl_current_buffer == new_buffer )
		return;

	if ( acl_current_buffer )
		{
		/* Flush out information for old buffer. */
		*acl_c_buf_p = acl_hold_char;
		acl_current_buffer->acl_buf_pos = acl_c_buf_p;
		acl_current_buffer->acl_n_chars = acl_n_chars;
		}

	acl_current_buffer = new_buffer;
	acl_load_buffer_state();

	/* We don't actually know whether we did this switch during
	 * EOF (aclwrap()) processing, but the only time this flag
	 * is looked at is after aclwrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	acl_did_buffer_switch_on_eof = 1;
	}


#ifdef ACL_USE_PROTOS
void acl_load_buffer_state( void )
#else
void acl_load_buffer_state()
#endif
	{
	acl_n_chars = acl_current_buffer->acl_n_chars;
	acltext_ptr = acl_c_buf_p = acl_current_buffer->acl_buf_pos;
	aclin = acl_current_buffer->acl_input_file;
	acl_hold_char = *acl_c_buf_p;
	}


#ifdef ACL_USE_PROTOS
ACL_BUFFER_STATE acl_create_buffer( FILE *file, int size )
#else
ACL_BUFFER_STATE acl_create_buffer( file, size )
FILE *file;
int size;
#endif
	{
	ACL_BUFFER_STATE b;

	b = (ACL_BUFFER_STATE) ACL_FLEX_ALLOC( sizeof( struct acl_buffer_state ) );
	if ( ! b )
		ACL_FATAL_ERROR( "out of dynamic memory in acl_create_buffer()" );

	b->acl_buf_size = size;

	/* acl_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->acl_ch_buf = (char *) ACL_FLEX_ALLOC( b->acl_buf_size + 2 );
	if ( ! b->acl_ch_buf )
		ACL_FATAL_ERROR( "out of dynamic memory in acl_create_buffer()" );

	b->acl_is_our_buffer = 1;

	acl_init_buffer( b, file );

	return b;
	}


#ifdef ACL_USE_PROTOS
void acl_delete_buffer( ACL_BUFFER_STATE b )
#else
void acl_delete_buffer( b )
ACL_BUFFER_STATE b;
#endif
	{
	if ( ! b )
		return;

	if ( b == acl_current_buffer )
		acl_current_buffer = (ACL_BUFFER_STATE) 0;

	if ( b->acl_is_our_buffer )
		ACL_FLEX_FREE( (void *) b->acl_ch_buf );

	ACL_FLEX_FREE( (void *) b );
	}


#ifndef ACL_ALWAYS_INTERACTIVE
#ifndef ACL_NEVER_INTERACTIVE
extern int isatty ACL_PROTO(( int ));
#endif
#endif

#ifdef ACL_USE_PROTOS
void acl_init_buffer( ACL_BUFFER_STATE b, FILE *file )
#else
void acl_init_buffer( b, file )
ACL_BUFFER_STATE b;
FILE *file;
#endif


	{
	acl_flush_buffer( b );

	b->acl_input_file = file;
	b->acl_fill_buffer = 1;

#if ACL_ALWAYS_INTERACTIVE
	b->acl_is_interactive = 1;
#else
#if ACL_NEVER_INTERACTIVE
	b->acl_is_interactive = 0;
#else
	b->acl_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
#endif
#endif
	}


#ifdef ACL_USE_PROTOS
void acl_flush_buffer( ACL_BUFFER_STATE b )
#else
void acl_flush_buffer( b )
ACL_BUFFER_STATE b;
#endif

	{
	b->acl_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->acl_ch_buf[0] = ACL_END_OF_BUFFER_CHAR;
	b->acl_ch_buf[1] = ACL_END_OF_BUFFER_CHAR;

	b->acl_buf_pos = &b->acl_ch_buf[0];

	b->acl_at_bol = 1;
	b->acl_buffer_status = ACL_BUFFER_NEW;

	if ( b == acl_current_buffer )
		acl_load_buffer_state();
	}


#ifndef ACL_NO_SCAN_BUFFER
#ifdef ACL_USE_PROTOS
ACL_BUFFER_STATE acl_scan_buffer( char *base, acl_size_t size )
#else
ACL_BUFFER_STATE acl_scan_buffer( base, size )
char *base;
acl_size_t size;
#endif
	{
	ACL_BUFFER_STATE b;

	if ( size < 2 ||
	     base[size-2] != ACL_END_OF_BUFFER_CHAR ||
	     base[size-1] != ACL_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (ACL_BUFFER_STATE) ACL_FLEX_ALLOC( sizeof( struct acl_buffer_state ) );
	if ( ! b )
		ACL_FATAL_ERROR( "out of dynamic memory in acl_scan_buffer()" );

	b->acl_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->acl_buf_pos = b->acl_ch_buf = base;
	b->acl_is_our_buffer = 0;
	b->acl_input_file = 0;
	b->acl_n_chars = b->acl_buf_size;
	b->acl_is_interactive = 0;
	b->acl_at_bol = 1;
	b->acl_fill_buffer = 0;
	b->acl_buffer_status = ACL_BUFFER_NEW;

	acl_switch_to_buffer( b );

	return b;
	}
#endif


#ifndef ACL_NO_SCAN_STRING
#ifdef ACL_USE_PROTOS
ACL_BUFFER_STATE acl_scan_string( aclconst char *str )
#else
ACL_BUFFER_STATE acl_scan_string( str )
aclconst char *str;
#endif
	{
	int len;
	for ( len = 0; str[len]; ++len )
		;

	return acl_scan_bytes( str, len );
	}
#endif


#ifndef ACL_NO_SCAN_BYTES
#ifdef ACL_USE_PROTOS
ACL_BUFFER_STATE acl_scan_bytes( aclconst char *bytes, int len )
#else
ACL_BUFFER_STATE acl_scan_bytes( bytes, len )
aclconst char *bytes;
int len;
#endif
	{
	ACL_BUFFER_STATE b;
	char *buf;
	acl_size_t n;
	int i;

	/* Get memory for full buffer, including space for trailing EOB's. */
	n = len + 2;
	buf = (char *) ACL_FLEX_ALLOC( n );
	if ( ! buf )
		ACL_FATAL_ERROR( "out of dynamic memory in acl_scan_bytes()" );

	for ( i = 0; i < len; ++i )
		buf[i] = bytes[i];

	buf[len] = buf[len+1] = ACL_END_OF_BUFFER_CHAR;

	b = acl_scan_buffer( buf, n );
	if ( ! b )
		ACL_FATAL_ERROR( "bad buffer in acl_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->acl_is_our_buffer = 1;

	return b;
	}
#endif


#ifndef ACL_NO_PUSH_STATE
#ifdef ACL_USE_PROTOS
static void acl_push_state( int new_state )
#else
static void acl_push_state( new_state )
int new_state;
#endif
	{
	if ( acl_start_stack_ptr >= acl_start_stack_depth )
		{
		acl_size_t new_size;

		acl_start_stack_depth += ACL_START_STACK_INCR;
		new_size = acl_start_stack_depth * sizeof( int );

		if ( ! acl_start_stack )
			acl_start_stack = (int *) ACL_FLEX_ALLOC( new_size );

		else
			acl_start_stack = (int *) ACL_FLEX_REALLOC(
					(void *) acl_start_stack, new_size );

		if ( ! acl_start_stack )
			ACL_FATAL_ERROR(
			"out of memory expanding start-condition stack" );
		}

	acl_start_stack[acl_start_stack_ptr++] = ACL_START;

	BEGIN(new_state);
	}
#endif


#ifndef ACL_NO_POP_STATE
static void acl_pop_state()
	{
	if ( --acl_start_stack_ptr < 0 )
		ACL_FATAL_ERROR( "start-condition stack underflow" );

	BEGIN(acl_start_stack[acl_start_stack_ptr]);
	}
#endif


#ifndef ACL_NO_TOP_STATE
static int acl_top_state()
	{
	return acl_start_stack[acl_start_stack_ptr - 1];
	}
#endif

#ifndef ACL_EXIT_FAILURE
#define ACL_EXIT_FAILURE 2
#endif

#ifdef ACL_USE_PROTOS
static void acl_fatal_error( aclconst char msg[] )
#else
static void acl_fatal_error( msg )
char msg[];
#endif
	{
	(void) fprintf( stderr, "%s\n", msg );
	exit( ACL_EXIT_FAILURE );
	}



/* Redefine aclless() so it works in section 3 code. */

#undef aclless
#define aclless(n) \
	do \
		{ \
		/* Undo effects of setting up acltext. */ \
		acltext[aclleng] = acl_hold_char; \
		acl_c_buf_p = acltext + n; \
		acl_hold_char = *acl_c_buf_p; \
		*acl_c_buf_p = '\0'; \
		aclleng = n; \
		} \
	while ( 0 )


/* Internal utility routines. */

#ifndef acltext_ptr
#ifdef ACL_USE_PROTOS
static void acl_flex_strncpy( char *s1, aclconst char *s2, int n )
#else
static void acl_flex_strncpy( s1, s2, n )
char *s1;
aclconst char *s2;
int n;
#endif
	{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
	}
#endif

#ifdef ACL_NEED_STRLEN
#ifdef ACL_USE_PROTOS
static int acl_flex_strlen( aclconst char *s )
#else
static int acl_flex_strlen( s )
aclconst char *s;
#endif
	{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
	}
#endif


#ifdef ACL_USE_PROTOS
static void *ACL_FLEX_ALLOC( acl_size_t size )
#else
static void *ACL_FLEX_ALLOC( size )
acl_size_t size;
#endif
	{
	return (void *) PERM_MALLOC( size );
	}

#ifdef ACL_USE_PROTOS
static void *ACL_FLEX_REALLOC( void *ptr, acl_size_t size )
#else
static void *ACL_FLEX_REALLOC( ptr, size )
void *ptr;
acl_size_t size;
#endif
	{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) PERM_REALLOC( (char *) ptr, size );
	}

#ifdef ACL_USE_PROTOS
static void ACL_FLEX_FREE( void *ptr )
#else
static void ACL_FLEX_FREE( ptr )
void *ptr;
#endif
	{
	PERM_FREE( ptr );
	}

#if ACL_MAIN
int main()
	{
	acllex();
	return 0;
	}
#endif
#line 235 "aclscan.l"


void
acl_detab(char *t, char *s)
{
	int	ii;
	int	pos;
	int	len;

	if (s == NULL || t == NULL) 
		return;

	len = strlen(s);
	pos = 0;
	for (ii = 0; ii < len; ii++) {
		if (s[ii] == '\t') {
			t[pos] = ' ';
		} else {
			t[pos] = s[ii];
		}
		pos++;
	}
	t[pos] = '\0';
	return;
}

void
aclerror(const char *s)
{
char	errorStr[256];

#if defined(UTEST) || defined(ACL_COMPILER)
	printf("ACL file: %s\n", acl_filename);
	printf("Syntax error at line: %d, token: %s\n", acl_lineno, acltext);
	if ( last_string )
		PERM_FREE(last_string);
#else
	sprintf(errorStr, "%d", acl_lineno);
	if (acltext) {
		nserrGenerate(acl_errp, ACLERRPARSE, ACLERR1780, ACL_Program,
                      3, acl_filename, errorStr, acltext);
	} else {
		nserrGenerate(acl_errp, ACLERRPARSE, ACLERR1780, ACL_Program,
                      2, acl_filename, errorStr);
	}
	if ( last_string )
		PERM_FREE(last_string);
#endif

}

int
acl_InitScanner(NSErr_t *errp, char *filename, char *buffer)
{
	acl_errp = errp;
	acl_lineno = 1;
	acl_use_buffer = (filename == NULL) ? 1 : 0 ;
	if ( filename != NULL ) {
		PL_strncpyz(acl_filename, filename, sizeof(acl_filename));
#ifdef UTEST
		aclin = fopen(filename, "r");
		if ( aclin == NULL ) {
			return(-1);
		}
#else
		acl_prfd = system_fopenRO(filename);
		if ( acl_prfd == NULL ) {
			return(-1);
		}
		aclin = (FILE *) acl_prfd;
#endif
		aclrestart(aclin);
	} else if ( buffer != NULL ) {
		strcpy(acl_filename, "internal-buffer");
		acl_buffer_offset = 0;
		acl_buffer_length = strlen(buffer);
		acl_buffer = PERM_STRDUP(buffer);
		if (acl_buffer == NULL)
			return(-1);
                aclrestart(NULL);
        } else {
		return(-1);
        }
	return(0);
}

int
acl_EndScanner()
{
	acl_lineno = 0;
	if ( acl_use_buffer) {
		if ( acl_buffer )
			PERM_FREE(acl_buffer);
        } else if ( aclin ) {
#ifdef UTEST
		fclose(aclin);
#else
		if ( acl_prfd ) {
			system_fclose(acl_prfd);
			acl_prfd = NULL;
		}
#endif
		aclin = NULL ;
	}
	return(0);
}

int
aclwrap()
{
	return(1);
}

static int
acl_scanner_input(char *buffer, int max_size)
{
	int len = 0;

        if ( acl_use_buffer ) {
		len = (acl_buffer_length > max_size) ? max_size : 
                                                       acl_buffer_length;
		memcpy(buffer, (const void *) &acl_buffer[acl_buffer_offset], 
                       len);
		acl_buffer_length -= len;
		acl_buffer_offset += len;
        }
#ifdef UTEST
        else if ( ((len = fread( buffer, 1, max_size, aclin )) == 0) 
                    && ferror( aclin ) ) { 
                aclerror( "scanner input failed" );
	}
#else
        else if ( (len = system_fread( acl_prfd, buffer, max_size)) < 0 ) { 
                aclerror( "scanner input failed" );
	}
#endif

	return(len);
}
