# The following targets are for the maintainer only! do no run if you don't
# know what they do.

.PHONY: printchanges insertchanges startnewrelease help

help:
	@echo "These are the targets in addition to the normal debian ones:"
	@echo
	@echo "  printenv        : Print some variables used in the build"
	@echo
	@echo "  printchanges    : Print the current changelog entries (from git)"
	@echo
	@echo "  insertchanges   : Insert current changelog entries (from git)"
	@echo
	@echo "  startnewrelease : Start a new changelog set"
	@echo
	@echo "  build-orig-source: Creates the orig tarball after doing some"
	@echo "                     binary changes"
	@echo
	@echo "  help            : If you are kernel hacking, you need the professional"
	@echo "                    version of this"
	@echo
	@echo "Environment variables:"
	@echo
	@echo "  NOKERNLOG       : Do not add upstream kernel commits to changelog"
	@echo "  CONCURRENCY_LEVEL=X"
	@echo "                  : Use -jX for kernel compile"
	@echo "  PRINTSHAS       : Include SHAs for commits in changelog"

ARCH_CONFIGS=i386 amd64 ia64 hppa powerpc sparc

printenv-e:
	@dh_testdir
	@echo "pkgname            = $(pkgname)"
	@echo "lrm_versions       = $(lrm_versions)"
	@echo "lrm_version        = $(lrm_version)"
	@echo "prev_lrm_versions  = $(prev_lrm_versions)"
	@echo "prev_lrm_version   = $(prev_lrm_version)"
	@echo "abi_version        = $(abi_version)"
	@echo "kernel_abi_version = $(kernel_abi_version)"
	@echo "gitver             = $(gitver)"

printchanges:
	@git log Ubuntu-$(prev_lrm_version)..HEAD | \
		perl -w -f debian/scripts/misc/git-ubuntu-log $(ubuntu_log_opts)

insertchanges:
	@perl -w -f debian/scripts/misc/insert-changes.pl

startnewrelease:
	dh_testdir
	@newversion=$$(echo $(lrm_version) | awk -F. '{ \
			V = ""; \
			for (i=1; i < NF; i++) \
				V = V $$i "."; \
			print V ($$NF + 1); \
	}'); \
	now="$$(date -R)"; \
	echo "Creating new changelog set for $$newversion..."; \
	echo "$(pkgname) ($$newversion) UNRELEASED; urgency=low" \
		>debian/changelog.new; \
	echo "" >>debian/changelog.new; \
	echo "  CHANGELOG: Do not edit directly. Autogenerated at release." \
		>>debian/changelog.new; \
	echo "  CHANGELOG: Use the printchanges target to see the curent changes." \
		>>debian/changelog.new; \
	echo "  CHANGELOG: Use the insertchanges target to create the final log." \
		>>debian/changelog.new; \
	echo "" >>debian/changelog.new; \
	echo " -- $$DEBFULLNAME <$$DEBEMAIL>  $$now" >>debian/changelog.new; \
	echo "" >>debian/changelog.new; \
	cat debian/changelog >> debian/changelog.new; \
	mv debian/changelog.new debian/changelog

