#ifndef __COMPAT_TIMER_H__
#   define __COMPAT_TIMER_H__


/*
 * The del_timer_sync() API appeared in 2.3.43
 * It became reliable in 2.4.0-test3
 *
 *   --hpreg
 */
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 4, 0)
#   define compat_del_timer_sync(timer) del_timer_sync(timer)
#else
#   include <asm/softirq.h>

static inline int
compat_del_timer_sync(struct timer_list *timer) // IN
{
   int wasPending;

   start_bh_atomic();
   wasPending = del_timer(timer);
   end_bh_atomic();

   return wasPending;
}
#endif


#endif /* __COMPAT_TIMER_H__ */
