/* **********************************************************
 * Copyright 1998 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

/*
 * cpNameInt.h --
 *
 *    Cross-platform name format used by hgfs.
 *
 */


#ifndef __CP_NAME_INT_H__
#define __CP_NAME_INT_H__


#include "vm_basic_types.h"

/*
 * Used by CPName_ConvertFrom
 */
int
CPNameConvertFrom(char const **bufIn, // IN/OUT: Input to convert
                  uint32 *inSize,     // IN/OUT: Size of input
                  uint32 *outSize,    // IN/OUT: Size of output buffer
                  char **bufOut,      // IN/OUT: Output buffer
                  char pathSep);      // IN: Path separator character


/*
 * Common code for CPName_ConvertTo
 */
int
CPNameConvertTo(char const *nameIn, // IN:  Buf to convert
                uint32 bufOutSize,  // IN:  Size of the output buffer
                char *bufOut,       // OUT: Output buffer
                char pathSep,       // IN:  path separator to use
                char *ignores);     // IN:  chars to not transfer to output

#endif /* __CP_NAME_INT_H__ */
