#ifndef __COMPAT_FILE_H__
#   define __COMPAT_FILE_H__


/* The fput() API is modified in 2.2.0 --hpreg */
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 2, 0)
#   define compat_fput(_file) fput(_file)
#else
#   define compat_fput(_file) fput(_file, (_file)->f_inode)
#endif


#if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 4, 0)
#   define compat_get_file(_file) get_file(_file)
#   define compat_file_count(_file) file_count(_file)
#else
#   define compat_get_file(_file) (_file)->f_count++
#   define compat_file_count(_file) (_file)->f_count
#endif


#if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 2, 4)
#   define compat_filp_close(_file, _files) filp_close(_file, _files)
#else
static inline void compat_filp_close(struct file* filp, fl_owner_t files) {
   if (filp->f_op && filp->f_op->flush) {
      filp->f_op->flush(filp);
   }
   /*
    * Hopefully there are no locks to release on this filp. 
    * locks_remove_posix is not exported so we cannot use it...
    */
   fput(filp);
}
#endif


#endif /* __COMPAT_FILE_H__ */
