#!/usr/bin/env python

# Copyright (2) 2002-2008 Userful Corporation. Allrights reserved.
# http://www.userful.com

# file: umx-storage-update-polkit-config.py
import libxml2
import sys

action_ids = ("org.freedesktop.hal.storage.mount-removable", "org.freedesktop.hal.storage.eject")

##########################################################
# Add a match element after elem with 'action=id' property
##########################################################
def add_action_match_element(root_elem, elem, id):

    if elem:
        # add empty text string for readability
        empty_text = libxml2.newText('\n    ')
        elem.addNextSibling(empty_text)

        # add match element
        newNode = libxml2.newNode('match')
        newNode.setProp('action', id)
        empty_text.addNextSibling(newNode)

        # add return element
        childNode = libxml2.newNode('return')
        childNode.setProp('result', 'yes')
        newNode.addChild(childNode)

    # empty PolicyKit.conf file. 
    # Add action element into root_elem
    else:
        # add match element
        newNode = libxml2.newNode('match')
        newNode.setProp('action', id)
        root_elem.addChild(newNode)

        # add return element
        childNode = libxml2.newNode('return')
        childNode.setProp('result', 'yes')
        newNode.addChild(childNode)

        # add empty text string for readability
        empty_text = libxml2.newText('    ')
        newNode.addPrevSibling(empty_text)

        newline_text = libxml2.newText('\n')
        newNode.addNextSibling(newline_text)

#####################################################################################
# Update PolicyKit.conf to enable mounting of removable storage and ejecting of CDROM
#####################################################################################
def update_polkit_conf(config_file):
    doc = libxml2.parseFile(config_file)
    if doc.name != config_file:
        print "doc.name failed"
        sys.exit(1)

    # Getting root element from PolicyKit.conf
    root_elem = doc.getRootElement()

    # Getting every match elements from PolicyKit.conf
    match_elem = doc.xpathEval('//match')

    for id in action_ids:

        id_found = False

        elem = None
        for elem in match_elem:

            # Check if elem has 'action' property.
            # If then, compare the content with id
            if elem.hasProp('action') and elem.prop('action') == id:

                # Search for an element having 'result' property and set 'yes' for its content
                child = elem.children
                while child is not None:
                    #print child.name
                    if child.type == "element" and child.name == 'return' and child.hasProp('result'):
                        child.setProp('result', 'yes')
                        #print child.properties

                    child = child.next

                id_found = True
                break
            else:
                pass
        
        if not id_found:
            # Current action id is NOT found on any match elements
            # add a new match element with a action property
            add_action_match_element(root_elem, elem, id)

    # Update PolicyKit.conf
    fd = open(config_file, 'w')
    doc.saveTo(fd)
    fd.close

    doc.freeDoc()
    return

def main():
    command = sys.argv[0]

    if len(sys.argv) != 2:
        print "Usage: " + command + " path_of_PolicyKit.conf"
        return
    
    # Path of PolicyKit.conf
    file = sys.argv[1]

    # Update PolicyKit.conf
    update_polkit_conf(file)

if __name__ == "__main__":
    main()

