#!/usr/bin/env python

# Copyright (2) 2002-2008 Userful Corporation. Allrights reserved.
# http://www.userful.com

# file: umx-storage-update-hal-config.py
# Description:
#   Allow anyone to invoke methods to mount/umount/eject storage volume.

import libxml2
import sys

# List of interfaces to be allowed to anyone
send_ifs = ("org.freedesktop.Hal.Device.Volume", "org.freedesktop.Hal.Device.Volume.Crypto")
xpath_expr = '/busconfig/policy/deny'

################################################################
# Update hal.conf to allow anyone to invoke method of "send_ifs"
################################################################
def update_hal_conf(config_file):
    doc = libxml2.parseFile(config_file)
    if doc.name != config_file:
        print "doc.name failed"
        sys.exit(1)

    deny_elem = None
    # Getting every deny elements from hal.conf
    deny_elem = doc.xpathEval(xpath_expr)

    if deny_elem:
        for send_if in send_ifs:

            for elem in deny_elem:

                # Check if elem has 'action' property.
                # If then, compare the content with id
                if elem.hasProp('send_interface') and elem.prop('send_interface') == send_if:
                    elem.unlinkNode()
                else:
                    pass
        
    # Update PolicyKit.conf
    fd = open(config_file, 'w')
    doc.saveTo(fd)
    fd.close

    doc.freeDoc()
    return

def main():
    command = sys.argv[0]

    if len(sys.argv) != 2:
        print "Usage: " + command + " path_of_hal.conf"
        return
    
    # Path of PolicyKit.conf
    file = sys.argv[1]

    # Update PolicyKit.conf
    update_hal_conf(file)

if __name__ == "__main__":
    main()

