#!/bin/bash
#
#  userful-multistation-command.sh
#
##################################


############
# usage()
############
function usage()
{
	echo ""
	echo "Usage: userful multistation [OPTION]"
	echo ""
	echo -e "\tOPTIONS:"
	echo -e "\t\t-h"
	echo -e "\t\t-help\t\t- Print this help message"
	echo -e "\t\t-enable\t\t- Enable multistation"
	echo -e "\t\t-disable\t- Disable multistation (Enable singlestation)"
	echo ""
	exit 1
}

#########################
# toggleXtype()
#########################
function toggleXtype()
{
	[[ -z $1 ]] && usage

	if [[ "$1" == "-enable" ]]; then
		echo -e "\nEnable multi-station.."
		echo "XTYPE=MULTI" > /etc/sysconfig/xtype

	elif [[ "$1" == "-disable" ]]; then
		echo -e "\nEnable single-station.."
		echo "XTYPE=SINGLE" > /etc/sysconfig/xtype
	fi

	echo -e "Done !\n"
	echo -e "Changes will not take effect until after you reboot.\n"
}

#-------------------
# Start from here
#-------------------

# Import functions
source /opt/userful/bin/userful-bash-lib.sh

#
# Check if user has root access..
IsRoot

[[ -z $1 ]] && usage

case "$1" in
	-h|-help)
		usage
		;;

	-enable|-disable)
		toggleXtype $1
		;;

	*)
		echo -e "\nError: Invalid option - $1"
		usage
		;;
esac

