#!/bin/bash
#
# userful-bash-lib.sh
#
# Copyright (c) 2005-2007 Userful Corporation
#
# - Bash script common library for DM
##############################################

###################################
# IsRoot()
#   Check if user has root access..
###################################
function IsRoot()
{
    if [ ! -r /proc/kmsg ]; then
        echo ""
        echo "You must be logged in as Root to run this program."
        echo ""
        exit 1
    fi
}

#####################################################
# Check_System_Type()
#   Check system type. (32bit or 64bit system)
#
# Return value:
#   lib64 for 64bit machine or lib for 32bit machine
#####################################################
function Check_System_Type()
{
    case $(uname -m) in
        x86_64|ia64)
            echo "lib64"
            ;;
        *)
            echo "lib"
            ;;
    esac
}

#####################################################
# Check_nVidia_Driver()
#   Check if the nVidia driver and kernel module exist 
#
# Retrun Value:
#   - true for exist 
#   - false for not exist
#####################################################
function Check_nVidia_Driver()
{
    # Check machine type
    LIB=$(Check_System_Type)

    # Check nVidia kernel module and driver
	# Each distro has different way to install nvidia driver and use different files.
	# FC:yum, SUSE:Yast, Ubuntu:Restricted Devices Manager and Synaptic
    # TODO:
    #  - There might be a better way to check nvidia kernel module and drvier for every distros.
    #  - Each distro installs the nVidia kernel module and driver on different directory with dirrent name.
    #  - /lib is used for Kernel module instead of /lib64 in x86_64 SLED 10.1 system.
    #  - Need to check the path in other distributions.

    # Check nVidia Kernel Module
    #if [ -f /lib/modules/$(uname -r)/extra/nvidia/nvidia.ko -o  \
    #     -f /lib/modules/$(uname -r)/updates/nvidia.ko -o \
    #     -f /lib/modules/$(uname -r)/updates/dkms/nvidia.ko -o \
    #     -f /lib/modules/$(uname -r)/weak-updates/nvidia.ko -o \
    #     -f /lib/modules/$(uname -r)/kernel/drivers/video/nvidia/nvidia.ko -o \
    #     -f /lib/modules/$(uname -r)/kernel/drivers/video/nvidia.ko -o \
    #     -f /lib/modules/$(uname -r)/volatile/nvidia.ko -o \
    #     -f /var/lib/dkms/nvidia-current/kernel-$(uname -r)-i586/module/nvidia-current.ko.gz -o \
    #     -f /var/lib/dkms/nvidia/kernel-$(uname -r)-i686/module/nvidia.ko -o \
    #     -f /etc/modprobe.d/nvidia-kernel-nkc ]; then

    ##
    ## Check nVidia Kernel Module and nVidia X driver
    modprobe -q nvidia
    if lsmod | grep -q "^nvidia"; then

         # Check nVidia driver
         if [ -f /usr/$LIB/xorg/modules/drivers/nvidia_drv.o ] && \
            [ ! -L /usr/$LIB/xorg/modules/drivers/nvidia_drv.o ]; then
             echo "true" 
         elif [ -f /usr/$LIB/xorg/modules/drivers/nvidia_drv.so ] && \
              [ ! -L /usr/$LIB/xorg/modules/drivers/nvidia_drv.so ]; then
             echo "true" 
         elif [ -f /usr/$LIB/xorg/modules/updates/drivers/nvidia_drv.o ] && \
              [ ! -L /usr/$LIB/xorg/modules/updates/drivers/nvidia_drv.o ]; then
             echo "true" 
         elif [ -f /usr/$LIB/xorg/modules/updates/drivers/nvidia_drv.so ] && \
              [ ! -L /usr/$LIB/xorg/modules/updates/drivers/nvidia_drv.so ]; then
             echo "true" 
         elif [ -f /usr/$LIB/xorg/modules/drivers/nvidia-current/nvidia_drv.so ] && \
              [ ! -L /usr/$LIB/xorg/modules/drivers/nvidia-current/nvidia_drv.so ]; then
             echo "true" 
         elif [ -f /usr/X11R6/$LIB/modules/drivers/nvidia_drv.o ] && \
              [ ! -L /usr/X11R6/$LIB/modules/drivers/nvidia_drv.o ]; then
             echo "true" 
         elif [ -f /usr/X11R6/$LIB/modules/drivers/nvidia_drv.so ] && \
              [ ! -L /usr/X11R6/$LIB/modules/drivers/nvidia_drv.so ]; then
             echo "true" 
         elif [ -f /usr/X11R6/$LIB/modules/updates/drivers/nvidia_drv.o ] && \
              [ ! -L /usr/X11R6/$LIB/modules/updates/drivers/nvidia_drv.o ]; then
             echo "true" 
         elif [ -f /usr/X11R6/$LIB/modules/updates/drivers/nvidia_drv.so ] && \
              [ ! -L /usr/X11R6/$LIB/modules/updates/drivers/nvidia_drv.so ]; then
             echo "true" 
         else
             echo "false" 
         fi

    else
         # nVidia kernel module NOT exists. Return "false"
         echo "false"
    fi
}

################################
# showVideoCards()
################################
function showVideoCards()
{
	echo -e "\nDetected video card(s):"

	CNT=1
	while read line; do
		raw_bus_id=`echo $line | awk '{print $1}'`
		if [[ ${#raw_bus_id} -gt 7 ]]; then
			bus_id=${raw_bus_id: -7}
		else
			bus_id=$raw_bus_id
		fi

		dev_id=`echo $line | awk '{print $3}'`
		if [[ "$dev_id" == "0300:" ]]; then
			dev_id=`echo $line | awk '{print $4}'`
		fi

		dev_str=`lspci -s $bus_id`
		dev_str=${dev_str#$raw_bus_id }

		echo -e "   Card #$CNT - BUS_ID=$bus_id, DEVICE_ID=$dev_id, \"$dev_str\""

		CNT=$(( CNT + 1 ))
	done < <(lspci -n | grep "0300: ")
	echo ""
}
################################
# log()
# Required variable logfile for now
# The function will work only if invoked in the same process
################################
log() {
	local PROGRAM=$(basename ${BASH_SOURCE[1]})
	local LINENO=${BASH_LINENO[0]}
	local CALLER=${FUNCNAME[1]}
	local TS=`date +"%b %d %T"`
	#local FORMAT="%s %s:%s:%i:"$1\""\n" # TS PROGRAM:CALLER:LINENO:REST
	local FORMAT="%s [%s:%s:%i] $1\n" # TS PROGRAM:CALLER:LINENO:REST
	shift
	local VALUES=( "$@" ) 	# quote arguments
	printf "$FORMAT" "$TS" "$PROGRAM" "$CALLER" "$LINENO" "${VALUES[@]}" >>$logfile
}

################################
# version_more_then(What With)
# The function returns:
#    false if version of What is less then version of With
#    true if version of What is more or equal then version of With
################################
function version_more_then()
{
    local VER1_STR=${1/-/.} # what we comparing
    local VER2_STR=${2/-/.} # we compare with
    local VER1=(${VER1_STR//./ })
    local VER2=(${VER2_STR//./ })
    local SIZE1=${#VER1[@]}
    local SIZE2=${#VER2[@]}
    if [ "$SIZE1" -lt "$SIZE2" ]; then
	SIZE=$SIZE1
    else
	SIZE=$SIZE2
    fi
    for (( I=0; I<=SIZE-1; I++ )) 
    do
	if [ "${VER1[I]}" -lt "${VER2[I]}" ]; then #lt
	    echo false
	    return 0
	fi
    done
    echo true
    return 0
}

################################
# This function should be used to output 
# messages durring bootup and shutdown of the system.
# The function will work only if invoked in the same process
################################
function init_message() 
{
	local MESSAGE=$1
	INIT_VERSION=`init --version 2> /dev/null | grep upstart | sed -s 's/[^(]*(upstart \([^)]*\))/\1/g'`
    if [ -n "$INIT_VERSION" ]; then
		Res=$(version_more_then "$INIT_VERSION" "0.3.10-2")	
    else
		Res=true # we have not upstart based init 
    fi
    if [ true == "$Res" ]; then
		echo -e "$MESSAGE"
	fi
}
