#!/usr/bin/env python

""" Read /etc/userful/umx-distro.conf, then create /tmp/distro.conf

This program reads a config file containing distro specific configuration, then
create a new config file that bash scripts can source during UMx startup.

Called From: dm-initialize.sh
Calling:

Parameters: osname, osver

Copyright (c) 2002-2009 Userful Corporation. All right reserved.

Change Log:

"""

import sys, getopt, os, pwd, time
import ConfigParser

## Config files
CONFIG_FILE = "/etc/userful/umx-distro.conf"
TMP_CONFIG_FILE = "/tmp/distro.conf"

def usage():
    print '''
<Usage>: umx-distro-config.py <options>
             -h, --help: This messae.
             -v, --verbose: Verbose Mode
             --osname: OS name
             --osver: OS ver'''

def create_os_specific_config(os_name, os_ver, verbose):
    '''Get OS specific configuration from /et/userful/umx-distro.conf,
    then create a new config file (/tmp/distro.conf) that can be sourced in the shell scripts.
    '''

    ##
    ## Get distro specific cofiguration from CONFIG_FILE
    ##  - Case sensitive
    config_file = ConfigParser.ConfigParser()
    config_file.optionxform = str

    try:
        config_file.read(CONFIG_FILE)
    except:
        print "Invalid config file, %s" % CONFIG_FILE
        sys.exit()

    if verbose:
        print "Parse %s" % CONFIG_FILE

    # Make section string using os_name and os_ver
    section_str = "%s %s" % (os_name, os_ver)
    if verbose:
        print "Section: %s" % section_str

    # Check if "section_str" is exist.
    if not config_file.has_section(section_str):
        print "Section \"%s\" is not exist." % section_str
        sys.exit()

    section_items = config_file.items(section_str)

    ## Create TMP_CONFIG_FILE
    try:
        f = open(TMP_CONFIG_FILE, "w")
    except:
        print "Can't create %s" % TMP_CONFIG_FILE
        sys.exit()

    for option, value in section_items:

        if verbose:
            print "%s=\"%s\"" % (option,value)
        f.write("%s=\"%s\"\n" % (option,value))

    f.close()


def main():
    "Main function"

    # Parse arguments
    try:
        opts, args = getopt.getopt(sys.argv[1:], "hv", ["help", "verbose", "osname=", "osver="])
    except getopt.GetoptError, err:
        print str(err)
        usage()
        sys.exit(2)

    verbose = False
    os_name = None
    os_ver = None
    for o, a in opts:

        if o in ("-h", "--help"):
            usage()
            sys.exit()

        elif o in ("-v", "--verbose"):
            verbose = True

        elif o == "--osname":
            os_name = a.lower()

        elif o == "--osver":
            os_ver = a.lower()

    if not os_name or not os_ver:
        # os_name, os_ver are mandatory arguments.
        # TODO:
        #  - Need to upgrade to find the osname and osversion
        #    when it doesn't receive them.
        usage()
        sys.exit(2)

    if verbose:
        print "OSNAME=%s, OSVER=%s" % (os_name, os_ver)

    create_os_specific_config(os_name, os_ver, verbose)

if __name__ == "__main__":
    main()
