#!/bin/bash
#
#   multistation-devices-session-startup.sh
#
# AUTHOR
#   Jason Kim <jason@userful.com>
#
# DESCRIPTION
#   - This is run as normal login user, not root.
# 	- update GConf keys
# 	- call device specific script (audio and storage)
#
#
# Copyright (c) 2002-2007 by Userful Corporation
#
# Called from: default.session. (When gnome session starts)
# 			   - /usr/share/gnome/ for FC 
# 			   - /opt/gnome/share/gnome/ for SuSE
#            : /etc/xdg/autostart/umx-session-init.desktop
#
# Call: multistation-audio-session-startup.sh, multistation-storage-session-startup.sh

logfile="/var/log/userful-start.log"
function bin() {
    echo $(cd `dirname $0` && pwd)	
}
source "$(bin)/gconf.sh"

# Do not show mounted volume on the desktop (gnome)
#$(save "normal" "/apps/nautilus/desktop/volumes_visible" "bool" "false")

# Show computer icon
$(save "normal" "/apps/nautilus/desktop/computer_icon_visible" "bool" "true")

## Disable Auto-Mount/Browse
# Don't open File Browser on other station
$(save "normal" "/apps/nautilus/preferences/media_automount" "bool" "false")
$(save "normal" "/apps/nautilus/preferences/media_automount_open" "bool" "false")

# Disable auto browse
$(save "normal" "/desktop/gnome/volume_manager/autobrowse" "bool" "false")

# Disable automount drives
$(save "normal" "/desktop/gnome/volume_manager/automount_drives" "bool" "false")

# Disable automount media
$(save "normal" "/desktop/gnome/volume_manager/automount_media" "bool" "false")

# Disable autoplay cda
#$(save "normal" "/desktop/gnome/volume_manager/autoplay_cda" "bool" "false")

# Disable autoplay cdr
#$(save "normal" "/desktop/gnome/volume_manager/autoplay_cdr" "bool" "false")

# Disable autoplay dvd
#$(save "normal" "/desktop/gnome/volume_manager/autoplay_dvd" "bool" "false")

# Disable autoplay vcd
#$(save "normal" "/desktop/gnome/volume_manager/autoplay_vcd" "bool" "false")

# set GConf key for gnome-cd
GCONF_VALUE=`gconftool-2 -g /apps/gnome-cd/device 2> /dev/null`
if [ -n "$GCONF_VALUE" ]; then
	search_station_string="Srn$DISPLAY"
	assigned_CD_drive=`grep CDROM /etc/multiuserdevices | grep $search_station_string  | awk '{print $2}'`
	if [ "$assigned_CD_drive" != "" ]; then
		$(save "normal" "/apps/gnome-cd/device" "string" "$assigned_CD_drive")
	fi
fi

# Disable ESD
$(save "normal" "/desktop/gnome/sound/enable_esd" "bool" "false")

# Disable event sound 
$(save "normal" "/desktop/gnome/sound/event_sounds" "bool" "false")

##
## Disable System suspend and hibernate
$(save "normal" "/apps/gnome-power-manager/can_hibernate" "bool" "false")
$(save "normal" "/apps/gnome-power-manager/can_suspend" "bool" "false")

# Ubuntu 9.04
$(save "normal" "/apps/gnome-power-manager/general/can_hibernate" "bool" "false")
$(save "normal" "/apps/gnome-power-manager/general/can_suspend" "bool" "false")

## Disable Swith User
$(save "normal" "/apps/gnome-screensaver/user_switch_enabled" "bool" "false")
$(save "normal" "/apps/fast-user-switch-applet/show_guest_login" "bool" "false")
$(save "normal" "/apps/fast-user-switch-applet/show_active_users_only" "bool" "true")

if [ -x /opt/userful/bin/multistation-audio-session-startup.sh ]; then
	/opt/userful/bin/multistation-audio-session-startup.sh
fi

if [ -x /opt/userful/bin/multistation-storage-session-startup.sh ]; then
	/opt/userful/bin/multistation-storage-session-startup.sh
fi

