#!/bin/bash

#****** /bin/oss_session_init.sh
# NAME
# 	oss_session_init.sh
#
# AUTHOR
# 	Rocky
#
# Maintainer
# 	Jason Kim <jason@userful.com>
#
# DESCRIPTION
#  - aoss should be installed. Normally it is a part of alsa-oss package.
#  - Set $HOME/.asoundrc file to map /dev/dsp0 to a specific ALSA sound device;
#
# Called From: multistation-audio-session-startup.sh
#
# In SLED10, volume control has some problems with multiple audio devices.
# We probably need a GUI program to control the volume. It just can use amixer command
# with "-D default" option.  The default device is set with correct device here.
#

logfile="/var/log/userful-start.log"
ProgramName=`basename $0`

echo "`date +"%b %d %T"` $ProgramName: No Pulseaudio. Set .asoundrc with alsa device." >> $logfile

# TODO: 
#    Need to add softvol for software mixing.
ALSA_CARD=$1
echo '
pcm.!default {
	type hw
	card '$ALSA_CARD'
}

ctl.!default {
	type hw
	card '$ALSA_CARD'
}

pcm.dsp0 {
    type plug
    slave.pcm "hw:'$ALSA_CARD',0"
}'  > ~/.asoundrc

