#!/bin/bash

#
# Copyright (c) 2004-2006 by Userful Corporation
#
# Name: multistation-audio-update-ownership.sh
# Author: Jason Kim <jason@userful.com>
# Description:
#
# Called from: multistation-devices-update-ownership.sh
#
# Available environment variables:
# $1: PAM_TTY
# $2: PAM_FUNCTION
# $3: PAM_USER
###################################################################################
logfile="/var/log/userful-start.log"
ProgramName=`basename $0`

SCREEN_NUM=$1
SCREEN_NUM=${SCREEN_NUM##*:}
SCREEN_NUM=${SCREEN_NUM/.*}
ACTION=$2
CURRENT_USER=$3

#
# change the onwership of audio devices
#
update_audio_ownership()
# $1: user name
# $2: ALSA device number (optional)
{
	chmod 600 /dev/dsp*
	chmod 600 /dev/audio*
	chmod 600 /dev/mixer*
	chmod 600 /dev/snd/*

	if [ -z "$2" ]; then
		chown $1 /dev/dsp 2> /dev/null
		chmod 600 /dev/dsp 2> /dev/null

		chown $1 /dev/audio 2> /dev/null
		chmod 600 /dev/audio 2> /dev/null

		chown $1 /dev/mixer 2> /dev/null
		chmod 600 /dev/mixer 2> /dev/null

	else
		chown $1 /dev/dsp$2 2> /dev/null
		chmod 600 /dev/dsp$2 2> /dev/null

		chown $1 /dev/audio$2 2> /dev/null
		chmod 600 /dev/audio$2 2> /dev/null

		chown $1 /dev/mixer$2 2> /dev/null
		chmod 600 /dev/mixer$2 2> /dev/null

		chown $1 /dev/snd/controlC$2 2> /dev/null
		chmod 600 /dev/snd/controlC$2 2> /dev/null

		chown $1 /dev/snd/pcmC$2* 2> /dev/null
		chmod 600 /dev/snd/pcmC$2* 2> /dev/null
	fi
}

STATION_STR="Srn:$SCREEN_NUM.0"
ALSA_DEV_NAME=`grep $STATION_STR /etc/usbaudio | awk '{print $2}'`

if [ "$ALSA_DEV_NAME" == "" ]; then

	if [ "$ACTION" == "OPEN_SESSION" ]; then
		echo "`date +"%b %d %T"` $ProgramName:(Login) No audio device available for DISPLAY=:$SCREEN_NUM" >> $logfile
	fi

else

	ALSA_DEV_NUM=`echo $ALSA_DEV_NAME | sed 's/^...//g'`

	if [ "$ACTION" == "OPEN_SESSION" -a "x$ALSA_DEV_NUM" != "x" ]; then
		echo "`date +"%b %d %T"` $ProgramName:(Login) Assign alsa $ALSA_DEV_NAME to $CURRENT_USER, DISPLAY=:$SCREEN_NUM" >> $logfile
        # update the permission of /dev/shm directory. DST5 has wrong value for it.
        chmod 1777 /dev/shm

		if [ $ALSA_DEV_NUM -eq 0 ]; then
			update_audio_ownership $CURRENT_USER 
		fi
		update_audio_ownership $CURRENT_USER $ALSA_DEV_NUM

        #Update the permission of timer and seq
        chmod 666 /dev/snd/seq /dev/snd/timer 2> /dev/null

	elif [ "$ACTION" = "CLOSE_SESSION" -a "x$ALSA_DEV_NUM" != "x" ]; then

		if [ $ALSA_DEV_NUM -eq 0 ]; then
			update_audio_ownership root 
		fi
		update_audio_ownership root $ALSA_DEV_NUM
    	pkill -U $CURRENT_USER esd 2> /dev/null
    	pkill -U $CURRENT_USER pulseaudio 2> /dev/null
	fi
fi
