#!/bin/bash

#****** /bin/audio_apps_init.sh
# NAME
# 	audio_apps_init.sh
#
# AUTHOR
# 	Rocky
#
# DESCRIPTION
# 	Content include:
# 	1) Xmms: Inital shell script for Xmms application when session log in or hot plug USB audio device.
# 	Modify $HOME/.xmms/config to use esd for Gnome, artsd for KDE;
# 	2) Mplayer: change ao to esd/arts, vo to x11 (Xshm);
# 	3) Xine: Modify to use xshm video driver instead of default
# 	Usage: audio_apps_init.sh $window_manager
#
# TODO: May need to do something for DiscoverStation
# 		This is not called at all for now.

logfile="/var/log/userful-multiuser-device.log"

window_manager="$1"

if [ "$window_manager" = "\"gnome-session\"" ]; then
	
	#Init Xmms for Gnome
	if [ ! -f ~/.xmms/config ]; then

		mkdir -p ~/.xmms
		echo -e "[xmms]\noutput_plugin=/usr/lib/xmms/Output/libesdout.so\n" >> ~/.xmms/config

	else
		perl -pi -e "s/output_plugin=(.+?)\n/output_plugin=\/usr\/lib\/xmms\/Output\/libesdout.so\n/" ~/.xmms/config
	fi

	#Init Mplayer for Gnome
	x_pixels=`xdpyinfo | grep dimensions | sed 's/x/ /g' | awk '{ print $2 }'`
	case $x_pixels in
		*[!0-9]*|"")
			echo "{EE} Not a valid resolution number for X to initialize Mplayer" >> $logfile
			x_pixels=640 ;;
		*)
			: ;;
	esac
			
	y_pixels=`xdpyinfo | grep dimensions | sed 's/x/ /g' | awk '{ print $3 }'`
	case $y_pixels in
		*[!0-9]*|"")
			echo "{EE} Not a valid resolution number for Y to initialize Mplayer" >> $logfile
			y_pixels=480 ;;
		*)
			: ;;
	esac

	main_pos_x=`expr $x_pixels / 2`
	main_pos_y=`expr $y_pixels / 2 - 200`
	video_pos_y=`expr $main_pos_y + 200`

	assigned_cd_drive=`grep CDROM /etc/multiuserdevices | grep Srn$DISPLAY | awk '{print $2}'`

	if [ ! -f ~/.mplayer/config ]; then

		mkdir -p ~/.mplayer
		echo -e "ao=esd\nvo=x11" >>~/.mplayer/config
		echo -e "gui_main_pos_x=$main_pos_x\ngui_main_pos_y=$main_pos_y\ngui_video_out_pos_x=$main_pos_x\ngui_video_out_pos_y=$video_pos_y" >> \
			~/.mplayer/gui.conf

		if [ "$assigned_cd_drive" != "" ]; then
			echo -e "dvd_device=$assigned_cd_drive\ncdrom_device=$assigned_cd_drive" >> ~/.mplayer/gui.conf
		fi

	else

		perl -pi -e "s/ao=(.+?)\n/ao=esd\n/;s/vo=(.+?)\n/vo=x11\n/" ~/.mplayer/config
		perl -pi -e "s/gui_main_pos_x=(.+?)\n/gui_main_pos_x=$main_pos_x\n/;s/gui_main_pos_y=(.+?)\n/gui_main_pos_y=$main_pos_y\n/;s/gui_video_out_pos_x=(.+?)\n/gui_video_out_pos_x=$main_pos_x\n/;s/gui_video_out_pos_y=(.+?)\n/gui_video_out_pos_y=$video_pos_y\n/" ~/.mplayer/gui.conf 

		if [ "$assigned_cd_drive" != "" ]; then
			perl -pi -e "s|dvd_device =(.+?)\n|dvd_device=$assigned_cd_drive\n|; s|cdrom_device =(.+?)\n|cdrom_device=$assigned_cd_drive\n|" ~/.mplayer/gui.conf
		fi
	fi

elif [ "$window_manager" = "\"startkde\"" ]; then

	#Init Xmms for KDE
	if [ ! -f ~/.xmms/config ]; then

		mkdir -p ~/.xmms
		echo -e "[xmms]\noutput_plugin=/usr/lib/xmms/Output/libarts.so\n" >> ~/.xmms/config

	else

		perl -pi -e "s/output_plugin=(.+?)\n/output_plugin=\/usr\/lib\/xmms\/Output\/libarts.so\n/" ~/.xmms/config

	fi

	#Init Mplayer for KDE
	if [ ! -f ~/.mplayer/config ]; then

		mkdir -p ~/.mplayer
		echo -e "ao=arts\nvo=x11" >>~/.mplayer/config

	else

		perl -pi -e "s/ao =(.+?)\n/ao=arts\n/;s/vo=(.+?)\n/vo=x11\n/" /.mplayer/config

	fi

fi
