/*
 * Created on 23-nov-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.song.models;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class SongTrack implements Serializable{
    public static final int MAX_OFFSET = 24;
    public static final int MIN_OFFSET = -24;
    
	private int number;
    private SongChannel channel;
    private String name;
    private List measures;
    private List strings;
    private RGBColor color;    
    private int offset;
    private Lyric lyrics;
    
    public SongTrack(int number,String name,SongChannel channel,List measures,List strings,int offset,RGBColor color,Lyric lyrics) {
        this.number = number;
    	this.name = name;
    	this.channel = channel;    	
        this.measures = measures;
        this.strings = strings;
        this.color = color;
        this.offset = offset;
        this.lyrics = lyrics;
    }

    public SongTrack(int number,String name,SongChannel channel,List measures,List strings,int offset,RGBColor color) {
    	this(number, name, channel, measures, strings, offset, color,new Lyric());
    }
    
    public int getNumber() {
		return number;
	}

	public void setNumber(int number) {
		this.number = number;
	}

	public List getMeasures() {
        return measures;
    }
    public void setMeasures(List measures) {
        this.measures = measures;
    }    
    public SongChannel getChannel() {
        return channel;
    }
    public void setChannel(SongChannel channel) {
        this.channel = channel;
    }
    
    public List getStrings() {
        return strings;
    }
    
    public void setStrings(List strings) {
        this.strings = strings;
    }
    
    
    public RGBColor getColor() {
		return color;
	}

	public void setColor(RGBColor color) {
		this.color = color;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public int getOffset() {
		return offset;
	}

	public void setOffset(int offset) {
		this.offset = offset;
	}

	
	
	public Lyric getLyrics() {
		return lyrics;
	}


	public void setLyrics(Lyric lyrics) {
		this.lyrics = lyrics;
	}

    
    public InstrumentString getString(int number){
    	return (InstrumentString)this.strings.get(number - 1);
    }
    
	public int stringCount(){
		return this.strings.size();
	}
    
	public boolean isPercussionTrack(){
        return (getChannel().isPercusionChannel());
    }

    public void makeEqual(SongTrack track,List measureHeaders){
    	track = (SongTrack)track.clone(measureHeaders);
        this.number = track.getNumber();
    	this.name = track.getName();
    	this.channel = track.getChannel();
        this.measures = track.getMeasures();
        this.strings = track.getStrings();
        this.color = track.getColor();
    }
    
    public Object clone(List measureHeaders){
        List measures = new ArrayList();
        for (int mIdx = 0; mIdx < getMeasures().size(); mIdx++) {
            Measure measure = (Measure)getMeasures().get(mIdx);

            TimeSignature timeSignature = (TimeSignature) measure.getTimeSignature().clone();
            Tempo tempo = (Tempo)measure.getTempo().clone();
            
            List notes = new ArrayList();
            for (int nIdx = 0; nIdx < measure.getNotes().size(); nIdx++) {
                Note note = (Note) measure.getNotes().get(nIdx);
                notes.add((Note) note.clone());
            }
            List silences = new ArrayList();
            for (int sIdx = 0; sIdx < measure.getSilences().size(); sIdx++) {
                Silence silence = (Silence) measure.getSilences().get(sIdx);
                silences.add((Silence) silence.clone());
            }

            measures.add(new Measure((MeasureHeader)measureHeaders.get(mIdx), 
            			  			 notes, 
            			  			 silences, 
            			  			 measure.getClef(),
            			  			 measure.getKeySignature()));

        }

        List strings = new ArrayList();
        for (int sIdx = 0; sIdx < getStrings().size(); sIdx++) {
            InstrumentString string = (InstrumentString) getStrings().get(sIdx);
            strings.add((InstrumentString) string.clone());
        }

        int number = getNumber();
        String name = getName();
        SongChannel channel = (SongChannel)getChannel().clone();
        RGBColor color = (RGBColor)getColor().clone();
        int offset = getOffset();
        
        return new SongTrack(number,name,channel, measures, strings,offset,color);
    }
    
}
