/*
 * Created on 13-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.player.base;

import java.util.List;

//import javax.sound.midi.InvalidMidiDataException;

import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.MeasureHeader;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.SongChannel;
import org.herac.tuxguitar.song.models.SongTrack;
import org.herac.tuxguitar.song.models.Tupleto;
import org.herac.tuxguitar.song.models.VelocityValues;
import org.herac.tuxguitar.song.models.effects.BendEffect;
import org.herac.tuxguitar.song.models.effects.TremoloBarEffect;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class MidiSequenceParser {	    
    
    private static final int DEFAULT_METRONOME_KEY = 37;
    
    private static final int DEFAULT_DEAD_NOTE_DURATION = 50;
    
    private static final int DEFAULT_BEND = 64;
    
    private static final float DEFAULT_BEND_SEMI_TONE = 5.5f;
    	
	/**
	 * flag para agregar los controles por defecto, 
	 * no se recomienda usar este flag si el reproductor asigna estos controles en tiempo real. 
	 */
	public static final int ADD_DEFAULT_CONTROLS = 0x01;
	/**
	 * flag para agregar los valores del mixer (volumen, balance, instrumento), 
	 * no se recomienda usar este flag si el reproductor asigna estos valores en tiempo real. 
	 */	
	public static final int ADD_MIXER_MESSAGES = 0x02;
	/**
	 * flag para agregar la pista del metronomo, 
	 * en casos como la exportacion de midi, este flag no sera necesario  
	 */		
	public static final int ADD_METRONOME = 0x04;
	/**
	 * tuxguitar usa estos mensajes para controlar las repeticiones visualmente 
	 * en casos como la exportacion de midi, este flag no sera necesario  
	 */	
	public static final int ADD_TICK_MOVE_MESSAGES = 0x08;
	/**
	 * tuxguitar usa como primer tick el valor de la constante Duration.QUARTER_TIME
	 * asignando este flag, es posible crear el primer tick en cero.
	 */
	public static final int ADD_FIRST_TICK_MOVE = 0x10;
	
	

	public static final int DEFAULT_PLAY_FLAGS = (ADD_METRONOME | ADD_TICK_MOVE_MESSAGES);

	public static final int DEFAULT_EXPORT_FLAGS = (ADD_FIRST_TICK_MOVE | ADD_DEFAULT_CONTROLS | ADD_MIXER_MESSAGES);
		
    /**
     * Song Manager
     */
    private SongManager manager;
    /**
     * flags
     */    
    private int flags;
    /**
     * Index of info track 
     */
    private int infoTrack;
    /**
     * Index of metronome track 
     */    
    private int metronomeTrack;
    
    private int fisrtTickMove;
    
    public MidiSequenceParser(SongManager manager,int flags) {
        this.manager = manager;
        this.flags = flags;        
        this.fisrtTickMove = (int)(((flags & ADD_FIRST_TICK_MOVE) != 0)?(-Duration.QUARTER_TIME):0);        
    }

    /**
     * Crea la cancion
     */        
    public void parse(MidiSequence sequence) {
    	this.infoTrack = sequence.getInfoTrack();
    	this.metronomeTrack = sequence.getMetronomeTrack();
        addDefaultMessages(sequence);        
        for (int i = 0; i < this.manager.getSong().getTracks().size(); i++) {
        	SongTrack songTrack = (SongTrack) this.manager.getSong().getTracks().get(i);
            createTrack(sequence,songTrack);
        }                                
    }
  
    private int infoIndex(){
    	return this.infoTrack;
    }

    private int metronomeIndex(){
    	return this.metronomeTrack;
    }
      
    private long getTick(long tick){
    	return (tick + this.fisrtTickMove);    
    }    
    
    /**
     * Crea las pistas de la cancion
     */        
    private void createTrack(MidiSequence sequence,SongTrack songTrack) {
    	addBend(sequence,songTrack.getNumber(),Duration.QUARTER_TIME,DEFAULT_BEND,songTrack.getChannel().getChannel());               
    	addMixerValues(sequence,songTrack.getNumber(),songTrack.getChannel());

        //------controlo las repeticiones-------
        boolean repeatOpen = true;
        long repeatStart = 1000;
        long repeatEnd = 0;
        long startMove = 0;                        
        int repeatStartIndex = 0;
        int repeatNumber = 0;
        //--------------------------------------
            
        Measure prevMeasure = null;
        for (int measureIdx = 0; measureIdx < songTrack.getMeasures().size(); measureIdx++) {
        	Measure measure = (Measure) songTrack.getMeasures().get(measureIdx);
                                  
            if(songTrack.getNumber() == 1){                    
            	addTimeSignature(sequence,measure, prevMeasure,startMove);
                addTempo(sequence,measure, prevMeasure,startMove);
                addStartMoveMetaMessage(sequence,measure.getStart(),startMove);
                addMetronome(sequence,measure.getHeader(),startMove);                    
            }
                
            //agrego las notas
            makeNotes(sequence,songTrack.getNumber(), songTrack, measure, measureIdx, startMove);

            //guardo el indice de el compas donde empieza una repeticion
            if (measure.isRepeatStart()) {
            	repeatStartIndex = measureIdx;
                repeatStart = measure.getStart();
                repeatOpen = true;
            }

            //si hay una repeticion la hago
            if (repeatOpen && measure.getNumberOfRepetitions() > 0) {
            	if (repeatNumber < measure.getNumberOfRepetitions()) {
            		repeatEnd = measure.getStart() + measure.getLength();
                    startMove += repeatEnd - repeatStart;
                    measureIdx = repeatStartIndex - 1;
                    repeatNumber++;                       
                } else {
                	repeatStart = 0;
                    repeatNumber = 0;
                    repeatEnd = 0;
                    repeatOpen = false;
                }
            }
            prevMeasure = measure;
        }
    }

    /**
     * Crea las notas del compas
     */    
    private void makeNotes(MidiSequence sequence,int track, SongTrack songTrack, Measure measure, int measureIdx, long startMove) {        
        for (int noteIdx = 0; noteIdx < measure.getNotes().size(); noteIdx++) {
            Note note = (Note) measure.getNotes().get(noteIdx);
            if (!note.isTiedNote()) {
                int key = songTrack.getOffset() + note.getValue() + ((InstrumentString)songTrack.getStrings().get(note.getString() - 1)).getValue();
                                
                NoteData data = checkTripletFeel(measure,note,noteIdx);
                long start = data.start + startMove;
                long duration = getRealNoteDuration(note,data.duration, songTrack.getMeasures(), measureIdx, noteIdx);
                int velocity = getRealVelocity(note, songTrack, measureIdx, noteIdx);
                int channel = songTrack.getChannel().getChannel();
                int effectChannel = songTrack.getChannel().getEffectChannel();

                boolean percussionTrack = songTrack.isPercussionTrack();
                //---Fade In---
                if(note.getEffect().isFadeIn()){
                	channel = effectChannel;
                	makeFadeIn(sequence,track, start, duration, songTrack.getChannel().getVolume(), channel);
                }
                //---Grace---
                if(note.getEffect().isGrace() && effectChannel >= 0 && !percussionTrack ){
                	channel = effectChannel;
                	int graceKey = songTrack.getOffset() + note.getEffect().getGrace().getFret() + ((InstrumentString)songTrack.getStrings().get(note.getString() - 1)).getValue();
                	int graceLength = note.getEffect().getGrace().getDurationTime();
                	
                	int graceDuration = ((note.getEffect().getGrace().isDead())?DEFAULT_DEAD_NOTE_DURATION:graceLength);
                	int graceVelocity = note.getEffect().getGrace().getDynamic();
                	
                	if(note.getEffect().getGrace().isOnBeat() || (start - graceLength) < Duration.QUARTER_TIME){
                		start += graceLength;
                		duration -= graceLength;
                	}
                	makeNote(sequence,track, graceKey,start - graceLength,graceDuration,graceVelocity,channel);
                	
                }
                //---Trill---
                if(note.getEffect().isTrill() && effectChannel >= 0 && !percussionTrack ){
                	int trillKey = songTrack.getOffset() + note.getEffect().getTrill().getFret() + ((InstrumentString)songTrack.getStrings().get(note.getString() - 1)).getValue();
                	long trillLength = note.getEffect().getTrill().getDuration().getTime();                	
                	
                	boolean realKey = true;
                	long tick = start;
                	while(true){
                		if(tick + 10 >= (start + duration)){
                			break ;
                		}else if( (tick + trillLength) >= (start + duration)){
                			trillLength = (((start + duration) - tick) - 1);
                		}                		
                		makeNote(sequence,track,((realKey)?key:trillKey),tick,trillLength,velocity,channel);
                		realKey = (!realKey);
                		tick += trillLength;
                	}
                	continue;                	
                }      
                //---Tremolo Picking---
                if(note.getEffect().isTremoloPicking() && effectChannel >= 0){
                	long tpLength = note.getEffect().getTremoloPicking().getDuration().getTime();                	
                	long tick = start;
                	while(true){
                		if(tick + 10 >= (start + duration)){
                			break ;
                		}else if( (tick + tpLength) >= (start + duration)){
                			tpLength = (((start + duration) - tick) - 1);
                		}                		
                		makeNote(sequence,track,key,tick,tpLength,velocity,channel);
                		tick += tpLength;
                	}
                	continue;                	
                } 
                
                //---Bend---	                    
                if(note.getEffect().isBend() && effectChannel >= 0 && !percussionTrack ){
                	channel = effectChannel;
                	makeBend(sequence,track,start,duration,note.getEffect().getBend(),channel);
                }
                //---TremoloBar---	                    
                else if(note.getEffect().isTremoloBar() && effectChannel >= 0 && !percussionTrack ){
                	channel = effectChannel;
                	makeTremoloBar(sequence,track,start,duration,note.getEffect().getTremoloBar(),channel);
                }                
                //---Slide---                    
                else if(note.getEffect().isSlide() && effectChannel >= 0 && !percussionTrack){       
                	channel = effectChannel;
                    Note nextNote = getNextNote(note,songTrack.getMeasures(),measureIdx,noteIdx);
                    makeSlide(sequence,track,note,nextNote,startMove,channel);
                }
                //---Vibrato---                        
                else if(note.getEffect().isVibrato() && effectChannel >= 0 && !percussionTrack){
                	channel = effectChannel;
                	makeVibrato(sequence,track,start,duration,channel);
                }    
                //---Harmonic---
                if(note.getEffect().isHarmonic()){
                	//Artificial
                    if(note.getEffect().getHarmonic().isArtificial() && !percussionTrack){
                    	key = Math.min(124, (key + note.getEffect().getHarmonic().getData() ) );                	
                    }          
                	//Tapped
                    else if(note.getEffect().getHarmonic().isTapped() && !percussionTrack){
                    	key = Math.min(124, (key + 12 + note.getEffect().getHarmonic().getData() ) );                	
                    }                         
                	//Pinch
                    else if(note.getEffect().getHarmonic().isPinch() && !percussionTrack){
                    	key = Math.min(124,key + 7);                	
                    }                     	
                	//Semi
                    else if(note.getEffect().getHarmonic().isSemi() && !percussionTrack){
                    	velocity = Math.max(VelocityValues.MIN_VELOCITY,velocity - (VelocityValues.VELOCITY_INCREMENT * 2));
                    	makeNote(sequence,track, key + 12, start, duration,velocity,channel);                	
                    }                       
                }
            	
                //---Normal Note---
                makeNote(sequence,track, key, start, duration, velocity,channel);
            }
        }

    }

    /**
     * Crea una nota en la posicion start
     */
    private void makeNote(MidiSequence sequence,int track, int key, long start, long duration, int velocity, int channel) {
    	sequence.addNoteOn(getTick(start),track,channel,key,velocity);
    	sequence.addNoteOff(getTick(start + duration),track,channel,key,velocity);
    }
    
    public void addMixerValues(MidiSequence sequence,int track,SongChannel channel) {    	    	
    	if( (flags & ADD_MIXER_MESSAGES) != 0){    	
    		addMixerValues(sequence, track, channel.getChannel(), channel.getInstrument(), channel.getVolume(), channel.getBalance());
    		if(channel.getChannel() != channel.getEffectChannel()){        	
    			addMixerValues(sequence, track, channel.getEffectChannel(), channel.getInstrument(), channel.getVolume(), channel.getBalance());     		        		
    		}
    	}
    }
    
    public void addMixerValues(MidiSequence sequence,int track,int channel,int program,int volume,int balance) {    	    	    	
    	sequence.addProgramChange(getTick(Duration.QUARTER_TIME),track,channel,program);
    	sequence.addControlChange(getTick(Duration.QUARTER_TIME),track,channel,MidiControllers.VOLUME, volume);
    	sequence.addControlChange(getTick(Duration.QUARTER_TIME),track,channel,MidiControllers.BALANCE, balance);
    }    
    
    /**
     * Crea el instrumento para la pista
     *//*
    private void makeInstrument(MidiSequence sequence,int track, int channel, int instrument) {
    	sequence.addProgramChange(getTick(Duration.QUARTER_TIME), track, channel, instrument);
    }*/

    /**
     * Agrega un Time Signature si es distinto al anterior
     */
    private void addTimeSignature(MidiSequence sequence,Measure currMeasure, Measure prevMeasure,long startMove)/* throws InvalidMidiDataException */{
        boolean addTimeSignature = false;
        if (prevMeasure == null) {
            addTimeSignature = true;
        } else {
            int currNumerator = currMeasure.getTimeSignature().getNumerator();
            int currValue = currMeasure.getTimeSignature().getDenominator().getValue();
            int prevNumerator = prevMeasure.getTimeSignature().getNumerator();
            int prevValue = prevMeasure.getTimeSignature().getDenominator().getValue();
            if (currNumerator != prevNumerator || currValue != prevValue) {
                addTimeSignature = true;
            }
        }
        if (addTimeSignature) {            
        	sequence.addTimeSignature(getTick(currMeasure.getStart() + startMove), infoIndex(), currMeasure.getTimeSignature());
        }
    }

    /**
     * Agrega un Tempo si es distinto al anterior
     */
    private void addTempo(MidiSequence sequence,Measure currMeasure, Measure prevMeasure,long startMove)/* throws InvalidMidiDataException*/ {
        boolean addTempo = false;
        if (prevMeasure == null) {
            addTempo = true;
        } else {
            if (currMeasure.getTempo().getInUSQ() != prevMeasure.getTempo().getInUSQ()) {
                addTempo = true;
            }
        }
        if (addTempo) {            
        	sequence.addTempoInUSQ(getTick(currMeasure.getStart() + startMove), infoIndex(), (int)currMeasure.getTempo().getInUSQ());
        }
    }

    /**
     * Retorna la Duracion real de una nota, verificando si tiene otras ligadas
     */
    private long getRealNoteDuration(Note note,long duration, List measures, int measureIndex, int noteIndex) {
    	if(note.getEffect().isDeadNote()){
    		return DEFAULT_DEAD_NOTE_DURATION;
    	}
        noteIndex++;
        for (int mIdx = measureIndex; mIdx < measures.size(); mIdx++) {
            Measure measure = (Measure) measures.get(mIdx);
            for (int nIdx = noteIndex; nIdx < measure.getNotes().size(); nIdx++) {
                Note nextNote = (Note) measure.getNotes().get(nIdx);
                if (!nextNote.equals(note)) {
                    if (nextNote.getString() == note.getString()) {
                        if (nextNote.isTiedNote()) {
                            duration += nextNote.getDuration().getTime();
                        } else {        
                            return applyDurationEffects(note,duration);
                        }
                    }
                }
            }
            noteIndex = 0;
        }
                
        return applyDurationEffects(note,duration);
    }
    
    private long applyDurationEffects(Note note,long duration){
    	//palm mute
    	if(note.getEffect().isPalmMute()){
    		duration = (long)((float)duration * 75.00 / 100.00);
    	}
    	//staccato    	
    	else if(note.getEffect().isStaccato()){
    		duration = (long)((float)duration * 50.00 / 100.00);
    	}        	
    	
    	return duration;
    }
    
    private int getRealVelocity(Note note, SongTrack songTrack, int measureIndex, int noteIndex){
    	int velocity = note.getVelocity();

    	//Check for Hammer effect
        if(!songTrack.isPercussionTrack()){
            Note prevNote = getPrevNote(note,songTrack.getMeasures(),measureIndex,noteIndex);
            if(prevNote != null && prevNote.getEffect().isHammer()){
            	velocity = Math.max(VelocityValues.MIN_VELOCITY,(velocity - 25));
            }
        }
        
        //Check for GhostNote effect
        if(note.getEffect().isGhostNote()){
        	velocity = Math.max(VelocityValues.MIN_VELOCITY,(velocity - VelocityValues.VELOCITY_INCREMENT));
        }else if(note.getEffect().isAccentuatedNote()){
        	velocity = Math.max(VelocityValues.MIN_VELOCITY,(velocity + VelocityValues.VELOCITY_INCREMENT));
        }else if(note.getEffect().isHeavyAccentuatedNote()){
        	velocity = Math.max(VelocityValues.MIN_VELOCITY,(velocity + (VelocityValues.VELOCITY_INCREMENT * 2)));
        }
                
        return ((velocity > 127)?127:velocity);
    }


    
    public void addMetronome(MidiSequence sequence,MeasureHeader header, long startMove){
    	if( (flags & ADD_METRONOME) != 0) {
    	
    		long start = (startMove + header.getStart());    	
    		long length = header.getTimeSignature().getDenominator().getTime();
    		for(int i = 1; i <= header.getTimeSignature().getNumerator();i ++){
    			makeNote(sequence,metronomeIndex(),DEFAULT_METRONOME_KEY,start,length,VelocityValues.DEFAULT,9);
    			start += length;
    		}		
    	}
    }
    
    public void addStartMoveMetaMessage(MidiSequence sequence,long start,long move) {        
    	if( (flags & ADD_TICK_MOVE_MESSAGES) != 0) {
    		sequence.addTickMove(getTick(start + move),infoIndex(), move);
    	}
    }

    public void addDefaultMessages(MidiSequence sequence) {        
    	if( (flags & ADD_DEFAULT_CONTROLS) != 0) {
    		for(int i = 0; i < 16; i ++){        	    		
    			sequence.addControlChange(getTick(Duration.QUARTER_TIME),infoIndex(),i,MidiControllers.REGISTERED_PARAMETER_FINE,0);	        	
    			sequence.addControlChange(getTick(Duration.QUARTER_TIME),infoIndex(),i,MidiControllers.REGISTERED_PARAMETER_COARSE,0);
    			sequence.addControlChange(getTick(Duration.QUARTER_TIME),infoIndex(),i,MidiControllers.DATA_ENTRY_COARSE,12);
    			sequence.addControlChange(getTick(Duration.QUARTER_TIME),infoIndex(),i,MidiControllers.REGISTERED_PARAMETER_COARSE,0);
    			sequence.addControlChange(getTick(Duration.QUARTER_TIME),infoIndex(),i,MidiControllers.REGISTERED_PARAMETER_FINE,1);
    			sequence.addControlChange(getTick(Duration.QUARTER_TIME),infoIndex(),i,MidiControllers.DATA_ENTRY_COARSE,64);
    			sequence.addControlChange(getTick(Duration.QUARTER_TIME),infoIndex(),i,MidiControllers.REGISTERED_PARAMETER_FINE,127);    		
    		}        
    	}
    }    
    
    private void addBend(MidiSequence sequence,int track, long tick,int bend, int channel) {   
    	sequence.addPitchBend(getTick(tick),track,channel,bend);
    }         
        
    public void makeVibrato(MidiSequence sequence,int track,long start, long duration,int channel){
        long end = start + duration;
        
        while(start < end){            
            start = ((start + 160 > end)?end:start + 160);            
            addBend(sequence,track,start,DEFAULT_BEND,channel);
            start = ((start + 160 > end)?end:start + 160);
            addBend(sequence,track,start,DEFAULT_BEND + (int)(DEFAULT_BEND_SEMI_TONE / 4.0f),channel);
        }
        addBend(sequence,track,start,DEFAULT_BEND,channel);        
    }    
    
    public void makeBend(MidiSequence sequence,int track,long start, long duration, BendEffect bend, int channel){    	
        List points = bend.getPoints();
        for(int i=0;i<points.size();i++){
            BendEffect.BendPoint point = (BendEffect.BendPoint)points.get(i);                        
            long bendStart = start + point.getTime(duration);
            int value = DEFAULT_BEND + (int)((float)point.getValue() * DEFAULT_BEND_SEMI_TONE / ((float)BendEffect.SEMITONE_LENGTH));
            value = ((value <= 127)?value:127);
            value = ((value >= 0)?value:0);            
            addBend(sequence,track,bendStart,value,channel);
            
            if(points.size() > i + 1){
                BendEffect.BendPoint nextPoint = (BendEffect.BendPoint)points.get(i + 1);
                int nextValue = DEFAULT_BEND + (int)((float)nextPoint.getValue() * DEFAULT_BEND_SEMI_TONE / ((float)BendEffect.SEMITONE_LENGTH));
                long nextBendStart = start + nextPoint.getTime(duration);         
                if(nextValue != value){
                	double width = ( (nextBendStart - bendStart) / Math.abs(  (nextValue - value) ) );                
                	//ascendente
                	if(value < nextValue){
                		while(value < nextValue){            
                			value ++;       
                			bendStart +=width;
                			addBend(sequence,track,bendStart,((value <= 127)?value:127),channel);
                		}
                		//descendente
                	}else if(value > nextValue){
                		while(value > nextValue){            
                			value --;       
                			bendStart +=width;
                			addBend(sequence,track,bendStart,((value >= 0)?value:0),channel);
                		}
                	}
                }
            }
        }       
        addBend(sequence,track,start + duration,DEFAULT_BEND,channel);
    }    
    
    public void makeTremoloBar(MidiSequence sequence,int track,long start, long duration, TremoloBarEffect effect, int channel){                        
        List points = effect.getPoints();
        for(int i=0;i<points.size();i++){
        	TremoloBarEffect.TremoloBarPoint point = (TremoloBarEffect.TremoloBarPoint)points.get(i);            
        	long pointStart = start + point.getTime(duration);
        	int value = DEFAULT_BEND + (int)((float)point.getValue() * DEFAULT_BEND_SEMI_TONE / ((float)TremoloBarEffect.SEMITONE_LENGTH));                                    
            value = ((value <= 127)?value:127);
            value = ((value >= 0)?value:0);
            addBend(sequence,track,pointStart,value,channel);            
            if(points.size() > i + 1){
            	TremoloBarEffect.TremoloBarPoint nextPoint = (TremoloBarEffect.TremoloBarPoint)points.get(i + 1);
                int nextValue = DEFAULT_BEND + (int)((float)nextPoint.getValue() * DEFAULT_BEND_SEMI_TONE / ((float)TremoloBarEffect.SEMITONE_LENGTH));
                long nextPointStart = start + nextPoint.getTime(duration);                
                if(nextValue != value){                
                	double width = ( (nextPointStart - pointStart) / Math.abs(  (nextValue - value) ) );                
                	//ascendente
                	if(value < nextValue){
                		while(value < nextValue){            
                			value ++;       
                			pointStart +=width;
                			addBend(sequence,track,pointStart,((value <= 127)?value:127),channel);
                		}
                	//descendente
                	}else if(value > nextValue){
                		while(value > nextValue){            
                			value --;       
                			pointStart += width;
                			addBend(sequence,track,pointStart,((value >= 0)?value:0),channel);
                		}
                	}                
                }
            }
        }       
        addBend(sequence,track,start + duration,DEFAULT_BEND,channel);
    }    
    
    public void makeSlide(MidiSequence sequence,int track,Note note,Note nextNote,long startMove,int channel){
        if(nextNote != null){
            makeSlide(sequence,track,note.getStart()+startMove,note.getValue(),nextNote.getStart() + startMove,nextNote.getValue(),channel);
            addBend(sequence,track,nextNote.getStart() + startMove,DEFAULT_BEND,channel);  
        }
    }

    public void makeSlide(MidiSequence sequence,int track,long tick1,int value1,long tick2,int value2,int channel){    	
    	long distance = (value2 - value1);
    	long length = (tick2 - tick1);
    	int points = (int)(length / (Duration.QUARTER_TIME / 8));
    	for(int i = 1;i <= points; i ++){            		
    		float tone = ((((length / points) * (float)i) * (float)distance) / (float)length);
    		int bend = (DEFAULT_BEND + (int)((float)tone * DEFAULT_BEND_SEMI_TONE));
    		addBend(sequence,track,tick1 + ( (length / points) * i),bend,channel); 
    	}
    }
    
    private void makeFadeIn(MidiSequence sequence,int track,long start,long duration,int volume,int channel){
    	int newVolume = 40;
    	if(volume > newVolume){    		
    		int interval = (int)(duration / 4);
    		int times = (int)(duration / interval);    		
    		int increment = ((volume - newVolume) / times);    	
    		for(long tick = start;tick < (start + duration);tick += interval){    
    			sequence.addControlChange(getTick(tick),track,channel,MidiControllers.VOLUME, newVolume);
    			newVolume += increment;
    		}    		
    		sequence.addControlChange(getTick((start + duration)),track,channel, MidiControllers.VOLUME,volume);
    	}
    }
    
    private Note getNextNote(Note note,List measures, int measureIndex, int noteIndex){ 
        noteIndex ++;
        for (int mIdx = measureIndex; mIdx < measures.size(); mIdx++) {
            Measure measure = (Measure) measures.get(mIdx);
            for (int nIdx = noteIndex; nIdx < measure.getNotes().size(); nIdx++) {
                Note currNote = (Note) measure.getNotes().get(nIdx);
                if(currNote.getStart() > note.getStart()){
                    if(currNote.getString() == note.getString()){
                    	return currNote;
                    }
                    return null;
                }
            }
            noteIndex = 0;
        }
        
        return null;        
    }    
        
    private Note getPrevNote(Note note,List measures, int measureIndex, int noteIndex){
        Note prevNote = null;                
        for (int mIdx = measureIndex; mIdx >= 0; mIdx--) {
            Measure measure = (Measure) measures.get(mIdx);
            if(noteIndex < 0){
                noteIndex = measure.getNotes().size();
            }
            for (int nIdx = noteIndex - 1; nIdx >= 0; nIdx--) {
                Note currNote = (Note) measure.getNotes().get(nIdx);
                if(currNote.getString() == note.getString() && currNote.getStart() < note.getStart()){
                    if(prevNote == null || currNote.getStart() > prevNote.getStart()){
                        prevNote = currNote;
                    }
                }
            }
            if(prevNote != null){
                break;
            }
            noteIndex = -1;
        }
        
        return prevNote;        
    }
    
    private NoteData checkTripletFeel(Measure measure,Note note,int noteIndex){
    	NoteData data = new NoteData();
    	data.start = note.getStart();
    	data.duration = note.getDuration().getTime();
    	    	
    	if(measure.getTripletFeel() == MeasureHeader.TRIPLET_FEEL_EIGHTH){
    		if(note.getDuration().isEqual(new Duration(Duration.EIGHTH,false,false,Duration.NO_TUPLETO))){
    			int time = (int)((Math.round((double)((double)note.getStart() / 10.00)) * 10) % 1000);
    			//first time
    			if(time == 0){
    				Note next = getNextNote(note,measure,noteIndex);
    				if(next != null && next.getDuration().isEqual(new Duration(Duration.EIGHTH,false,false,Duration.NO_TUPLETO))){
    					data.duration = (new Duration(Duration.EIGHTH,false,false,new Tupleto(3,2)).getTime() * 2);
    				}
    			}
    			//second time
    			else if(time == (Duration.QUARTER_TIME / 2)){
    				Note prev = getPrevNote(note,measure,noteIndex);
    				if(prev != null && prev.getDuration().isEqual(new Duration(Duration.EIGHTH,false,false,Duration.NO_TUPLETO))){
    					Duration duration = new Duration(Duration.EIGHTH,false,false,new Tupleto(3,2));
    					data.start = prev.getStart() + (duration.getTime() * 2);
    					data.duration = duration.getTime();
    				}
    			}    		
    		}
    	}else if(measure.getTripletFeel() == MeasureHeader.TRIPLET_FEEL_SIXTEENTH){
    		if(note.getDuration().isEqual(new Duration(Duration.SIXTEENTH,false,false,Duration.NO_TUPLETO))){    	
    			int time = (int)((Math.round((double)((double)note.getStart() / 10.00)) * 10) % 500);
    			//first time
    			if(time == 0){
    				Note next = getNextNote(note,measure,noteIndex);
    				if(next != null && next.getDuration().isEqual(new Duration(Duration.SIXTEENTH,false,false,Duration.NO_TUPLETO))){
    					data.duration = (new Duration(Duration.SIXTEENTH,false,false,new Tupleto(3,2)).getTime() * 2);
    				}
    			}
    			//second time
    			else if(time == (Duration.QUARTER_TIME / 4)){
    				Note prev = getPrevNote(note,measure,noteIndex);
    				if(prev != null && prev.getDuration().isEqual(new Duration(Duration.SIXTEENTH,false,false,Duration.NO_TUPLETO))){
    					Duration duration = new Duration(Duration.SIXTEENTH,false,false,new Tupleto(3,2));
    					data.start = prev.getStart() + (duration.getTime() * 2);
    					data.duration = duration.getTime();
    				}
    			}    		
    		}
    	}
    	
    	
    	return data;
    }
    
    private Note getPrevNote(Note note,Measure measure,int noteIndex){
        Note prevNote = null;                
        for (int nIdx = noteIndex - 1; nIdx >= 0; nIdx--) {
        	Note currNote = (Note) measure.getNotes().get(nIdx);
            if(currNote.getStart() < note.getStart()){
            	if(prevNote == null || currNote.getStart() > prevNote.getStart()){
            		prevNote = currNote;
                }
            }
        }
        
        return prevNote;        
    }
    
    private Note getNextNote(Note note,Measure measure,int noteIndex){
        Note nextNote = null;                
        for (int nIdx = noteIndex + 1; nIdx < measure.getNotes().size(); nIdx++) {
        	Note currNote = (Note) measure.getNotes().get(nIdx);
            if(currNote.getStart() > note.getStart()){
            	if(nextNote == null || currNote.getStart() < nextNote.getStart()){
            		nextNote = currNote;
                }
            }
        }        
        return nextNote;        
    }   
    
    private class NoteData{
    	private long start;
    	private long duration;    	
    }
}