/*
 * Created on 09-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.io;

import java.io.File;
import java.io.FileNotFoundException;

import org.herac.tuxguitar.io.gp.GPFormatException;
import org.herac.tuxguitar.io.tg.TGOutputStream;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Song;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class TGConverter {
	private SongManager manager;
    private String sourceFolder;
    private String destinationFolder;
    
    public TGConverter(String sourceFolder,String destinationFolder){
    	this.manager = new SongManager();
        this.sourceFolder = sourceFolder;
        this.destinationFolder = destinationFolder;
    }
    
    public void convert(String fileName, String convertFileName) {
    	try {
    		if(manager.open(fileName)){       
    			manager.autoCompleteSilences();    			
    			System.out.print(convertFileName);
    			new File(new File(convertFileName).getParent()).mkdirs();    			
    			new TGOutputStream(convertFileName).write(manager.getSong()); 
    			System.out.println(" [OK] ");
    		}else if (fileName.endsWith(".gp3") || fileName.endsWith(".gp4") || fileName.endsWith(".gp5")) {
    			System.err.println(fileName + " [Unsupported Version]");
    		}
    	} catch (FileNotFoundException e) {
    	} catch (GPFormatException e) {
            System.out.println(convertFileName + " [FAILED] ");
            System.out.println(" ********** REASON: " + e.getClass().getName() + " ********** ");
            e.printStackTrace();
            System.exit(1);    		
        } catch (Exception e) {
            System.out.println(convertFileName + " [FAILED] ");
            System.out.println(" ********** REASON: " + e.getClass().getName() + " ********** ");
            e.printStackTrace();
            System.exit(1);
        } catch (OutOfMemoryError e) {
            System.out.println(convertFileName + "  [FAILED]  ");
            System.out.println(" ********** REASON: OutOfMemoryError ********** ");
            System.gc();
        }       
    }

    private void process(File folder) {
        String[] fileNames = folder.list();
        if(fileNames != null){
        	for (int i = 0; i < fileNames.length; i++) {
        		File file = new File(folder.getPath() + "/" + fileNames[i]);
        		if (file.isDirectory()) {
        			process(file);
        		} else {
        			String fileName = file.getAbsolutePath();
        			String convertFileName = getConvertFileName(fileName);
        			convert(fileName, convertFileName);
        		}
        		fileNames[i] = null;
        	}
        }
    }

    private String getConvertFileName(String path) {
        String convertPath = (destinationFolder + File.separator +path.substring(sourceFolder.length()));
        if (convertPath.endsWith(".gp3") || convertPath.endsWith(".gp4") || convertPath.endsWith(".gp5")) {
        	convertPath = convertPath.replaceAll(".gp3", ".tg");
        	convertPath = convertPath.replaceAll(".gp4", ".tg");
        	convertPath = convertPath.replaceAll(".gp5", ".tg");
        }        
        return convertPath;
    }

    private void writeSong(String fileName, Song song) {
        try {
            new TGOutputStream(fileName).write(song);
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }
    

    public static void main(String args[]) {
        if(args.length >= 2){ 
            String sourceFolder = args[0];
            String destinationFolder = args[1];
            
            TGConverter converter = new TGConverter(sourceFolder,destinationFolder);
            File initFolder = new File(sourceFolder);
            converter.process(initFolder);
        }else{
            showHelp();
        }
        System.exit(0);
    }

    private static void showHelp(){
        System.out.println("usage options:  [SOURCE FOLDER] [DESTINATION FOLDER]");
    }
        

}