package org.herac.tuxguitar.gui.util;

import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.herac.tuxguitar.gui.TuxGuitar;

public class TuxGuitarFileUtils {
	private static final String APP_CONFIG_DOMAIN = ".tuxguitar";
	private static final String APP_CONFIG_DOMAIN_ENV_VAR = "TUXGUITAR_CONFIG_HOME";	
	private static final String SYSTEM_SHARED_PROPERTY = "tuxguitar.shared.path";
	
	public static final String USER_CONFIG_PREFIX = getUserConfigDir();
	public static final String IMAGE_PREFIX = getRealPath("files");
	public static final String LANGUAGE_PREFIX = getRealPath("lang");
	public static final String PLUGINS_PREFIX = getRealPath("plugins");
	public static final String SCALES_PREFIX = getRealPath("scales");
	
	public static Image loadImage(String name){
		if(IMAGE_PREFIX != null){
			try{
				return new Image(TuxGuitar.instance().getDisplay(),new ImageData(IMAGE_PREFIX + name));
			}catch(Exception e){
				System.err.println(IMAGE_PREFIX + name + ": not found");
			}
		}		
		return new Image(TuxGuitar.instance().getDisplay(),16,16);
	}
	
	
	public static String getRealPath(String resource){
		String resourcePath = null;		
		String path = System.getProperty(SYSTEM_SHARED_PROPERTY);
		if(path != null){
			resourcePath = path + System.getProperty("file.separator") + resource;
		}else{	
			resourcePath = getResourcePath(resource);
		}		
		if(resourcePath != null){
			return new File(resourcePath).getAbsolutePath() + System.getProperty("file.separator");
		}
		return null;
	}
	
	
	public static String getResourcePath(String resource) {
        URL url = TuxGuitarFileUtils.class.getClassLoader().getResource(resource);        
		try {
			if(url != null){
				return URLDecoder.decode(url.getPath(), "UTF-8");
			}
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return null;
	}
	
	public static InputStream getResourceAsStream(String resource) {
        return TuxGuitarFileUtils.class.getClassLoader().getResourceAsStream(resource);        
	}	
	
    public static String getUserConfigDir(){   
    	String appConfigDomain = null;    	    	
    	//System Env Var for tuxguitar
    	try{
    		appConfigDomain = System.getenv(APP_CONFIG_DOMAIN_ENV_VAR);
    	}catch(java.lang.Error e){    		
    	}
    	//Default System User Home    	
    	if(appConfigDomain == null){
    		appConfigDomain = System.getProperty("user.home") + System.getProperty("file.separator") + APP_CONFIG_DOMAIN;    	
    	}    	
    	//Check if path exists
		File file = new File(appConfigDomain);
		if(!file.exists()){
			file.mkdirs();
		}    	
    	
    	return appConfigDomain;
    }	
}
