package org.herac.tuxguitar.gui.undo.undoables.custom;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableCaretHelper;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Measure;

public class UndoableChangeCloseRepeat implements UndoableEdit{
	private int doAction;
	private UndoableCaretHelper undoCaret;
	private UndoableCaretHelper redoCaret;		
	private long position;
	private int undoNumberOfRepetitions;
	private int redoNumberOfRepetitions;
	
	private UndoableChangeCloseRepeat(){
		
	}
	
	public void redo() throws CannotRedoException {	
		if(!canRedo()){
			throw new CannotRedoException();
		}        
		SongManager manager = TuxGuitar.instance().getSongManager();
		manager.changeCloseRepeat(this.position,this.redoNumberOfRepetitions);
		Measure measure = manager.getTrackManager().getMeasureAt(manager.getFirstTrack(),position);		 
		TuxGuitar.instance().getTablatureEditor().getTablature().getViewLayout().fireUpdate(measure.getNumber(),false); 
		this.redoCaret.update();
		
		this.doAction = UNDO_ACTION;
	}

	public void undo() throws CannotUndoException {
		if(!canUndo()){
			throw new CannotUndoException();
		}	
		SongManager manager = TuxGuitar.instance().getSongManager();
		manager.changeCloseRepeat(this.position,this.undoNumberOfRepetitions);
		Measure measure = manager.getTrackManager().getMeasureAt(manager.getFirstTrack(),position);		
		TuxGuitar.instance().getTablatureEditor().getTablature().getViewLayout().fireUpdate(measure.getNumber(),false);
		this.undoCaret.update();
		
		this.doAction = REDO_ACTION;
	}

    public boolean canRedo() {
        return (doAction == REDO_ACTION);
    }

    public boolean canUndo() {
        return (doAction == UNDO_ACTION);
    }
      
    public static UndoableChangeCloseRepeat startUndo(){
    	UndoableChangeCloseRepeat undoable = new UndoableChangeCloseRepeat();
    	Caret caret = getCaret();    	    	
    	undoable.doAction = UNDO_ACTION;
    	undoable.undoCaret = new UndoableCaretHelper();
    	undoable.position = caret.getPosition();
    	undoable.undoNumberOfRepetitions = caret.getMeasureCoords().getMeasure().getNumberOfRepetitions();
    	
    	return undoable;
    }
    
    public UndoableChangeCloseRepeat endUndo(int redoNumberOfRepetitions){
    	this.redoCaret = new UndoableCaretHelper();
    	this.redoNumberOfRepetitions = redoNumberOfRepetitions;
    	return this;
    }
    
    private static Caret getCaret(){
    	return TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
    }  

}
