package org.herac.tuxguitar.gui.system.keybindings;

import java.util.StringTokenizer;

import org.eclipse.swt.SWT;

public class KeyBinding {
	public static final String ALT_STRING = "Alt";
	public static final String SHIFT_STRING = "Shift";
	public static final String CONTROL_STRING = "Control";
	public static final String MASK_SEPARATOR = "+";
	
	private int mask;
	private int key;
	
	public KeyBinding(int key,int mask){
		this.key = key;
		this.mask = mask;
	}
	
	public KeyBinding(){
		this(0,0);
	}
	
	
	public int getKey() {
		return key;
	}
	public void setKey(int key) {
		this.key = key;
	}
	public int getMask() {
		return mask;
	}
	public void setMask(int mask) {
		this.mask = mask;
	}
	
	public static KeyBinding parse(String keystring){
		String key=keystring;
		KeyBinding keybinding = new KeyBinding();
		int mask=0;
		
		// process mask
		if (keystring.indexOf(MASK_SEPARATOR)!= -1){
			StringTokenizer st = new StringTokenizer(keystring,MASK_SEPARATOR);
			while(st.hasMoreTokens()){
				String token = st.nextToken();
				
				// only process if this is not the last token
				if (st.hasMoreTokens()){
					// add the mask
					mask |= getMaskCode(token);
				}
				else {
					key = token;
				}
			}
		}
		
		keybinding.setMask(mask);
		
		// process key
		int keycode = getSpecialKeyCode(key);
		if (keycode == 0)
			keycode = getKeyCode(key);
		
		keybinding.setKey(keycode);
		
		return keybinding;
	}
	
	private static int getKeyCode(String key){
		return (int)key.charAt(0);
	}
	
	private static int getSpecialKeyCode(String key){
		for(int i = 0; i < KeyConversion.relations.length; i++){
			if (key.equals(KeyConversion.relations[i].key)){
				return KeyConversion.relations[i].code;
			}
		}
		
		return 0;
	}
	
	
	
	public boolean equals(Object obj) {
		if (obj == null)
			return false;
		if (!(obj instanceof KeyBinding))
			return false;
		
		KeyBinding kb = (KeyBinding)obj;
		
		return key == kb.key && mask == kb.mask;
	}
	
	public int hashCode() {
		return new Integer(key + mask).hashCode();
	}
	
	/**
	 * get the mask code for this string
	 * @param mask
	 * @return
	 */
	private static int getMaskCode(String mask){
		if (mask.equals(ALT_STRING))
			return SWT.ALT;
		else if (mask.equals(SHIFT_STRING))
			return SWT.SHIFT;
		else if (mask.equals(CONTROL_STRING))
			return SWT.CTRL;
		return 0;
	}
	
	private String getMaskString(){
		String maskstring = "";
		
		if ((mask & SWT.ALT) == SWT.ALT)
			maskstring += ALT_STRING+"+";
		
		if ((mask & SWT.SHIFT) == SWT.SHIFT)
			maskstring += SHIFT_STRING+"+";
			
		if ((mask & SWT.CTRL) == SWT.CTRL)
			maskstring += CONTROL_STRING+"+";

		return maskstring;
	}
	
	public String toString(){
		String s = getMaskString();
		
		String sp = getSpecialKey();
		if (sp != null)
			s+= sp;
		else
			s+= (char)key;
		
		return s;
	}
	
	private String getSpecialKey(){
		for(int i = 0; i < KeyConversion.relations.length; i++){
			if (key == KeyConversion.relations[i].code){
				return KeyConversion.relations[i].key;
			}
		}
		
		return null;
	}
	

	public Object clone(){
		return new KeyBinding(getKey(),getMask());
	}
	
}

class KeyConversion {
	static final KeyConversion[] relations = new KeyConversion[]{
		new KeyConversion("F1",SpecialKeys.F1),
		new KeyConversion("F2",SpecialKeys.F2),
		new KeyConversion("F3",SpecialKeys.F3),
		new KeyConversion("F4",SpecialKeys.F4),
		new KeyConversion("F5",SpecialKeys.F5),
		new KeyConversion("F6",SpecialKeys.F6),
		new KeyConversion("F7",SpecialKeys.F7),
		new KeyConversion("F8",SpecialKeys.F8),
		new KeyConversion("F9",SpecialKeys.F9),
		new KeyConversion("F10",SpecialKeys.F10),
		new KeyConversion("F11",SpecialKeys.F11),
		new KeyConversion("F12",SpecialKeys.F12),
		new KeyConversion("Esc",SpecialKeys.ESC),
		new KeyConversion("Pause",SpecialKeys.PAUSE),
		new KeyConversion("Print",SpecialKeys.PRINT_SCREEN),
		new KeyConversion("Ins",SpecialKeys.INSERT),
		new KeyConversion("Del",SpecialKeys.DEL),
		new KeyConversion("Home",SpecialKeys.HOME),
		new KeyConversion("PgUp",SpecialKeys.PAGE_UP),
		new KeyConversion("PgDn",SpecialKeys.PAGE_DOWN),
		new KeyConversion("End",SpecialKeys.END),
		new KeyConversion("Up",SpecialKeys.UP),
		new KeyConversion("Down",SpecialKeys.DOWN),		
		new KeyConversion("Left",SpecialKeys.LEFT),
		new KeyConversion("Right",SpecialKeys.RIGHT),	
		new KeyConversion("Alt",SpecialKeys.ALT),
		new KeyConversion("Control",SpecialKeys.CONTROL),
		new KeyConversion("Shift",SpecialKeys.SHIFT),
		new KeyConversion("Tab",SpecialKeys.TAB),
		new KeyConversion("Space",SpecialKeys.SPACE),
		new KeyConversion("Enter",SpecialKeys.ENTER),
		new KeyConversion("*",SpecialKeys.KEYPAD_MULTIPLY),
		new KeyConversion("/",SpecialKeys.KEYPAD_DIVIDE),
		new KeyConversion(".",SpecialKeys.KEYPAD_DECIMAL),		
	};
	
	String key;
	int code;
	KeyConversion(String key,int code){
		this.key = key;
		this.code = code;
	}
}