package org.herac.tuxguitar.gui.system.config.items;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.ToolBar;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.system.config.ConfigKeys;
import org.herac.tuxguitar.gui.system.config.ConfigEditor;

public class StylesOption extends Option{
	private static final int BUTTON_WIDTH = 85;
	private static final int BUTTON_HEIGHT = 30;
	
	private FontData defaultFontData;
	private FontData noteFontData;
	private FontData timeSignatureFontData;    	
	private FontData printerDefaultFontData;
	private FontData printerNoteFontData;
	private FontData printerTimeSignatureFontData;    	    	
	private RGB scoreNoteRGB;    	
	private RGB tabNoteRGB;
	private RGB playNoteRGB;
	private RGB linesRGB;
	
    public StylesOption(ConfigEditor configEditor,ToolBar toolBar,final Composite parent){
        super(configEditor,toolBar,parent,TuxGuitar.getProperty("settings.config.styles"));
        this.defaultFontData = TuxGuitar.instance().getConfig().getFontDataConfigValue(ConfigKeys.FONT_DEFAULT);
        this.noteFontData = TuxGuitar.instance().getConfig().getFontDataConfigValue(ConfigKeys.FONT_NOTE);
        this.timeSignatureFontData = TuxGuitar.instance().getConfig().getFontDataConfigValue(ConfigKeys.FONT_TIME_SIGNATURE);            
        this.printerDefaultFontData = TuxGuitar.instance().getConfig().getFontDataConfigValue(ConfigKeys.FONT_PRINTER_DEFAULT);
        this.printerNoteFontData = TuxGuitar.instance().getConfig().getFontDataConfigValue(ConfigKeys.FONT_PRINTER_NOTE);
        this.printerTimeSignatureFontData = TuxGuitar.instance().getConfig().getFontDataConfigValue(ConfigKeys.FONT_PRINTER_TIME_SIGNATURE);
        
        this.scoreNoteRGB = TuxGuitar.instance().getConfig().getRGBConfigValue(ConfigKeys.COLOR_SCORE_NOTE);
        this.tabNoteRGB = TuxGuitar.instance().getConfig().getRGBConfigValue(ConfigKeys.COLOR_TAB_NOTE);
        this.playNoteRGB = TuxGuitar.instance().getConfig().getRGBConfigValue(ConfigKeys.COLOR_PLAY_NOTE);
        this.linesRGB = TuxGuitar.instance().getConfig().getRGBConfigValue(ConfigKeys.COLOR_LINE);
        if(this.scoreNoteRGB == null){
        	this.scoreNoteRGB  = TuxGuitar.instance().getTablatureEditor().getTablature().getScoreNoteColor().getRGB();
        }
        if(this.tabNoteRGB == null){
        	this.tabNoteRGB  = TuxGuitar.instance().getTablatureEditor().getTablature().getTabNoteColor().getRGB();
        }
        if(this.playNoteRGB == null){
        	this.playNoteRGB  = TuxGuitar.instance().getTablatureEditor().getTablature().getPlayNoteColor().getRGB();
        }     
        if(this.linesRGB == null){
        	this.linesRGB  = TuxGuitar.instance().getTablatureEditor().getTablature().getLineColor().getRGB();
        }             
    }
    
    public void createOption(){		
		getToolItem().setText(TuxGuitar.getProperty("settings.config.styles"));	
		getToolItem().setImage(SystemImages.OPTION_STYLE);
		getToolItem().addSelectionListener(this);
		
		Composite styles = new Composite(getComposite(),SWT.NONE);
		styles.setLayout(new GridLayout(2,false));
		styles.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));
		    				
		showLabel(styles,SWT.LEFT | SWT.WRAP,SWT.NORMAL,0,TuxGuitar.getProperty("settings.config.styles.font.default"));		
	    Button defaultFontButton = new Button(styles, SWT.PUSH);
	    defaultFontButton.setLayoutData(makeButtonData());
	    defaultFontButton.setText(TuxGuitar.getProperty("choose"));
	    defaultFontButton.addSelectionListener(new SelectionAdapter() {			
			public void widgetSelected(SelectionEvent arg0) {
				FontData[] datas = null;
				if(defaultFontData != null){
					Font font = new Font(getDisplay(),defaultFontData);
					datas = font.getFontData();
					font.dispose();
				}
				if(datas == null){
					datas = TuxGuitar.instance().getTablatureEditor().getTablature().getDefaultFont().getFontData();
				}					
				FontDialog fontDialog = new FontDialog(getShell());
				fontDialog.setFontList(datas);
				FontData data = fontDialog.open();
				if(data != null){
					defaultFontData = data;
				}
			}			
		});
	        		
	    showLabel(styles,SWT.LEFT | SWT.WRAP,SWT.NORMAL,0,TuxGuitar.getProperty("settings.config.styles.font.note"));	    
	    Button noteFontButton = new Button(styles, SWT.PUSH);
	    noteFontButton.setLayoutData(makeButtonData());
	    noteFontButton.setText(TuxGuitar.getProperty("choose"));
	    noteFontButton.addSelectionListener(new SelectionAdapter() {			
			public void widgetSelected(SelectionEvent arg0) {
				FontData[] datas = null;
				if(noteFontData != null){
					Font font = new Font(getDisplay(),noteFontData);
					datas = font.getFontData();
					font.dispose();
				}
				if(datas == null){
					datas = TuxGuitar.instance().getTablatureEditor().getTablature().getNoteFont().getFontData();
				}						
				FontDialog fontDialog = new FontDialog(getShell());
				fontDialog.setFontList(datas);
				FontData data = fontDialog.open();
				if(data != null){
					noteFontData = data;
				}
			}			
		});
	        		
	    showLabel(styles,SWT.LEFT | SWT.WRAP,SWT.NORMAL,0,TuxGuitar.getProperty("settings.config.styles.font.time-signature"));	    
	    Button timeSignatureButton = new Button(styles, SWT.PUSH);
	    timeSignatureButton.setLayoutData(makeButtonData());
	    timeSignatureButton.setText(TuxGuitar.getProperty("choose"));
	    timeSignatureButton.addSelectionListener(new SelectionAdapter() {			
			public void widgetSelected(SelectionEvent arg0) {
				FontData[] datas = null;
				if(timeSignatureFontData != null){
					Font font = new Font(getDisplay(),timeSignatureFontData);
					datas = font.getFontData();
					font.dispose();
				}
				if(datas == null){
					datas = TuxGuitar.instance().getTablatureEditor().getTablature().getTimeSignatureFont().getFontData();
				}						
				FontDialog fontDialog = new FontDialog(getShell());
				fontDialog.setFontList(datas);
				FontData data = fontDialog.open();
				if(data != null){
					timeSignatureFontData = data;
				}
			}			
		});     	    

	    showLabel(styles,SWT.LEFT | SWT.WRAP,SWT.NORMAL,0,TuxGuitar.getProperty("settings.config.styles.font.printer-default"));        	    
	    Button printerDefaultFontButton = new Button(styles, SWT.PUSH);
	    printerDefaultFontButton.setLayoutData(makeButtonData());
	    printerDefaultFontButton.setText(TuxGuitar.getProperty("choose"));
	    printerDefaultFontButton.addSelectionListener(new SelectionAdapter() {			
			public void widgetSelected(SelectionEvent arg0) {
				FontData[] datas = null;
				if(printerDefaultFontData != null){
					Font font = new Font(getDisplay(),printerDefaultFontData);
					datas = font.getFontData();
					font.dispose();
				}
				if(datas == null){
					datas = TuxGuitar.instance().getTablatureEditor().getTablature().getPrinterDefaultFont().getFontData();
				}					
				FontDialog fontDialog = new FontDialog(getShell());
				fontDialog.setFontList(datas);
				FontData data = fontDialog.open();
				if(data != null){
					printerDefaultFontData = data;
				}
			}			
		});
	        		
	    showLabel(styles,SWT.LEFT | SWT.WRAP,SWT.NORMAL,0,TuxGuitar.getProperty("settings.config.styles.font.printer-note"));	    
	    Button printerNoteFontButton = new Button(styles, SWT.PUSH);
	    printerNoteFontButton.setLayoutData(makeButtonData());
	    printerNoteFontButton.setText(TuxGuitar.getProperty("choose"));
	    printerNoteFontButton.addSelectionListener(new SelectionAdapter() {			
			public void widgetSelected(SelectionEvent arg0) {
				FontData[] datas = null;
				if(printerNoteFontData != null){
					Font font = new Font(getDisplay(),printerNoteFontData);
					datas = font.getFontData();
					font.dispose();
				}
				if(datas == null){
					datas = TuxGuitar.instance().getTablatureEditor().getTablature().getPrinterNoteFont().getFontData();
				}						
				FontDialog fontDialog = new FontDialog(getShell());
				fontDialog.setFontList(datas);
				FontData data = fontDialog.open();
				if(data != null){
					printerNoteFontData = data;
				}
			}			
		});
	    	       	
	    showLabel(styles,SWT.LEFT | SWT.WRAP,SWT.NORMAL,0,TuxGuitar.getProperty("settings.config.styles.font.printer-time-signature"));	    
	    Button printerTimeSignatureButton = new Button(styles, SWT.PUSH);
	    printerTimeSignatureButton.setLayoutData(makeButtonData());
	    printerTimeSignatureButton.setText(TuxGuitar.getProperty("choose"));
	    printerTimeSignatureButton.addSelectionListener(new SelectionAdapter() {			
			public void widgetSelected(SelectionEvent arg0) {
				FontData[] datas = null;
				if(printerTimeSignatureFontData != null){
					Font font = new Font(getDisplay(),printerTimeSignatureFontData);
					datas = font.getFontData();
					font.dispose();
				}
				if(datas == null){
					datas = TuxGuitar.instance().getTablatureEditor().getTablature().getPrinterTimeSignatureFont().getFontData();
				}						
				FontDialog fontDialog = new FontDialog(getShell());
				fontDialog.setFontList(datas);
				FontData data = fontDialog.open();
				if(data != null){
					printerTimeSignatureFontData = data;
				}
			}			
		});     	    
	    
	    showLabel(styles,SWT.LEFT | SWT.WRAP,SWT.NORMAL,0,TuxGuitar.getProperty("settings.config.styles.color.score-note"));
        final Button scoreNoteColorButton = new Button(styles, SWT.PUSH);
        scoreNoteColorButton.setLayoutData(makeButtonData());
        setButtonColor(scoreNoteColorButton,this.scoreNoteRGB);
        scoreNoteColorButton.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent event) {
                ColorDialog dlg = new ColorDialog(getShell());
                dlg.setRGB(getDisplay().getSystemColor(SWT.COLOR_BLACK).getRGB());
                dlg.setText(TuxGuitar.getProperty("choose-color"));
                RGB rgb = dlg.open();
                if (rgb != null) {
                	scoreNoteRGB = new RGB(rgb.red,rgb.green,rgb.blue);
                    setButtonColor(scoreNoteColorButton,rgb);                        
                }
            }
        });
        
        showLabel(styles,SWT.LEFT | SWT.WRAP,SWT.NORMAL,0,TuxGuitar.getProperty("settings.config.styles.color.tab-note"));
        final Button tabNoteColorButton = new Button(styles, SWT.PUSH);
        tabNoteColorButton.setLayoutData(makeButtonData());
        setButtonColor(tabNoteColorButton,this.tabNoteRGB);
        tabNoteColorButton.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent event) {
                ColorDialog dlg = new ColorDialog(getShell());
                dlg.setRGB(getDisplay().getSystemColor(SWT.COLOR_BLACK).getRGB());
                dlg.setText(TuxGuitar.getProperty("choose-color"));
                RGB rgb = dlg.open();
                if (rgb != null) {
                	tabNoteRGB = new RGB(rgb.red,rgb.green,rgb.blue);
                    setButtonColor(tabNoteColorButton,rgb);                        
                }
            }
        });               
        
        showLabel(styles,SWT.LEFT | SWT.WRAP,SWT.NORMAL,0,TuxGuitar.getProperty("settings.config.styles.color.play-note"));
        final Button playNoteColorButton = new Button(styles, SWT.PUSH);
        playNoteColorButton.setLayoutData(makeButtonData());
        setButtonColor(playNoteColorButton, this.playNoteRGB);
        playNoteColorButton.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent event) {
                ColorDialog dlg = new ColorDialog(getShell());
                dlg.setRGB(getDisplay().getSystemColor(SWT.COLOR_BLACK).getRGB());
                dlg.setText(TuxGuitar.getProperty("choose-color"));
                RGB rgb = dlg.open();
                if (rgb != null) {
                	playNoteRGB = new RGB(rgb.red,rgb.green,rgb.blue);
                    setButtonColor(playNoteColorButton,rgb);                        
                }
            }
        });            
        
        showLabel(styles,SWT.LEFT | SWT.WRAP,SWT.NORMAL,0,TuxGuitar.getProperty("settings.config.styles.color.lines"));
        final Button linesColorButton = new Button(styles, SWT.PUSH);
        linesColorButton.setLayoutData(makeButtonData());
        setButtonColor(linesColorButton, this.linesRGB);
        linesColorButton.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent event) {
                ColorDialog dlg = new ColorDialog(getShell());
                dlg.setRGB(getDisplay().getSystemColor(SWT.COLOR_BLACK).getRGB());
                dlg.setText(TuxGuitar.getProperty("choose-color"));
                RGB rgb = dlg.open();
                if (rgb != null) {
                	linesRGB = new RGB(rgb.red,rgb.green,rgb.blue);
                    setButtonColor(linesColorButton,rgb);                        
                }
            }
        });                  
    }                        
   
	public GridData makeButtonData(){
		GridData data = new GridData(SWT.RIGHT,SWT.CENTER,true,true);
    	data.minimumWidth = BUTTON_WIDTH;
    	data.minimumHeight = BUTTON_HEIGHT;
		return data;
	}
    
    private void setButtonColor(Button button,RGB rgb) {
    	Color color = new Color(getDisplay(),rgb);
    	Image image = new Image(getDisplay(),(BUTTON_WIDTH - 10),(BUTTON_HEIGHT - 10));
        GC gc = new GC(image);
        gc.setBackground(color);
        gc.fillRectangle(0, 0, (BUTTON_WIDTH - 10), (BUTTON_HEIGHT - 10));        
        gc.dispose();
        button.setImage(image);
    }        
    
    public void updateConfig(){    		
        if(defaultFontData != null){
        	getConfig().setProperty(ConfigKeys.FONT_DEFAULT,defaultFontData.getName() + "," + defaultFontData.getHeight()  + "," + defaultFontData.getStyle());
        }
        if(noteFontData != null){
        	getConfig().setProperty(ConfigKeys.FONT_NOTE,noteFontData.getName() + "," + noteFontData.getHeight() + "," + noteFontData.getStyle());
        }
        if(timeSignatureFontData != null){
        	getConfig().setProperty(ConfigKeys.FONT_TIME_SIGNATURE,timeSignatureFontData.getName() + "," + timeSignatureFontData.getHeight() + "," + timeSignatureFontData.getStyle());            	
        }   
        if(printerDefaultFontData != null){
        	getConfig().setProperty(ConfigKeys.FONT_PRINTER_DEFAULT,printerDefaultFontData.getName() + "," + printerDefaultFontData.getHeight()  + "," + printerDefaultFontData.getStyle());
        }
        if(printerNoteFontData != null){
        	getConfig().setProperty(ConfigKeys.FONT_PRINTER_NOTE,printerNoteFontData.getName() + "," + printerNoteFontData.getHeight() + "," + printerNoteFontData.getStyle());
        }
        if(printerTimeSignatureFontData != null){
        	getConfig().setProperty(ConfigKeys.FONT_PRINTER_TIME_SIGNATURE,printerTimeSignatureFontData.getName() + "," + printerTimeSignatureFontData.getHeight() + "," + printerTimeSignatureFontData.getStyle());            	
        }               
        if(scoreNoteRGB != null){
        	getConfig().setProperty(ConfigKeys.COLOR_SCORE_NOTE,scoreNoteRGB.red + "," + scoreNoteRGB.green + "," + scoreNoteRGB.blue);
        }
        if(tabNoteRGB != null){
        	getConfig().setProperty(ConfigKeys.COLOR_TAB_NOTE,tabNoteRGB.red + "," + tabNoteRGB.green + "," + tabNoteRGB.blue);
        }
        if(playNoteRGB != null){
        	getConfig().setProperty(ConfigKeys.COLOR_PLAY_NOTE,playNoteRGB.red + "," + playNoteRGB.green + "," + playNoteRGB.blue);
        }                  
        if(linesRGB != null){
        	getConfig().setProperty(ConfigKeys.COLOR_LINE,linesRGB.red + "," + linesRGB.green + "," + linesRGB.blue);
        }                 
    }
    
    public void applyConfig(boolean force){
    	TuxGuitar.instance().loadStyles();
    }
}