/*
 * Created on 02-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.items.tool;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.items.ToolItems;
/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class PlayerToolItems  extends ToolItems{
    public static final String NAME = "player.items";
    
	private static final int STATUS_STOPED = 1;
	private static final int STATUS_PAUSED = 2;
	private static final int STATUS_RUNNING = 3;    
	
    private ToolBar toolBar;
	private ToolItem first;
	private ToolItem last;
	private ToolItem previous;
	private ToolItem next;
	private ToolItem stop;
	private ToolItem play;	
	private int status;
	
    public PlayerToolItems(){
    	super(NAME);
    }
   
    public void showItems(ToolBar toolBar){
    	this.toolBar = toolBar;     
    	
		this.first = new ToolItem(toolBar,SWT.PUSH);
		this.first.setImage(SystemImages.TRANSPORT_ICON_FIRST_1);
		this.first.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				TuxGuitar.instance().getTransport().gotoFirst(e);
			}		
		});
		
		this.previous = new ToolItem(toolBar,SWT.PUSH);
		this.previous.setImage(SystemImages.TRANSPORT_ICON_PREVIOUS_1);
		this.previous.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				TuxGuitar.instance().getTransport().gotoPrevious(e);
			}		
		});    	
    	
		this.stop = new ToolItem(toolBar,SWT.PUSH);
		this.stop.setImage(SystemImages.TRANSPORT_ICON_STOP_1);
		this.stop.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				TuxGuitar.instance().getTransport().stop(e);
			}		
		});				
		
		this.play = new ToolItem(toolBar,SWT.PUSH);
		this.play.setImage(SystemImages.TRANSPORT_ICON_PLAY_1);
		this.play.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				TuxGuitar.instance().getTransport().play(e);
			}		
		});		
        
		this.next = new ToolItem(toolBar,SWT.PUSH);
		this.next.setImage(SystemImages.TRANSPORT_ICON_NEXT_1);
		this.next.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				TuxGuitar.instance().getTransport().gotoNext(e);
			}		
		});
		
		this.last = new ToolItem(toolBar,SWT.PUSH);
		this.last.setImage(SystemImages.TRANSPORT_ICON_LAST_1);
		this.last.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				TuxGuitar.instance().getTransport().gotoLast(e);
			}		
		});        
        
		this.status = STATUS_STOPED;
        this.loadProperties();
    }
 
    
    
    public void update(){
    	int lastStatus = this.status;
    	
        if(TuxGuitar.instance().getPlayer().isRunning()){
        	this.status = STATUS_RUNNING;					
		}else if(TuxGuitar.instance().getPlayer().isPaused()){
			this.status = STATUS_PAUSED;
		}else{
			this.status = STATUS_STOPED;
        }       	
    	
		if(lastStatus != this.status){
			if(this.status == STATUS_RUNNING){
				this.first.setImage(SystemImages.TRANSPORT_ICON_FIRST_2);
				this.last.setImage(SystemImages.TRANSPORT_ICON_LAST_2);
				this.previous.setImage(SystemImages.TRANSPORT_ICON_PREVIOUS_2);
				this.next.setImage(SystemImages.TRANSPORT_ICON_NEXT_2);
				this.stop.setImage(SystemImages.TRANSPORT_ICON_STOP_2);
				this.play.setImage(SystemImages.TRANSPORT_ICON_PAUSE);				
			}else if(this.status == STATUS_PAUSED){
				this.first.setImage(SystemImages.TRANSPORT_ICON_FIRST_2);
				this.last.setImage(SystemImages.TRANSPORT_ICON_LAST_2);
				this.previous.setImage(SystemImages.TRANSPORT_ICON_PREVIOUS_2);
				this.next.setImage(SystemImages.TRANSPORT_ICON_NEXT_2);
				this.stop.setImage(SystemImages.TRANSPORT_ICON_STOP_2);
				this.play.setImage(SystemImages.TRANSPORT_ICON_PLAY_2);	
				
			}else if(this.status == STATUS_STOPED){
				this.first.setImage(SystemImages.TRANSPORT_ICON_FIRST_1);
				this.last.setImage(SystemImages.TRANSPORT_ICON_LAST_1);
				this.previous.setImage(SystemImages.TRANSPORT_ICON_PREVIOUS_1);
				this.next.setImage(SystemImages.TRANSPORT_ICON_NEXT_1);
				this.stop.setImage(SystemImages.TRANSPORT_ICON_STOP_1);
				this.play.setImage(SystemImages.TRANSPORT_ICON_PLAY_1);
			}	
		}    	
    	        
    }
    
    public void loadProperties(){
        this.play.setToolTipText(TuxGuitar.getProperty("player.start"));
        this.stop.setToolTipText(TuxGuitar.getProperty("player.stop"));  
    }        
}

