/*
 * Created on 02-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.items.menu;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.effects.ChangeAccentuatedNoteAction;
import org.herac.tuxguitar.gui.actions.effects.ChangeBendNoteAction;
import org.herac.tuxguitar.gui.actions.effects.ChangeDeadNoteAction;
import org.herac.tuxguitar.gui.actions.effects.ChangeFadeInAction;
import org.herac.tuxguitar.gui.actions.effects.ChangeGhostNoteAction;
import org.herac.tuxguitar.gui.actions.effects.ChangeGraceNoteAction;
import org.herac.tuxguitar.gui.actions.effects.ChangeHammerNoteAction;
import org.herac.tuxguitar.gui.actions.effects.ChangeHarmonicNoteAction;
import org.herac.tuxguitar.gui.actions.effects.ChangeHeavyAccentuatedNoteAction;
import org.herac.tuxguitar.gui.actions.effects.ChangePalmMuteAction;
import org.herac.tuxguitar.gui.actions.effects.ChangePoppingAction;
import org.herac.tuxguitar.gui.actions.effects.ChangeSlappingAction;
import org.herac.tuxguitar.gui.actions.effects.ChangeSlideNoteAction;
import org.herac.tuxguitar.gui.actions.effects.ChangeStaccatoAction;
import org.herac.tuxguitar.gui.actions.effects.ChangeTappingAction;
import org.herac.tuxguitar.gui.actions.effects.ChangeTremoloBarAction;
import org.herac.tuxguitar.gui.actions.effects.ChangeTremoloPickingAction;
import org.herac.tuxguitar.gui.actions.effects.ChangeTrillNoteAction;
import org.herac.tuxguitar.gui.actions.effects.ChangeVibratoNoteAction;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.items.MenuItems;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.NoteEffect;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class NoteEffectsMenuItem implements MenuItems{
    private TablatureEditor tablatureEditor;
    private MenuItem noteEffectsMenuItem;
    private Menu menu; 
    private MenuItem vibrato;
    private MenuItem bend;
    private MenuItem tremoloBar;
    private MenuItem deadNote;
    private MenuItem slide;
    private MenuItem hammer;
    
    private MenuItem ghostNote;
    private MenuItem accentuatedNote;
    private MenuItem heavyAccentuatedNote;
    
    private MenuItem harmonicNote;
    private MenuItem graceNote;
    private MenuItem trill;
    private MenuItem tremoloPicking;
    private MenuItem palmMute;
    
    private MenuItem staccato;    
    private MenuItem tapping;
    private MenuItem slapping;
    private MenuItem popping;
    
    private MenuItem fadeIn;
    
    public NoteEffectsMenuItem(Shell shell,Menu parent, int style,TablatureEditor tablatureEditor) {
        this.noteEffectsMenuItem = new MenuItem(parent, style);
        this.tablatureEditor = tablatureEditor;
        this.menu = new Menu(shell, SWT.DROP_DOWN);
    }    
    
    public void showItems(){                        
        //--VIBRATO--
        this.vibrato = new MenuItem(this.menu, SWT.CHECK);        
        this.vibrato.addSelectionListener(TuxGuitar.instance().getAction(ChangeVibratoNoteAction.NAME));

        //--BEND--
        this.bend = new MenuItem(this.menu, SWT.CHECK);        
        this.bend.addSelectionListener(TuxGuitar.instance().getAction(ChangeBendNoteAction.NAME));        

        //--BEND--
        this.tremoloBar = new MenuItem(this.menu, SWT.CHECK);        
        this.tremoloBar.addSelectionListener(TuxGuitar.instance().getAction(ChangeTremoloBarAction.NAME));        
        
        //--SLIDE--
        this.slide = new MenuItem(this.menu, SWT.CHECK);        
        this.slide.addSelectionListener(TuxGuitar.instance().getAction(ChangeSlideNoteAction.NAME));  

        //--SLIDE--
        this.deadNote = new MenuItem(this.menu, SWT.CHECK);        
        this.deadNote.addSelectionListener(TuxGuitar.instance().getAction(ChangeDeadNoteAction.NAME));        
        
        //--HAMMER--
        this.hammer = new MenuItem(this.menu, SWT.CHECK);                           
        this.hammer.addSelectionListener(TuxGuitar.instance().getAction(ChangeHammerNoteAction.NAME));          
        
        //--SEPARATOR--
        new MenuItem(this.menu, SWT.SEPARATOR);     
        
        //--GHOST NOTE--
        this.ghostNote = new MenuItem(this.menu, SWT.CHECK);                           
        this.ghostNote.addSelectionListener(TuxGuitar.instance().getAction(ChangeGhostNoteAction.NAME));        
        
        //--ACCENTUATED NOTE--
        this.accentuatedNote = new MenuItem(this.menu, SWT.CHECK);                           
        this.accentuatedNote.addSelectionListener(TuxGuitar.instance().getAction(ChangeAccentuatedNoteAction.NAME));    
        
        //--HEAVY ACCENTUATED NOTE--
        this.heavyAccentuatedNote = new MenuItem(this.menu, SWT.CHECK);                           
        this.heavyAccentuatedNote.addSelectionListener(TuxGuitar.instance().getAction(ChangeHeavyAccentuatedNoteAction.NAME));            
        
        //--HARMONIC NOTE--
        this.harmonicNote = new MenuItem(this.menu, SWT.CHECK);                           
        this.harmonicNote.addSelectionListener(TuxGuitar.instance().getAction(ChangeHarmonicNoteAction.NAME));           
                
        //--GRACE NOTE--
        this.graceNote = new MenuItem(this.menu, SWT.CHECK);                           
        this.graceNote.addSelectionListener(TuxGuitar.instance().getAction(ChangeGraceNoteAction.NAME));           
        
        
        //--SEPARATOR--
        new MenuItem(this.menu, SWT.SEPARATOR);          
        
        //--TRILL--
        this.trill = new MenuItem(this.menu, SWT.CHECK);                           
        this.trill.addSelectionListener(TuxGuitar.instance().getAction(ChangeTrillNoteAction.NAME));         
                
        //--TREMOLO PICKING--
        this.tremoloPicking = new MenuItem(this.menu, SWT.CHECK);                           
        this.tremoloPicking.addSelectionListener(TuxGuitar.instance().getAction(ChangeTremoloPickingAction.NAME));                        
        
        //--PALM MUTE--
        this.palmMute = new MenuItem(this.menu, SWT.CHECK);
        this.palmMute.addSelectionListener(TuxGuitar.instance().getAction(ChangePalmMuteAction.NAME));           
        
        //--STACCATO
        this.staccato = new MenuItem(this.menu, SWT.CHECK);
        this.staccato.addSelectionListener(TuxGuitar.instance().getAction(ChangeStaccatoAction.NAME));         
        
        
        //--SEPARATOR--
        new MenuItem(this.menu, SWT.SEPARATOR);  
        
        //--TAPPING
        this.tapping = new MenuItem(this.menu, SWT.CHECK);
        this.tapping.addSelectionListener(TuxGuitar.instance().getAction(ChangeTappingAction.NAME));         

        //--SLAPPING
        this.slapping = new MenuItem(this.menu, SWT.CHECK);
        this.slapping.addSelectionListener(TuxGuitar.instance().getAction(ChangeSlappingAction.NAME));        

        //--POPPING
        this.popping = new MenuItem(this.menu, SWT.CHECK);
        this.popping.addSelectionListener(TuxGuitar.instance().getAction(ChangePoppingAction.NAME));        
        
        
        //--SEPARATOR--
        new MenuItem(this.menu, SWT.SEPARATOR);  
        
        //--FADE IN
        this.fadeIn = new MenuItem(this.menu, SWT.CHECK);
        this.fadeIn.addSelectionListener(TuxGuitar.instance().getAction(ChangeFadeInAction.NAME));           
        
        this.noteEffectsMenuItem.setMenu(menu);
        
        this.loadProperties();
    }    
    
    public void update(){    	
    	Note note = tablatureEditor.getTablature().getCaret().getSelectedNote();
    	NoteEffect effect = ((note != null)?note.getEffect():new NoteEffect());
    	
        this.vibrato.setSelection(effect.isVibrato());
        this.bend.setSelection(effect.isBend());
        this.tremoloBar.setSelection(effect.isTremoloBar());
        this.deadNote.setSelection(effect.isDeadNote());
        this.slide.setSelection(effect.isSlide());
        this.hammer.setSelection(effect.isHammer());      
        this.ghostNote.setSelection(effect.isGhostNote());
        this.accentuatedNote.setSelection(effect.isAccentuatedNote());
        this.heavyAccentuatedNote.setSelection(effect.isHeavyAccentuatedNote());
        this.harmonicNote.setSelection(effect.isHarmonic());
        this.graceNote.setSelection(effect.isGrace());
        this.trill.setSelection(effect.isTrill());
        this.tremoloPicking.setSelection(effect.isTremoloPicking());
        this.palmMute.setSelection(effect.isPalmMute());        
        this.staccato.setSelection(effect.isStaccato());
        this.tapping.setSelection(effect.isTapping());
        this.slapping.setSelection(effect.isSlapping());
        this.popping.setSelection(effect.isPopping());
        this.fadeIn.setSelection(effect.isFadeIn());
    }
    
    public void loadProperties(){
        this.noteEffectsMenuItem.setText(TuxGuitar.getProperty("effects"));        
        this.vibrato.setText(TuxGuitar.getProperty("effects.vibrato"));
        this.bend.setText(TuxGuitar.getProperty("effects.bend"));
        this.tremoloBar.setText(TuxGuitar.getProperty("effects.tremolo-bar"));
        this.deadNote.setText(TuxGuitar.getProperty("effects.deadnote"));
        this.slide.setText(TuxGuitar.getProperty("effects.slide"));
        this.hammer.setText(TuxGuitar.getProperty("effects.hammer"));        
        this.ghostNote.setText(TuxGuitar.getProperty("effects.ghostnote"));
        this.accentuatedNote.setText(TuxGuitar.getProperty("effects.accentuatednote"));
        this.heavyAccentuatedNote.setText(TuxGuitar.getProperty("effects.heavyaccentuatednote"));
        this.harmonicNote.setText(TuxGuitar.getProperty("effects.harmonic"));
        this.graceNote.setText(TuxGuitar.getProperty("effects.grace"));
        this.trill.setText(TuxGuitar.getProperty("effects.trill"));
        this.tremoloPicking.setText(TuxGuitar.getProperty("effects.tremolo-picking"));
        this.palmMute.setText(TuxGuitar.getProperty("effects.palm-mute"));        
        this.staccato.setText(TuxGuitar.getProperty("effects.staccato"));
        this.tapping.setText(TuxGuitar.getProperty("effects.tapping"));
        this.slapping.setText(TuxGuitar.getProperty("effects.slapping"));
        this.popping.setText(TuxGuitar.getProperty("effects.popping"));    
        this.fadeIn.setText(TuxGuitar.getProperty("effects.fade-in"));    
    }       
}
