/*
 * Created on 26-nov-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.editors.tab;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.tab.layout.TrackSpacing;
import org.herac.tuxguitar.gui.editors.tab.layout.ViewLayout;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Component;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.NoteEffect;
import org.herac.tuxguitar.song.models.Silence;
/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class MeasureCoords {
	
	public static final int SCORE_KEY_OFFSETS[] = new int[]{30,18,22,24};
	
	private static final int SCORE_NATURAL_POSITIONS[] = new int[]{7,7,6,6,5,4,4,3,3,2,2,1};		
    /**
     * Espacio por defecto de la clave
     */
    public static final int DEFAULT_CLEF_SPAN = 40;        
    /**
     * Espacio por defecto entre negra y negra
     */
    public static final int DEFAULT_QUARTER_SPAN = 30;
    
    /**
     * Widget de la tablatura
     */    
    private Tablature tablature;
    /**
     * Cabecera
     */        
    private MeasureHeaderGui header;    
    /**
     * Posicion X
     */
    private int posX;
    /** 
     * Posicion Y
     */
    private int posY;
    /**
     * Espacio entre negras
     */
    private int quarterSpan;
    /**
     * Espacio entre pulsos
     */        
    private long beatLength;    
    /**
     * Boolean para saber si hay que pintar la clave
     */
    private boolean paintClef = true;
    /**
     * Boolean para saber si hay que pintar el KeySignature
     */
    private boolean paintKeySignature = true;            
    /**
     * Coordenadas de notas
     */
    private List measureComponents;
    /**
     * Compas de Referencia
     */
    private Measure measure;
    /**
     * Compas anterior
     */
    private Measure prevMeasure;    
    /**
     * Pista de Referencia
     */
    private SongTrackCoords trackCoords;
    /**
     * Tema de Referencia
     */
    private SongManager songManager;    
    /**
     * Boolean para saber si el compas esta en el area de pantalla
     */
    private boolean outOfBounds;
    /**
     * Boolean para saber si el compas es el primero de la linea
     */    
    private boolean firstOfLine;
    
    private Rectangle clefSrcBounds;
    
    private Rectangle clefDstBounds;
    
    private int span;
       
    private TrackSpacing ts;
           
    private int maxY;
    
    private int minY;
    
    private List timeHelpers;    
    private List beatPositions;
    private CacheImage cache; 
    private boolean cacheEnabled;
    
    private int lastEffectSpan;    
    
    private int lyricBeatIndex;
    
    private boolean accentuated;
	private boolean harmonic;
	private boolean tapping;
	private boolean palmMute;
	private boolean vibrato;
	private boolean tupleto;
	private boolean fadeIn;
	
    public MeasureCoords(SongManager songManager,Tablature tablature,MeasureHeaderGui header,Measure measure, SongTrackCoords trackCoords) {
        this.measure = measure;
        this.header = header;
        this.trackCoords = trackCoords;
        this.tablature = tablature;
        this.songManager = songManager;
        this.measureComponents = new ArrayList();
        this.beatPositions = new ArrayList();   
        this.timeHelpers = new ArrayList();
        this.cache = new CacheImage(tablature.getDisplay());
    }

    
    /**
     * Crea los valores necesarios
     */
    public void create(ViewLayout layout) {        
        this.measureComponents.clear();
        this.beatLength =  TablatureUtil.getBeatLength(getMeasure().getTimeSignature());
        autoCompleteSilences();        
        calculateQuarterSpan(layout);
        calculateMeasureChanges(layout);
        this.header.notifyQuarterSpan(getQuarterSpan());
    }    
    
    
    /**
     * Actualiza los valores para dibujar
     */
    public void update(ViewLayout layout) {
    	this.setQuarterSpan(this.header.getMaxQuarterSpan());
    	resetEffects();
    	orderNotes();
        calculateClefBounds(layout);
        calcuateComponents(layout);        
        updateComponents(layout);        
        orderComponents();        
        setOutOfBounds(true);
        setCacheEnabled(false);                
    }

    /**
     * Calcula el espacio que debe haber entre negras
     */
    private void calculateQuarterSpan(ViewLayout layout) {        
        if (measure.getNotes().isEmpty() && measure.getSilences().isEmpty()) {
            this.quarterSpan = DEFAULT_QUARTER_SPAN;
        } else {
            Duration minDuration = null;
            if(!measure.getNotes().isEmpty()){
                Note minNote = null;
                for (int noteIdx = 0; noteIdx < measure.getNotes().size(); noteIdx++) {
                    Note currentNote = (Note) measure.getNotes().get(noteIdx);

                    if (minNote == null || currentNote.getDuration().getTime() <= minNote.getDuration().getTime()) {
                        minNote = currentNote;
                    }
                }
                minDuration = minNote.getDuration();
            }
            if(!measure.getSilences().isEmpty()){
                Silence minSilence = null;
                for (int silenceIdx = 0; silenceIdx < measure.getSilences().size(); silenceIdx++) {
                    Silence currentSilence = (Silence) measure.getSilences().get(silenceIdx);

                    if (minSilence == null || currentSilence.getDuration().getTime() <= minSilence.getDuration().getTime()) {
                        minSilence = currentSilence;
                    }
                }            
                
                if(minDuration == null || minSilence.getDuration().getTime() <= minDuration.getTime()){
                    minDuration = minSilence.getDuration();
                }
            }
            this.quarterSpan = layout.getSpanForQuarter(minDuration);
        }
    }

    
    /**
     * Calcula si debe pintar el TimeSignature
     */
    
    public void calculateMeasureChanges(ViewLayout layout) {
    	this.paintClef = false;
    	this.paintKeySignature = false;
    	 if(layout.isScoreEnabled()){            	    	
    		 MeasureCoords prevMeasureCoords = null;
    		 if(!layout.isFirstMeasure(getMeasure())){
    			 prevMeasureCoords = this.trackCoords.getPrevMeasure(this);
    			 if(prevMeasureCoords != null){
    				 this.prevMeasure = prevMeasureCoords.getMeasure(); 
    			 }
    		 }
    		 if(this.prevMeasure == null || getMeasure().getClef() != this.prevMeasure.getClef()){        	
            	this.paintClef = true;           	
            	this.header.notifyClefSpan(DEFAULT_CLEF_SPAN);
           
    		 }
    		 if(this.prevMeasure == null || getMeasure().getKeySignature() != this.prevMeasure.getKeySignature()){        	
             	this.paintKeySignature = true;
             	this.header.notifyKeySignatureSpan(calculateKeySignatureSpan());            
     		 }    		 
    	 }
    }

    private void calculateClefBounds(ViewLayout layout){
    	if(this.paintClef){
    		if(measure.getClef() == Measure.CLEF_TREBLE){   
    			clefSrcBounds = SystemImages.CLEF_TREBLE.getBounds();
    		}else if(measure.getClef() == Measure.CLEF_BASS){ 
    			clefSrcBounds = SystemImages.CLEF_BASS.getBounds();
    		}else if(measure.getClef() == Measure.CLEF_TENOR){ 
    			clefSrcBounds = SystemImages.CLEF_TENOR.getBounds();
    		}else if(measure.getClef() == Measure.CLEF_ALTO){ 
    			clefSrcBounds = SystemImages.CLEF_ALTO.getBounds();
    		}            		
    		clefDstBounds = new Rectangle(clefSrcBounds.x,clefSrcBounds.y,clefSrcBounds.width,(layout.getScoreLineSpan() * clefSrcBounds.height / 10));
    	}
    }
    
    /**
     * Calcula las coordenadas de los componentes
     */    
    private void calcuateComponents(ViewLayout layout){
        this.measureComponents.clear();
        calculateComponentsCoords(layout);
    }
    
    /**
     * Calcula las coordenadas de las notas y silencios
     */
    private void calculateComponentsCoords(ViewLayout layout) {
        int posX = 0;
        int posY = 0;        
        int span = header.getFirstNoteSpan();
        //---------------------------------Notas-------------------------------------
        for (int noteIdx = 0; noteIdx < measure.getNotes().size(); noteIdx++) {
            Note note = (Note) measure.getNotes().get(noteIdx);
            posY = ((note.getString() * layout.getStringSpan()) - layout.getStringSpan());
            posX = (TablatureUtil.getStartPosition(measure, note.getStart(), this.quarterSpan) + 10);
            measureComponents.add(new NoteCoords(this.tablature,this.trackCoords,this, note, posX + span, posY));
        }
        //---------------------------------Silencios---------------------------------
        for (int silenceIdx = 0; silenceIdx < measure.getSilences().size(); silenceIdx++) {
            Silence silence = (Silence) measure.getSilences().get(silenceIdx);
            posX = TablatureUtil.getStartPosition(measure, silence.getStart(), this.quarterSpan) + 10;                        
            measureComponents.add(new SilenceCoords(this.tablature,this,silence,posX + span));
        }        
    }

    /**
     * Calcula si hay espacios libres. y crea nuevos silencios
     */   
    private void autoCompleteSilences(){   
    	songManager.getMeasureManager().autoCompleteSilences(measure);
    }    
    
    /**
     * Llama a update de todas las notas del compas
     */
    private void updateComponents(ViewLayout layout) {
    	this.beatPositions.clear();
    	this.timeHelpers.clear();
    	this.maxY = 0;
    	this.minY = 0;//100;    	
    	MeasureTimeHelper timeHelper = null;
    	BeatPosition beat = null;
    	NoteCoords prevNote = null;
    	
        Iterator components = measureComponents.iterator();
        while (components.hasNext()) {
            MeasureComponent component = (MeasureComponent) components.next();            
            if(component instanceof NoteCoords){
            	NoteCoords note = (NoteCoords)component; 
            	
            	if(prevNote == null || !areInSameBeat(prevNote,component)){
            		timeHelper = new MeasureTimeHelper();   
            		timeHelpers.add(timeHelper);
            	}       
            	if(prevNote == null || component.getStart() != prevNote.getStart()){
            		beat = new BeatPosition(note.getStart(),note.getDuration(),note.getPosX()); 
            		beatPositions.add(beat);
                }
            	checkEffects(layout,note.getNote().getEffect());
            	beat.checkValues(note);            	
            	timeHelper.check(note,getMeasure().getClef());
            	note.setMeasureTimeHelper(timeHelper);
            	prevNote = note;
            }
        	if(!component.getDuration().getTupleto().isEqual(Duration.NO_TUPLETO)){
        		this.tupleto = true;
        	}        	
            component.update(layout);
        }
        
        if(ViewLayout.AUTO_SPACING_ENABLED){        
        	Iterator beats = timeHelpers.iterator();    
        	while (beats.hasNext()) {
        		MeasureTimeHelper helper = (MeasureTimeHelper)beats.next();
        		checkValue(helper.getMinNote(),helper.getDirection());
        		checkValue(helper.getMaxNote(),helper.getDirection());
        	}            	
        }
    }

    private void checkValue(NoteCoords note,int direction){ 
    	int y = note.getScorePosY();

    	if(direction == MeasureTimeHelper.DIRECTION_UP && y > this.maxY ){
    		this.maxY = y;    			
    	}else if(direction == MeasureTimeHelper.DIRECTION_DOWN && (y + MeasureTimeHelper.DOWN_OFFSET) > this.maxY ){
    		this.maxY = (y + MeasureTimeHelper.DOWN_OFFSET + 2);  
    	}

    	if(direction == MeasureTimeHelper.DIRECTION_UP && (y - MeasureTimeHelper.UP_OFFSET) < this.minY ){
    		this.minY = (y - MeasureTimeHelper.UP_OFFSET - 2);
    	}else if(direction == MeasureTimeHelper.DIRECTION_DOWN && y < this.minY ){
    		this.minY = y;
    	}
    }
    
    private void checkEffects(ViewLayout layout,NoteEffect effect){
    	if(effect.isAccentuatedNote() || effect.isHeavyAccentuatedNote()){
    		this.accentuated = true;
    	}
    	if(effect.isHarmonic() && !layout.isScoreEnabled()){
    		this.harmonic = true;
    	}
    	if(effect.isTapping() || effect.isSlapping() || effect.isPopping()){
    		this.tapping = true;
    	}
    	if(effect.isPalmMute()){
    		this.palmMute = true;
    	}
    	if(effect.isFadeIn()){
    		this.fadeIn = true;
    	}      	
    	if(effect.isVibrato() || effect.isTrill()){
    		this.vibrato = true;
    	}    	  	
    }
    
    private void resetEffects(){
    	this.tupleto = false;
    	this.accentuated = false;    
    	this.harmonic = false;    
    	this.tapping = false;    	
    	this.palmMute = false;      
    	this.fadeIn = false;
    	this.vibrato = false;
    }    
    
    public void registerEffects(TrackSpacing ts){
    	if(this.tupleto){
    		ts.setSize(TrackSpacing.POSITION_TUPLETO,10);
    	}    	
    	if(this.accentuated){
    		ts.setSize(TrackSpacing.POSITION_ACCENTUATED_EFFECT,ViewLayout.DEFAULT_EFFECT_SPAN);
    	}
    	if(this.harmonic){
    		ts.setSize(TrackSpacing.POSITION_HARMONIC_EFFEC,ViewLayout.DEFAULT_EFFECT_SPAN);
    	} 
    	if(this.tapping){
    		ts.setSize(TrackSpacing.POSITION_TAPPING_EFFEC,ViewLayout.DEFAULT_EFFECT_SPAN);
    	}     	
    	if(this.palmMute){
    		ts.setSize(TrackSpacing.POSITION_PALM_MUTE_EFFEC,ViewLayout.DEFAULT_EFFECT_SPAN);
    	}     	
    	if(this.fadeIn){
    		ts.setSize(TrackSpacing.POSITION_FADE_IN,ViewLayout.DEFAULT_EFFECT_SPAN);
    	}    	    	
    	if(this.vibrato){
    		ts.setSize(TrackSpacing.POSITION_VIBRATO_EFFEC,ViewLayout.DEFAULT_EFFECT_SPAN);
    	}    	
    }        

    private void orderNotes(){
    	songManager.getMeasureManager().orderNotes(measure);
    }
       
    private void orderComponents(){
        for(int i = 0;i < measureComponents.size();i++){
            MeasureComponent minComponent = null;
            for(int j = i;j < measureComponents.size();j++){
                MeasureComponent component = (MeasureComponent)measureComponents.get(j);
                if(minComponent == null || component.getStart() < minComponent.getStart()){
                    minComponent = component;
                }
            }
            measureComponents.remove(minComponent);
            measureComponents.add(i,minComponent);
        }
    }    

    public void paintMeasure(ViewLayout layout,GC eventGC,Rectangle clientArea) {                
        setOutOfBounds(false);
        if(shouldRepaint()){        	
        	cache.setSize(getWidth() + getSpan(),getTs().getSize());
        	GC gc = cache.getGC();

        	layout.setDefaultStyle(gc);
        	layout.paintLines(trackCoords,getTs(),gc,0,0, getWidth() + getSpan());

        	paintTimeSignature(layout,gc);        	
        	paintClef(layout,gc);
        	paintKeySignature(layout,gc);
        	paintComponents(layout,gc,clientArea);      
        	
        	setCacheEnabled(true);
        }        
        this.cache.paintImage(eventGC,getPosX(),getPosY());
        
    	layout.setDefaultStyle(eventGC);
    	eventGC.setForeground(tablature.getDisplay().getSystemColor(SWT.COLOR_BLACK));
    	
        this.paintTempo(layout,eventGC);
        this.paintTripletFeel(layout,eventGC);        	
        this.paintDivisions(layout,eventGC);        
        this.paintPlayMode(layout,eventGC);     
    }
    
    private boolean shouldRepaint(){    	
    	return (isDisposed() || !isCacheEnabled());
    }


    /**
     * Pinta las notas
     */
    public void paintComponents(ViewLayout layout,GC gc,Rectangle clientArea) {
    	long prevStart = 0;
    	    	    	
    	if(layout.isScoreEnabled()){
    		for(int i = 0; i < beatPositions.size(); i++){
    			BeatPosition beat = (BeatPosition)beatPositions.get(i);
    			beat.paintExtraLines(gc, layout);
    		}
    	}    	
    	for (int i = 0; i < measureComponents.size(); i++) {
            MeasureComponent component = (MeasureComponent) measureComponents.get(i);                        
            component.paint(layout,gc,MeasureHeaderGui.DEFAULT_LEFT_SPAN ,0);       
        }

    }
    

    /**
     * Pinta las divisiones del compas
     */
    private void paintDivisions(ViewLayout layout,GC gc) {    	    	
    	//-----SCORE ------------------------------------//
    	if(layout.isScoreEnabled()){    		
        	int scoreY1 = getPosY() + getTs().getPosition(TrackSpacing.POSITION_SCORE_MIDDLE_LINES);    
            int scoreY2 = scoreY1 + (layout.getScoreLineSpan() * 4);    
            int offsetY = scoreY2;
            if(layout.isTablatureEnabled() && (layout.isFirstMeasure(getMeasure()) || isFirstOfLine())){
            	offsetY = getPosY() + ts.getPosition(TrackSpacing.POSITION_TABLATURE);
            }
            
            //numero de compas
            String number = Integer.toString(measure.getNumber());
            gc.setForeground(tablature.getDisplay().getSystemColor(SWT.COLOR_RED));
            gc.drawString(number,getPosX() + 1,scoreY1 - (gc.stringExtent(number).y));
            gc.setForeground(tablature.getDisplay().getSystemColor(SWT.COLOR_BLACK));
            
            //principio
            if(measure.isRepeatStart()){
                gc.setLineWidth(3);
                gc.drawLine(getPosX(), scoreY1, getPosX(), offsetY + 1);
                
                gc.drawOval(getPosX() + 7, scoreY1 + ((scoreY2 - scoreY1) / 2) - 7,1,2);
                gc.drawOval(getPosX() + 7, scoreY1 + ((scoreY2 - scoreY1) / 2) + 7,1,2);
                
                gc.setLineWidth(1);
                gc.drawLine(getPosX() + 3, scoreY1, getPosX() + 3, offsetY);
            }else if(layout.isFirstMeasure(getMeasure())){
                gc.setLineWidth(3);
                gc.drawLine(getPosX(), scoreY1, getPosX(), offsetY + 1);                
                gc.setLineWidth(1);
                gc.drawLine(getPosX() + 3, scoreY1, getPosX() + 3, offsetY);            	            
        	}else{
                gc.drawLine(getPosX(), scoreY1, getPosX(), offsetY);                
            }
            
            //fin
            if(measure.getNumberOfRepetitions() > 0){            
                gc.setLineWidth(3);
                gc.drawLine(getPosX() + getWidth() - 1 + getSpan(), scoreY1, getPosX() + getWidth() - 1 + getSpan(), scoreY2 + 1);            

                gc.drawOval(getPosX() + getWidth() -9 + getSpan(), scoreY1 + ((scoreY2 - scoreY1) / 2) - 7,1,2);
                gc.drawOval(getPosX() + getWidth() -9 + getSpan(), scoreY1 + ((scoreY2 - scoreY1) / 2) + 7,1,2);
                
                gc.setLineWidth(1);            
                gc.drawLine(getPosX() + getWidth() - 4 + getSpan(), scoreY1, getPosX() + getWidth() - 4 + getSpan(), scoreY2);
                
                String repetitions = "x" + Integer.toString(measure.getNumberOfRepetitions());
                gc.drawString(repetitions,getPosX() + getWidth() - gc.stringExtent(repetitions).x + getSpan(),scoreY1 - gc.stringExtent(repetitions).y);
            }else if(layout.isLastMeasure(getMeasure())){
                gc.setLineWidth(3);
                gc.drawLine(getPosX() + getWidth() + getSpan(), scoreY1, getPosX() + getWidth() + getSpan(), scoreY2 + 1);            
                gc.setLineWidth(1);            
                gc.drawLine(getPosX() + getWidth() - 3 + getSpan(), scoreY1, getPosX() + getWidth() - 3 + getSpan(), scoreY2);      
        	}else{        
                gc.drawLine(getPosX() + getWidth() + getSpan(), scoreY1, getPosX() + getWidth() + getSpan(), scoreY2);                
            }    		    		
    		
    	}       
    	
    	
    	//-----TABLATURE ------------------------------------//
    	if(layout.isTablatureEnabled()){    		    	    		
    		int y1 = getPosY() + ts.getPosition(TrackSpacing.POSITION_TABLATURE);
    		int y2 = y1 + ((trackCoords.getTrack().getStrings().size() - 1 ) * layout.getStringSpan());
                
    		//numero de compas
    		if(!layout.isScoreEnabled()){
    			String number = Integer.toString(measure.getNumber());
    			gc.setForeground(tablature.getDisplay().getSystemColor(SWT.COLOR_RED));
    			gc.drawString(number,getPosX() + 1,y1 - (gc.stringExtent(number).y));
    			gc.setForeground(tablature.getDisplay().getSystemColor(SWT.COLOR_BLACK));
    		}
        
    		//principio
    		if(measure.isRepeatStart()){
    			gc.setLineWidth(3);
    			gc.drawLine(getPosX(), y1, getPosX(), y2 + 1);
            
    			gc.drawOval(getPosX() + 7, y1 + ((y2 - y1) / 2) - 7,1,2);
    			gc.drawOval(getPosX() + 7, y1 + ((y2 - y1) / 2) + 7,1,2);
            
    			gc.setLineWidth(1);
    			gc.drawLine(getPosX() + 3, y1, getPosX() + 3, y2);
    		}else if(layout.isFirstMeasure(getMeasure())){
    			gc.setLineWidth(3);
    			gc.drawLine(getPosX(), y1, getPosX(), y2 + 1);    
    			gc.setLineWidth(1);
    			gc.drawLine(getPosX() + 3, y1, getPosX() + 3, y2);            
    		}else{
    			gc.drawLine(getPosX(), y1, getPosX(), y2);
    		}
        
    		//fin
    		if(measure.getNumberOfRepetitions() > 0){            
    			gc.setLineWidth(3);
    			gc.drawLine(getPosX() + getWidth() - 1 + getSpan(), y1, getPosX() + getWidth() - 1 + getSpan(), y2 + 1);            

    			gc.drawOval(getPosX() + getWidth() -9 + getSpan(), y1 + ((y2 - y1) / 2) - 7,1,2);
    			gc.drawOval(getPosX() + getWidth() -9 + getSpan(), y1 + ((y2 - y1) / 2) + 7,1,2);
            
    			gc.setLineWidth(1);            
    			gc.drawLine(getPosX() + getWidth() - 4 + getSpan(), y1, getPosX() + getWidth() - 4 + getSpan(), y2);
            
    			if(!layout.isScoreEnabled()){
    				String repetitions = "x" + Integer.toString(measure.getNumberOfRepetitions());
    				gc.drawString(repetitions,getPosX() + getWidth() - gc.stringExtent(repetitions).x + getSpan(),y1 - gc.stringExtent(repetitions).y);
    			}
    		}else if(layout.isLastMeasure(getMeasure())){
    			gc.setLineWidth(3);
    			gc.drawLine(getPosX() + getWidth() + getSpan(), y1, getPosX() + getWidth() + getSpan(), y2 + 1);            
    			gc.setLineWidth(1);            
    			gc.drawLine(getPosX() + getWidth() - 3 + getSpan(), y1, getPosX() + getWidth() - 3 + getSpan(), y2);      
    		}else{        
    			gc.drawLine(getPosX() + getWidth() + getSpan(), y1, getPosX() + getWidth() + getSpan(), y2);
    		}
        
    	}
        
    }

    
    /**
     * Pinta la Clave
     */
    private void paintClef(ViewLayout layout,GC gc) {    	    	
    	//-----SCORE ------------------------------------//
    	if(layout.isScoreEnabled() && this.paintClef){
    		int x = 14;
    		int y = getTs().getPosition(TrackSpacing.POSITION_SCORE_MIDDLE_LINES);
        	if(measure.getClef() == Measure.CLEF_TREBLE){        		
        		gc.drawImage(SystemImages.CLEF_TREBLE,0,0,clefSrcBounds.width,clefSrcBounds.height,x,y - 8,clefDstBounds.width,clefDstBounds.height);
        	}
        	else if(measure.getClef() == Measure.CLEF_BASS){        		
        		gc.drawImage(SystemImages.CLEF_BASS,0,0,clefSrcBounds.width,clefSrcBounds.height,x,y - 2,clefDstBounds.width,clefDstBounds.height);
        	}
        	else if(measure.getClef() == Measure.CLEF_TENOR){   
        		gc.drawImage(SystemImages.CLEF_TENOR,0,0,clefSrcBounds.width,clefSrcBounds.height,x,y - 9,clefDstBounds.width,clefDstBounds.height);
        	}        	
        	else if(measure.getClef() == Measure.CLEF_ALTO){
        		gc.drawImage(SystemImages.CLEF_ALTO,0,0,clefSrcBounds.width,clefSrcBounds.height,x,y - 1,clefDstBounds.width,clefDstBounds.height);   
        	}
    	}               
    }
    
    /**
     * Pinta la Armadura de Clave
     */
    private void paintKeySignature(ViewLayout layout,GC gc) {    	    	
    	if(layout.isScoreEnabled() && this.paintKeySignature){        	
    		int x = header.getClefSpan() + 10;
    		int y = getTs().getPosition(TrackSpacing.POSITION_SCORE_MIDDLE_LINES);
    		double scale = (layout.getScoreLineSpan() / 2);    		    		    		
    		double minY = y - scale;
    		
    		double clefOffset = 0;
    		switch(measure.getClef()){
    		case Measure.CLEF_TREBLE:
    			clefOffset = 0;
    			break;
    		case Measure.CLEF_BASS:
    			clefOffset = 2;
    			break;
    		case Measure.CLEF_TENOR:
    			clefOffset = -1;
    			break;
    		case Measure.CLEF_ALTO:
    			clefOffset = 1;
    			break;    			
    		}
    		
			//SHARPS
    		if(measure.getKeySignature() >= 1 && measure.getKeySignature() <= 7){
    			//F
    			x += 6;
    			paintKeySignatureImage(gc,SystemImages.KEY_SHARP,x,y,scale,1 + (int)clefOffset,minY,6);
    		}else if(prevMeasure != null && prevMeasure.getKeySignature() >= 1 && prevMeasure.getKeySignature() <=7){
    			//F
    			x += 6;
    			paintKeySignatureImage(gc,SystemImages.KEY_NATURAL,x,y,scale,1 + (int)clefOffset,minY,9);    				
    		}
    			
    		if(measure.getKeySignature() >= 2 && measure.getKeySignature() <= 7){
    			//C
    			x += 6;
    			paintKeySignatureImage(gc,SystemImages.KEY_SHARP,x,y,scale,4 + (int)clefOffset,minY,6);
    		}else if(prevMeasure != null && prevMeasure.getKeySignature() >= 2 && prevMeasure.getKeySignature() <=7){
    			//C
    			x += 6;
    			paintKeySignatureImage(gc,SystemImages.KEY_NATURAL,x,y,scale,4 + (int)clefOffset,minY,9);
    		}  
    			
    		if(measure.getKeySignature() >= 3 && measure.getKeySignature() <= 7){
    			//G
    			x += 6;
    			paintKeySignatureImage(gc,SystemImages.KEY_SHARP,x,y,scale,0 + (int)clefOffset,minY,6);
    		}else if(prevMeasure != null && prevMeasure.getKeySignature() >= 3 && prevMeasure.getKeySignature() <=7){
    			//G
    			x += 6;
    			paintKeySignatureImage(gc,SystemImages.KEY_NATURAL,x,y,scale,0 + (int)clefOffset,minY,9);    				
    		}    
    			
    		if(measure.getKeySignature() >= 4 && measure.getKeySignature() <= 7){
    			//D
    			x += 6;
    			paintKeySignatureImage(gc,SystemImages.KEY_SHARP,x,y,scale,3 + (int)clefOffset,minY,6);
    		}else if(prevMeasure != null && prevMeasure.getKeySignature() >= 4 && prevMeasure.getKeySignature() <=7){
    			//D
    			x += 6;
    			paintKeySignatureImage(gc,SystemImages.KEY_NATURAL,x,y,scale,3 + (int)clefOffset,minY,9);    							
    		}  
    			
    		if(measure.getKeySignature() >= 5 && measure.getKeySignature() <= 7){
    			//A
    			x += 6;
    			paintKeySignatureImage(gc,SystemImages.KEY_SHARP,x,y,scale,6 + (int)clefOffset,minY,6);    				
    		}else if(prevMeasure != null && prevMeasure.getKeySignature() >= 5 && prevMeasure.getKeySignature() <=7){
    			//A
    			x += 6;
    			paintKeySignatureImage(gc,SystemImages.KEY_NATURAL,x,y,scale,6 + (int)clefOffset,minY,9);       							
    		}  
    			
    		if(measure.getKeySignature() >= 6 && measure.getKeySignature() <= 7){
    			//E
    			x += 6;
    			paintKeySignatureImage(gc,SystemImages.KEY_SHARP,x,y,scale,2 + (int)clefOffset,minY,6);     					
    		}else if(prevMeasure != null && prevMeasure.getKeySignature() >= 6 && prevMeasure.getKeySignature() <=7){
    			//E
    			x += 6;
    			paintKeySignatureImage(gc,SystemImages.KEY_NATURAL,x,y,scale,2 + (int)clefOffset,minY,9); 			
    		}  
    			
    		if(measure.getKeySignature() >= 7 && measure.getKeySignature() <= 7){
    			//B
    			x += 6;
    			paintKeySignatureImage(gc,SystemImages.KEY_SHARP,x,y,scale,5 + (int)clefOffset,minY,6);    	
    		}else if(prevMeasure != null && prevMeasure.getKeySignature() >= 7 && prevMeasure.getKeySignature() <=7){
    			//B
    			x += 6;
    			paintKeySignatureImage(gc,SystemImages.KEY_NATURAL,x,y,scale,5 + (int)clefOffset,minY,9);        						
    		}    	
    			
    		//FLATS
    		if(measure.getKeySignature() >= 1 + 7){
    			//B
    			x += 6;
    			paintKeySignatureImage(gc,SystemImages.KEY_FLAT,x,y,scale,5 + (int)clefOffset,minY,6);    	
    		}else if(prevMeasure != null && prevMeasure.getKeySignature() >= 1 + 7){
    			//B
    			x += 6;
    			paintKeySignatureImage(gc,SystemImages.KEY_NATURAL,x,y,scale,5 + (int)clefOffset,minY,9); 				
    		}    	
    			
    		if(measure.getKeySignature() >= 2 + 7){
    			//E
    			x += 6;
    			paintKeySignatureImage(gc,SystemImages.KEY_FLAT,x,y,scale,2 + (int)clefOffset,minY,6);    
    		}else if(prevMeasure != null && prevMeasure.getKeySignature() >= 2 + 7){
    			//E
    			x += 6;
    			paintKeySignatureImage(gc,SystemImages.KEY_NATURAL,x,y,scale,2 + (int)clefOffset,minY,9); 				
    		}       
    			
    		if(measure.getKeySignature() >= 3 + 7){
    			//A
    			x += 6;
    			paintKeySignatureImage(gc,SystemImages.KEY_FLAT,x,y,scale,6 + (int)clefOffset,minY,6);       				
    		}else if(prevMeasure != null && prevMeasure.getKeySignature() >= 3 + 7){
    			//A
    			x += 6;
    			paintKeySignatureImage(gc,SystemImages.KEY_NATURAL,x,y,scale,6 + (int)clefOffset,minY,9);      				
    		}   
    			
    		if(measure.getKeySignature() >= 4 + 7){
    			//D
    			x += 6;
    			paintKeySignatureImage(gc,SystemImages.KEY_FLAT,x,y,scale,3 + (int)clefOffset,minY,6);
    		}else if(prevMeasure != null && prevMeasure.getKeySignature() >= 4 + 7){
    			//D
    			x += 6;
    			paintKeySignatureImage(gc,SystemImages.KEY_NATURAL,x,y,scale,3 + (int)clefOffset,minY,9);     												
    		}    			
    			
    		if(measure.getKeySignature() >= 5 + 7){
    			//G
    			x += 6;
    			paintKeySignatureImage(gc,SystemImages.KEY_FLAT,x,y,scale,0 + (int)clefOffset,minY,6);    	
    		}else if(prevMeasure != null && prevMeasure.getKeySignature() >= 5 + 7){
    			//G
    			x += 6;
    			paintKeySignatureImage(gc,SystemImages.KEY_NATURAL,x,y,scale,0 + (int)clefOffset,minY,9);    														
    		}
    			
    		if(measure.getKeySignature() >= 6 + 7){
    			//C
    			x += 6;
    			paintKeySignatureImage(gc,SystemImages.KEY_FLAT,x,y,scale,4 + (int)clefOffset,minY,6);
    		}else if(prevMeasure != null && prevMeasure.getKeySignature() >= 6 + 7){
    			//C
    			x += 6;
    			paintKeySignatureImage(gc,SystemImages.KEY_NATURAL,x,y,scale,4 + (int)clefOffset,minY,9);    																
    		}
    			
    		if(measure.getKeySignature() >= 7 + 7){
    			//F
    			x += 6;
    			paintKeySignatureImage(gc,SystemImages.KEY_FLAT,x,y,scale,1 + (int)clefOffset,minY,6);       				
    		}else if(prevMeasure != null && prevMeasure.getKeySignature() >= 7 + 7){
    			//F
    			x += 6;
    			paintKeySignatureImage(gc,SystemImages.KEY_NATURAL,x,y,scale,1 + (int)clefOffset,minY,9);    														
    		}    		    			

    	}               
    }    
    
    private void paintKeySignatureImage(GC gc,Image image,int x,int y,double scale,int position,double minY,int center){
    	int scoreLineY = (int)(y + ((scale * position) - scale) - center);
    	scoreLineY =(int) ((position < 0)?(scoreLineY + (scale * 7)):scoreLineY);    	
		gc.drawImage(image,x,(int)scoreLineY);    	
    }
    
    private void paintTimeSignature(ViewLayout layout,GC gc){    	        	
    	if(this.header.shouldPaintTimeSignature()){
        	layout.setTimeSignatureStyle(gc);
        	gc.setForeground(tablature.getDisplay().getSystemColor(SWT.COLOR_BLACK));

        	int x = (header.getClefSpan() + header.getKeySignatureSpan() + MeasureHeaderGui.DEFAULT_LEFT_SPAN + 10);        	
    		String numerator = Integer.toString(getMeasure().getTimeSignature().getNumerator());
    		String denominator = Integer.toString(getMeasure().getTimeSignature().getDenominator().getValue());        	        	
        	if(layout.isScoreEnabled()){            	            	
        		int y = getTs().getPosition(TrackSpacing.POSITION_SCORE_MIDDLE_LINES);
        		int y1 = (y - 3);
            	int y2 = ((y + (layout.getScoreLineSpan() * 4)) - gc.stringExtent(denominator).y) + 3;            	
            	gc.drawString(numerator,x,y1,true);
            	gc.drawString(denominator,x,y2,true);     
        	}else if(layout.isTablatureEnabled()){
            	int y = getTs().getPosition(TrackSpacing.POSITION_TABLATURE);
            	int move = (8 - trackCoords.getTrack().stringCount());
            	int y1 = (y - move);
            	int y2 = ((y  + trackCoords.getTabHeight()) - gc.stringExtent(denominator).y) + move;            	
            	gc.drawString(numerator,x,y1,true);
            	gc.drawString(denominator,x,y2,true);         		
        	}
        	layout.setDefaultStyle(gc);
        }
    }
    
    
    private void paintTempo(ViewLayout layout,GC gc){
    	if(this.header.shouldPaintTempo()){
            int x = (getPosX() + 15);
            int y = (getPosY() - SystemImages.TEMPO_IMAGE.getBounds().height);
            if(layout.isScoreEnabled()){
            	y += getTs().getPosition(TrackSpacing.POSITION_SCORE_MIDDLE_LINES);	
            }else if(layout.isTablatureEnabled()){
            	y += getTs().getPosition(TrackSpacing.POSITION_TABLATURE);
            }                     
            gc.setForeground(tablature.getDisplay().getSystemColor(SWT.COLOR_BLACK));
            gc.drawImage(SystemImages.TEMPO_IMAGE,x - 5,y - 10);
            gc.drawString(" = " + getMeasure().getTempo().getValue(),x + 10,y);
        }
    }
    
    private void paintTripletFeel(ViewLayout layout,GC gc){
    	if(this.header.shouldPaintTripletFeel()){
            int x = (getPosX() + header.getTempoSpan());
            int y = (getPosY() - SystemImages.TEMPO_IMAGE.getBounds().height);
            if(layout.isScoreEnabled()){
            	y += getTs().getPosition(TrackSpacing.POSITION_SCORE_MIDDLE_LINES);	
            }else if(layout.isTablatureEnabled()){
            	y += getTs().getPosition(TrackSpacing.POSITION_TABLATURE);
            }                 
            gc.drawImage(SystemImages.getTripletFeel(getMeasure().getTripletFeel()),x + 10,y - 13);
        }
    }
    
    private void paintPlayMode(ViewLayout layout,GC gc){
        if(layout.isPlayModeEnabled() && isPlaying()){
        	int width = getWidth() + getSpan();
        	int height = 100;
        	
            int y1 = getPosY();
            int y2 = getPosY();
            if(layout.isScoreEnabled() && layout.isTablatureEnabled()){
            	y1 += (getTs().getPosition(TrackSpacing.POSITION_SCORE_MIDDLE_LINES) - layout.getScoreLineSpan());
            	y2 += (getTs().getPosition(TrackSpacing.POSITION_TABLATURE) + trackCoords.getTabHeight() + layout.getStringSpan());
            }else if(layout.isScoreEnabled() && !layout.isTablatureEnabled()){
            	y1 += (getTs().getPosition(TrackSpacing.POSITION_SCORE_MIDDLE_LINES) - layout.getScoreLineSpan());
            	y2 += (getTs().getPosition(TrackSpacing.POSITION_SCORE_MIDDLE_LINES) + (layout.getStringSpan() * 5));
            } else if(!layout.isScoreEnabled() && layout.isTablatureEnabled()){
            	y1 += (getTs().getPosition(TrackSpacing.POSITION_TABLATURE) - layout.getStringSpan());
            	y2 += (getTs().getPosition(TrackSpacing.POSITION_TABLATURE) + trackCoords.getTabHeight() + layout.getStringSpan());
            }          	        	
        	gc.setLineWidth(1);
        	gc.setLineStyle(SWT.LINE_DASH);
        	gc.drawRectangle(getPosX() + 5,y1,width - 10,(y2 - y1));            

            gc.setLineStyle(SWT.LINE_SOLID);        
        }        
    }
    
    /**
     * Retorna true si se esta reproduciendo y la posicion del player esta en este compas.
     */    
    public boolean isPlaying(){
        if(TuxGuitar.instance().getPlayer().isRunning() && getTrackCoords().hasCaret()){
            long playerTickPosition = TuxGuitar.instance().getPlayer().getTickPosition();
            if(playerTickPosition >= getMeasure().getStart()  && playerTickPosition < getMeasure().getStart() + getMeasure().getLength()){            
                return true;
            }
        }        
        return false;
    }
            
    public int getSpanForComponent(Component component){        
        return  (int)((component.getStart() - getMeasure().getStart())  * getSpan() / getMeasure().getLength());
    }    
    
    public boolean hasTrack(int number){
    	return (trackCoords.getTrack().getNumber() == number);
    }
    
    /**
     * Retorna el ancho del Compas
     */
    public int getWidth() {
        return this.header.getWidth();//this.width;
    }
    
    private int calculateKeySignatureSpan(){
        int span = 0;
        if(paintKeySignature){
        	if(measure.getKeySignature() <= 7){
        		span += 6 * (measure.getKeySignature());	
        	}else{
        		span += 6 * (measure.getKeySignature() - 7);
        	}
        	if(prevMeasure != null ){
        		if(prevMeasure.getKeySignature() <= 7){
        			span += 6 * (prevMeasure.getKeySignature());	
        		}else{
        			span += 6 * (prevMeasure.getKeySignature() - 7);
        		}        	
        	}
        }         
        return span;
    }

    public int getFirstNoteSpan(){
    	return header.getFirstNoteSpan();
    }
    /**
     * Retorna el Componente Anterior
     */
    public MeasureComponent getPreviousComponent(MeasureComponent component) {
        MeasureComponent prevComponent = null;
        for (int noteIdx = 0; noteIdx < measureComponents.size(); noteIdx++) {
            MeasureComponent currComponent = (MeasureComponent) measureComponents.get(noteIdx);

            if (currComponent.getStart() < component.getStart()) {
                if (prevComponent == null) {
                    prevComponent = currComponent;
                } else if (currComponent.getStart() > prevComponent.getStart()) {
                    prevComponent = currComponent;
                } else if (currComponent.getStart() == prevComponent.getStart()
                        && currComponent.getDuration().getTime() <= prevComponent.getDuration().getTime()) {
                    prevComponent = currComponent;
                }
            }
        }
        return prevComponent;
    }

    /**
     * Retorna el Siguiente Componente
     */
    public MeasureComponent getNextComponent(MeasureComponent component) {
        MeasureComponent nextComponent = null;
        for (int noteIdx = 0; noteIdx < measureComponents.size(); noteIdx++) {
            MeasureComponent currComponent = (MeasureComponent) measureComponents.get(noteIdx);
            
            if (currComponent.getStart() > component.getStart()) {
                if (nextComponent == null) {
                    nextComponent = currComponent;
                } else if (currComponent.getStart() < nextComponent.getStart()) {
                    nextComponent = currComponent;
                } else if (currComponent.getStart() == nextComponent.getStart()
                        && currComponent.getDuration().getTime() <= nextComponent.getDuration().getTime()) {
                    nextComponent = currComponent;
                }
            }
        }
        return nextComponent;
    }

    /**
     * Retorna el Primer Componente
     */
    public MeasureComponent getFirstComponent() {
        MeasureComponent firstComponent = null;
        for (int noteIdx = 0; noteIdx < measureComponents.size(); noteIdx++) {
            MeasureComponent currComponent = (MeasureComponent) measureComponents.get(noteIdx);            
            if (firstComponent == null || currComponent.getStart() < firstComponent.getStart()) {
                firstComponent = currComponent;
            }
        }
        return firstComponent;
    }    
    
    /**
     * Retorna el Ultimo Componente
     */
    public MeasureComponent getLastComponent() {
        MeasureComponent lastComponent = null;
        for (int noteIdx = 0; noteIdx < measureComponents.size(); noteIdx++) {
            MeasureComponent currComponent = (MeasureComponent) measureComponents.get(noteIdx);            
            if (lastComponent == null || lastComponent.getStart() < currComponent.getStart()) {
                lastComponent = currComponent;
            }
        }
        return lastComponent;
    }     
    
    /**
     * Retorna Un Componente en la posicion start
     */
    public MeasureComponent getComponent(long start) {
        MeasureComponent component = null;
        for (int noteIdx = 0; noteIdx < measureComponents.size(); noteIdx++) {
            MeasureComponent currComponent = (MeasureComponent) measureComponents.get(noteIdx);            
            
            if (currComponent.getStart() <= start && (currComponent.getStart() + currComponent.getDuration().getTime() > start)) {
                component = currComponent;
                break;
            }
        }
        return component;
    }        

    /**
     * Retorna Todos los Componentes en la posicion Start
     */
    public List getComponents(long start) {
        List components = new ArrayList();        
        Iterator it = measureComponents.iterator();
        while(it.hasNext()){           
            MeasureComponent currComponent = (MeasureComponent)it.next();
            if (currComponent.getStart() == start) {
                components.add(currComponent);
            }
        }
        return components;
    }            
    
    /**
     * Retorna Todos los Componentes en la posicion Start
     */
    public List getComponentsBetween(long start) {
        List components = new ArrayList();        
        Iterator it = measureComponents.iterator();
        while(it.hasNext()){           
            MeasureComponent currComponent = (MeasureComponent)it.next();
            if (currComponent.getStart() <= start && currComponent.getStart() + currComponent.getDuration().getTime() > start) {
                components.add(currComponent);
            }
        }
        return components;
    }       
    
    /**
     * Retorna el Componente en la posicion Start, y en la cuerda
     */
    public MeasureComponent getComponent(long start,int string) {
        MeasureComponent component = null;
        for (int noteIdx = 0; noteIdx < measureComponents.size(); noteIdx++) {            
            MeasureComponent currComponent = (MeasureComponent) measureComponents.get(noteIdx);
            if(currComponent instanceof NoteCoords){
                NoteCoords note = (NoteCoords)currComponent;
                if (note.getStart() <= start && (note.getStart() + note.getDuration().getTime() > start) && note.getNote().getString() == string) {
                    component = currComponent;
                    break;
                }
            }
        }
        return component;
    }    
    
    /**
     * Retorna el Componente en la posicion Start, y en la cuerda
     */
    public MeasureComponent getComponentOrSilence(long start,int string) {
        MeasureComponent component = getComponent(start,string);
        if(component == null){
        	component = getComponent(start);
        }
        return component;
    }  
    
    /**
     * Retorna Todos los desde Start hasta el final del compas
     */
    public List getComponentsBeforeEnd(long fromStart) {
        List components = new ArrayList();        
        Iterator it = measureComponents.iterator();
        while(it.hasNext()){           
            MeasureComponent currComponent = (MeasureComponent)it.next();
            if (currComponent.getStart() >= fromStart) {
                components.add(currComponent);
            }
        }
        return components;
    }            
    
    
    public List getComponents(){
        return this.measureComponents;
    }
    
    
    /**
     * Retorna el Siguiente Componente en la cuerda. que sea de una nota
     */
    public MeasureComponent getNextNoteComponent(MeasureComponent component,int string) {
        MeasureComponent nextComponent = null;
        for (int noteIdx = 0; noteIdx < measureComponents.size(); noteIdx++) {
            MeasureComponent currComponent = (MeasureComponent) measureComponents.get(noteIdx);
            if(currComponent instanceof NoteCoords){                
                Note currNote = ((NoteCoords)currComponent).getNote();
                if(currNote.getString() == string && currNote.getStart() > component.getStart()){
                    if(nextComponent == null || currNote.getStart() < nextComponent.getStart()){
                        nextComponent = currComponent;
                    }
                }                
            }
        }
        return nextComponent;
    }      

    /**
     * Retorna el Siguiente Componente que sea de una nota
     */
    public MeasureComponent getNextNoteComponent(MeasureComponent component) {
        MeasureComponent nextComponent = null;
        for (int noteIdx = 0; noteIdx < measureComponents.size(); noteIdx++) {
            MeasureComponent currComponent = (MeasureComponent) measureComponents.get(noteIdx);
            if(currComponent instanceof NoteCoords){
            if (currComponent.getStart() > component.getStart()) {
                if (nextComponent == null) {
                    nextComponent = currComponent;
                } else if (currComponent.getStart() < nextComponent.getStart()) {
                    nextComponent = currComponent;
                } else if (currComponent.getStart() == nextComponent.getStart()
                        && currComponent.getDuration().getTime() <= nextComponent.getDuration().getTime()) {
                    nextComponent = currComponent;
                }
            }
            }
        }
        return nextComponent;
    }    
    

    /**
     * Retorna el Siguiente Componente que sea de un silencio
     */
    public MeasureComponent getNextSilenceComponent(MeasureComponent component) {
        MeasureComponent nextComponent = null;
        for (int noteIdx = 0; noteIdx < measureComponents.size(); noteIdx++) {
            MeasureComponent currComponent = (MeasureComponent) measureComponents.get(noteIdx);
            if(currComponent instanceof SilenceCoords){
            if (currComponent.getStart() > component.getStart()) {
                if (nextComponent == null) {
                    nextComponent = currComponent;
                } else if (currComponent.getStart() < nextComponent.getStart()) {
                    nextComponent = currComponent;
                } else if (currComponent.getStart() == nextComponent.getStart()
                        && currComponent.getDuration().getTime() <= nextComponent.getDuration().getTime()) {
                    nextComponent = currComponent;
                }
            }
            }
        }
        return nextComponent;
    }        
    
    
    /**
     * Retorna el componente mas cercano a X
     */    
    public MeasureComponent getComponentAt(int x){  
        MeasureComponent component = null;        
        Iterator it = measureComponents.iterator();
        while(it.hasNext()){           
            MeasureComponent currComponent = (MeasureComponent)it.next();
            if(component == null){
                component = currComponent;
            }else{            	
                int distanceX = Math.abs(x - (MeasureHeaderGui.DEFAULT_LEFT_SPAN + getPosX() + component.getPosX() + component.getSpan()));
                int currDistanceX = Math.abs(x - (MeasureHeaderGui.DEFAULT_LEFT_SPAN + getPosX() + currComponent.getPosX() + currComponent.getSpan()));            	
                if(currDistanceX < distanceX){
                    component = currComponent;
                }
            }
            
        }
        return component;
    }          

    /**
     * Retorna la cuerda en la posicion y
     */
    public InstrumentString getStringAt(int y) {
        InstrumentString string = null;
        int stringSpan = this.tablature.getViewLayout().getStringSpan();        
        int minorDistance = 0;
        int firstStringY = getPosY() + ts.getPosition(TrackSpacing.POSITION_TABLATURE);
        
        Iterator it = trackCoords.getTrack().getStrings().iterator();
        while(it.hasNext()){
            InstrumentString currString = (InstrumentString)it.next();                        
            int distanceX = Math.abs(y - (firstStringY + ((currString.getNumber() * stringSpan) - stringSpan)));
            if(string == null || distanceX < minorDistance){
                string = currString;
                minorDistance = distanceX;
            }
        }        
            
        return string;    
    }    
   
    
    public long getBeatLength(){
        return this.beatLength;
    }
        
    public boolean areInSameBeat(MeasureComponent arg0,MeasureComponent arg1){
    	return songManager.getMeasureManager().areInSameBeat(measure,arg0.getComponent(),arg1.getComponent());
    }

    /**
     * Reproduce las notas en el pulso
     */
    public void playBeat(long start){
    	if(!TuxGuitar.instance().getPlayer().isRunning()){
    		List notes = songManager.getMeasureManager().getNotes(measure,start);
    		TuxGuitar.instance().getPlayer().playBeat(getTrackCoords().getTrack(),notes);
    	}
    }
    
    public boolean isCacheEnabled() {
		return cacheEnabled;
	}

	public void setCacheEnabled(boolean cacheEnabled) {
		this.cacheEnabled = cacheEnabled;
	}

	/**
     * Retorna la posicion X dentro del compas 
     */        
    public int getPosX() {
        return posX;
    }
    
    /**
     * Asigna la posicion X dentro del compas 
     */        
    public void setPosX(int posX) {
        this.posX = posX;
    }
    
    /**
     * Retorna la posicion Y dentro del compas 
     */       
    public int getPosY() {
        return posY;
    }
    
    /**
     * Asigna la posicion Y dentro del compas 
     */    
    public void setPosY(int posY) {
        this.posY = posY;
    }

    /**
     * Asigna el span de negras
     */       
    public void setQuarterSpan(int quarterSpan){
        this.quarterSpan = quarterSpan;
    }    
    
    /**
     * Retorna el span de negras
     */       
    public int getQuarterSpan(){
        return this.quarterSpan;
    }
    
    /**
     * Retorna el Compas     
     */
    public Measure getMeasure(){
        return this.measure;
    }   
    
    public int getSpan() {
        return span;
    }
    public void setSpan(int span) {
    	if(span != this.span){
    		setCacheEnabled(false);
    	}
        this.span = span;        
    }
            
    public boolean isOutOfBounds() {
		return outOfBounds;
	}   

	public void setOutOfBounds(boolean outOfBounds) {
		this.outOfBounds = outOfBounds;
	}
	
	public boolean isFirstOfLine() {
		return firstOfLine;
	}

	public void setFirstOfLine(boolean firstOfLine) {
		this.firstOfLine = firstOfLine;
	}


	public SongTrackCoords getTrackCoords(){
        return this.trackCoords;
    }

	
	public TrackSpacing getTs() {
		return ts;
	}

	public void setTs(TrackSpacing ts) {
		if(getTs() == null){
			setCacheEnabled(false);
		}else if(getTs().getPosition(TrackSpacing.POSITION_SCORE_MIDDLE_LINES) != ts.getPosition(TrackSpacing.POSITION_SCORE_MIDDLE_LINES)){
			setCacheEnabled(false);
		}else if(getTs().getPosition(TrackSpacing.POSITION_TABLATURE) != ts.getPosition(TrackSpacing.POSITION_TABLATURE)){
			setCacheEnabled(false);
		}		
		this.ts = ts;
	}

	public int getMaxY() {
		return maxY;
	}

	public int getMinY() {
		return minY;
	}
	
	public List getBeatPositions(){
		return this.beatPositions;
	}
		
	public int getLyricBeatIndex() {
		return lyricBeatIndex;
	}

	public void setLyricBeatIndex(int lyricBeatIndex) {
		this.lyricBeatIndex = lyricBeatIndex;
	}

	public void dispose(){
		this.cache.dispose();
	}
	
	public boolean isDisposed(){
		return this.cache.isDisposed();
	}
	
	/**
	 * Implementacion de Component para crear un pulso de lyric
	 *
	 */
	public class BeatPosition implements Component{
		private long start;
		private int posX;
		private Duration duration;		
		private NoteCoords maxNote;
		private NoteCoords minNote;
		
		public BeatPosition(long start,Duration duration,int posX){
			this.start = start;
			this.duration = duration;
			this.posX = posX;
		}
		
		public void checkValues(NoteCoords note){
			int value = note.getRealValue();
			if(maxNote == null || value > maxNote.getRealValue()){
				maxNote = note;
			}
			if(minNote == null || value < minNote.getRealValue()){
				minNote = note;
			}
		}
		
		public int getPosX(){		
			return (this.posX + getSpanForComponent(this));
		}

		public void setDuration(Duration duration) {	
			this.duration = duration;
		}
		public Duration getDuration() {
			return this.duration;
		}

		public long getStart() {
			return start;
		}
		public void setStart(long start) {			
			this.start = start;
		}				
				
	    public boolean isPlayingBeat(){
	        if(isPlaying()){
	            long playerTickPosition = TuxGuitar.instance().getPlayer().getTickPosition();
	            if(playerTickPosition >= getStart()  && playerTickPosition < getStart() + getDuration().getTime()){            
	                return true;
	            }
	        }
	        return false;
	    }		
		
		
		public NoteCoords getMinNote(){
			return this.minNote;
		}
		
		public NoteCoords getMaxNote(){
			return this.maxNote;
		}
	    
		public void paintExtraLines(GC gc,ViewLayout layout){
			int scoreY = getTs().getPosition(TrackSpacing.POSITION_SCORE_MIDDLE_LINES);
			paintExtraLines(gc,layout,getMinNote(),scoreY);
			paintExtraLines(gc,layout,getMaxNote(),scoreY);
		}
		
		private void paintExtraLines(GC gc,ViewLayout layout,NoteCoords note,int scoreY){
			int y = scoreY + note.getScorePosY();
			int x = MeasureHeaderGui.DEFAULT_LEFT_SPAN + note.getPosX() + note.getSpan();    	
			
			int scoreLineSpan = layout.getScoreLineSpan();
			
			if(y < scoreY){
				layout.setLineColor(gc);
				for(int i = scoreY;i > y;i -= scoreLineSpan){
					gc.drawLine(x - 4,i,x + 12,i);
				}
			}else if(y > (scoreY + (scoreLineSpan * 4))){
				layout.setLineColor(gc);
				for(int i = (scoreY +(scoreLineSpan * 5));i < (y + scoreLineSpan);i += scoreLineSpan){
					gc.drawLine(x - 4,i,x + 12,i);
				}			
			}
		}
			    	    
		public Object clone(){
			return new BeatPosition(this.start,(Duration)this.duration.clone(),this.posX);
		}		
	}
}