package org.herac.tuxguitar.gui.editors.chord;

import java.io.File;
import java.util.List;

import org.herac.tuxguitar.gui.editors.chord.xml.ChordReader;
import org.herac.tuxguitar.gui.editors.chord.xml.ChordWriter;
import org.herac.tuxguitar.gui.util.TuxGuitarFileUtils;
import org.herac.tuxguitar.song.models.Chord;

public class CustomChordManager {
	private long lastEdit;
	private List chords;
	
	public CustomChordManager(){
		this.chords = ChordReader.getChords(getUserFileName());
		this.setLastEdit();
	}	

	public int countChords(){
		return this.chords.size();
	}

	public Chord getChord(int index){
		if(index >= 0 && index < countChords()){
			return ((Chord)((Chord)this.chords.get(index)).clone());
		}
		return null;
	}
	
	public void addChord(Chord chord){
		this.chords.add(chord);
		this.setLastEdit();
	}
	
	public void removeChord(int index){
		if(index >= 0 && index < countChords()){
			this.chords.remove(index);
			this.setLastEdit();
		}
	}
	
	public void renameChord(int index,String name){
		if(index >= 0 && index < countChords()){
			((Chord)this.chords.get(index)).setName(name);
			this.setLastEdit();
		}
	}
	
	public boolean existOtherEqualCustomChord(String name,int index){
		for(int i = 0;i < countChords();i ++){
			Chord chord = getChord(i);
			if(chord.getName().equals(name) && index != i){
				return true;
			}
		}		
		return false;
	}
				
	public void write(){		
		ChordWriter.setChords(chords,getUserFileName());	
	}
	
    private static String getUserFileName(){
    	return TuxGuitarFileUtils.USER_CONFIG_PREFIX + File.separator + "customchords.xml";
    }
    
    private void setLastEdit(){
    	this.lastEdit = System.currentTimeMillis();
    }
    
    public long getLastEdit(){
    	return this.lastEdit;
    }
}
