/*
 * Created on 02-ene-2006
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.editors.chord;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.util.MessageDialog;
import org.herac.tuxguitar.song.models.Chord;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class ChordCustomList extends Composite {
	private ChordEditor editor;    
	private List chords;      
	
	public ChordCustomList(Composite parent,int style,int height,ChordEditor editor) {        
		super(parent,style);
	    this.setLayout(new GridLayout());
	    this.setLayoutData(makeGridData(height));
	    this.editor = editor;
	    this.init();
	}

	public GridData makeGridData(int height){
		GridData data = new GridData(SWT.FILL,SWT.TOP,true,true);
		data.heightHint = height;
		
		return data;
	}
	    
	public void init(){
	   	Composite composite = new Composite(this,SWT.NONE);
	   	composite.setLayout(new GridLayout());	    	
	   	composite.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));
	    	
	   	this.chords = new List(composite,SWT.BORDER | SWT.H_SCROLL | SWT.V_SCROLL);
	   	this.chords.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));
	    this.chords.addSelectionListener(new SelectionAdapter() {
	    	public void widgetSelected(SelectionEvent e) {
	    		if(editor != null){                 
	    			showChord(chords.getSelectionIndex());
	            }
	        }
	    });  
	        
	    
	    //-------------BUTTONS-----------------------------
	    Composite buttons = new Composite(this,SWT.NONE);
	    buttons.setLayout(new GridLayout(3,false));	    	
	    
	    Button add = new Button(buttons,SWT.PUSH);
	    add.setText(TuxGuitar.getProperty("add"));
	    add.addSelectionListener(new SelectionAdapter(){
	    	public void widgetSelected(SelectionEvent e) {
	    		addCustomChord();
			}
	    });
	    
	    Button rename = new Button(buttons,SWT.PUSH);
	    rename.setText(TuxGuitar.getProperty("rename"));
	    rename.addSelectionListener(new SelectionAdapter(){
	    	public void widgetSelected(SelectionEvent e) {
	    		renameCustomChord(chords.getSelectionIndex());
			}
	    });	 	    
	    
	    Button remove = new Button(buttons,SWT.PUSH);
	    remove.setText(TuxGuitar.getProperty("remove"));
	    remove.addSelectionListener(new SelectionAdapter(){
	    	public void widgetSelected(SelectionEvent e) {
	    		removeCustomChord(chords.getSelectionIndex());
			}
	    });

	    loadChords();
	}

	
	private void loadChords(){
		int selectionIndex = chords.getSelectionIndex();
		this.chords.removeAll();

		for(int i = 0;i < TuxGuitar.instance().getCustomChordManager().countChords();i ++){
			Chord chord = TuxGuitar.instance().getCustomChordManager().getChord(i);
			if(chord != null){
				this.chords.add(chord.getName());
			}
		}
		
		if(selectionIndex >= 0 && selectionIndex < this.chords.getItemCount()){
			this.chords.select(selectionIndex);
		}else if(selectionIndex > 0 && (selectionIndex - 1) < this.chords.getItemCount()){
			this.chords.select((selectionIndex - 1));
		}
	}	
	
    private void showChord(int index) {    	
    	Chord chord = TuxGuitar.instance().getCustomChordManager().getChord(index);
        if (chord != null) {        	        	
            int firstFret = -1;
            for (int i = 0; i < chord.getStrings().length; i++) {
                int fretValue = chord.getFretValue(i);
                if (firstFret < 0 || (fretValue < firstFret && fretValue >= 0)) {
                    firstFret = fretValue;
                }
            }
            editor.setFret((short)((firstFret<=0?1:firstFret)));
            for (int i = 0; i < chord.getStrings().length; i++) {
                int fretValue = chord.getFretValue(i);
                editor.addValue(fretValue, i + 1);
            }                       
            editor.redraw();
            
        }
    }	        
	
	private void addCustomChord(){
		Chord chord = editor.getCurrentChord();		
		if(chord != null){
			String name = new NameDialog().open();
			if(name != null){
				if(name.length() == 0){
					String title = TuxGuitar.getProperty("error");
					String message = TuxGuitar.getProperty("chord.custom.name-empty-error");
					new MessageDialog(title,message,SWT.ICON_ERROR).show(getShell());
					return;				
				}			
				if(TuxGuitar.instance().getCustomChordManager().existOtherEqualCustomChord(name,-1)){
					String title = TuxGuitar.getProperty("error");
					String message = TuxGuitar.getProperty("chord.custom.name-exist-error");
					new MessageDialog(title,message,SWT.ICON_ERROR).show(getShell());
					return;
				}
				chord.setName(name);
				TuxGuitar.instance().getCustomChordManager().addChord(chord);
				loadChords();
			}
		}
	}    
	
	private void renameCustomChord(int index){
		Chord chord =  TuxGuitar.instance().getCustomChordManager().getChord(index);
		if(chord != null){			
			String name = new NameDialog(chord.getName()).open();
			if(name != null){
				if(name.length() == 0){
					String title = TuxGuitar.getProperty("error");
					String message = TuxGuitar.getProperty("chord.custom.name-empty-error");
					new MessageDialog(title,message,SWT.ICON_ERROR).show(getShell());
					return;				
				}
				if(TuxGuitar.instance().getCustomChordManager().existOtherEqualCustomChord(name,index)){
					String title = TuxGuitar.getProperty("error");
					String message = TuxGuitar.getProperty("chord.custom.name-exist-error");
					new MessageDialog(title,message,SWT.ICON_ERROR).show(getShell());
					return;
				}									
				TuxGuitar.instance().getCustomChordManager().renameChord(index,name);
				loadChords();
			}
		}
	}
	
	private void removeCustomChord(int index){
		if (index >= 0 && index < TuxGuitar.instance().getCustomChordManager().countChords()) {			
			TuxGuitar.instance().getCustomChordManager().removeChord(index);
			loadChords();
		}
	}

	private class NameDialog{
		private String name;
		
		public NameDialog(String name){
			this.name = name;
		}
		
		public NameDialog(){
			this(new String());
		}
		
		public String open(){     			
			final Shell dialog = new Shell(getShell(), SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);

	        dialog.setLayout(new GridLayout());
	        dialog.setText(TuxGuitar.getProperty("chord.name"));

	        //-----------------NAME------------------------
	        Composite composite = new Composite(dialog, SWT.NONE);
	        composite.setLayout(new GridLayout(2,false));
	        composite.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true)); 
	            
	        Label label = new Label(composite, SWT.NULL);
	        label.setText(TuxGuitar.getProperty("chord.name"));
	                        
	        final Text text = new Text(composite, SWT.BORDER);                                    
	        GridData textData = new GridData(SWT.FILL,SWT.FILL,true,true);    
	        textData.minimumWidth = 150;  
	        text.setLayoutData(textData);
	        text.setText(this.name);
	        //------------------BUTTONS--------------------------            
	        Composite buttons = new Composite(dialog, SWT.NONE);
	        buttons.setLayout(new GridLayout(2,false));
	        buttons.setLayoutData(new GridData(SWT.END,SWT.FILL,true,true));    	
	            
	        GridData buttonData = new GridData(SWT.FILL,SWT.FILL,true,true);    
	        buttonData.minimumWidth = 80;
	        buttonData.minimumHeight = 25;     
	            
	        final Button buttonOK = new Button(buttons, SWT.PUSH);
	        buttonOK.setText(TuxGuitar.getProperty("ok"));
	        buttonOK.setLayoutData(buttonData);
	        buttonOK.addSelectionListener(new SelectionAdapter() {
	        	public void widgetSelected(SelectionEvent arg0) {   
	                name = text.getText();
	        		dialog.dispose();              
	            }
	        });
	        
	        Button buttonCancel = new Button(buttons, SWT.PUSH);
	        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
	        buttonCancel.setLayoutData(buttonData);
	        buttonCancel.addSelectionListener(new SelectionAdapter() {
	        	public void widgetSelected(SelectionEvent arg0) {
	        		name = null;
	        		dialog.dispose();
	        	}
	        });
	            
	        dialog.pack();
	        dialog.open();

	        int x = getShell().getBounds().x + (getShell().getBounds().width - dialog.getSize().x) / 2;
	        int y = getShell().getBounds().y + (getShell().getBounds().height - dialog.getSize().y) / 2;
	        dialog.setLocation(x, y);
	        
    		while (!dialog.isDisposed()) {
                if (!dialog.getDisplay().readAndDispatch()) {
                	dialog.getDisplay().sleep();
                }
            }	        
	        
	        return this.name;
			
		}    				
		
	}
}