package org.herac.tuxguitar.gui.editors;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.piano.Piano;

public class PianoEditor {
	private TablatureEditor tablatureEditor;
	private Piano piano;
	
	public PianoEditor(TablatureEditor tablatureEditor){
		this.tablatureEditor = tablatureEditor;
	}

	
    public void show() {
		Shell shell = TuxGuitar.instance().getTablatureEditor().getTablature().getShell();
		Shell dialog = new Shell(shell, SWT.DIALOG_TRIM);		
		dialog.setLayout(new GridLayout());
		
		this.piano = new Piano(dialog,SWT.NONE);
		
		dialog.pack();
		dialog.open();
		
		int x = shell.getBounds().x + (shell.getBounds().width - dialog.getSize().x) / 2;
		int y = shell.getBounds().y + (shell.getBounds().height - dialog.getSize().y) / 2;
		dialog.setLocation(x, y);
				
		TuxGuitar.instance().updateCache(true);
		while (!dialog.isDisposed()) {
			if (!dialog.getDisplay().readAndDispatch()) {
				dialog.getDisplay().sleep();
			}
		}		
		TuxGuitar.instance().updateCache(true);
    }

	
	private Piano getPiano(){
		return this.piano;
	}
    
	
	public void setScaleChanges(){
		if(isVisible()){
			getPiano().setScaleChanges(true);
		}
	}
	
    public void dispose(){
    	if(!isDisposed()){
    		getPiano().getShell().dispose();
    		getPiano().dispose();
    		
    	}
    }
	
	public void redraw(){
		if(!isDisposed()){
			getPiano().redraw();
		}
	}
	
	public void redrawPlayingMode(){
		if(!isDisposed()){
			getPiano().redrawPlayingMode();
		}
	}
	
	public boolean isVisible(){
		return (!isDisposed() && getPiano().isVisible());
	}

	public boolean isDisposed() {
		return (this.getPiano() == null || getPiano().isDisposed());
	}

	public void loadProperties(){
		if(!isDisposed()){
			getPiano().loadProperties();
		}
	}
	
}
