/*
 * Created on 17-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.actions.insert;

import java.util.Iterator;
import java.util.List;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.editors.chord.ChordCustomList;
import org.herac.tuxguitar.gui.editors.chord.ChordEditor;
import org.herac.tuxguitar.gui.editors.chord.ChordList;
import org.herac.tuxguitar.gui.editors.chord.ChordSelector;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.editors.tab.MeasureComponent;
import org.herac.tuxguitar.gui.editors.tab.MeasureCoords;
import org.herac.tuxguitar.gui.editors.tab.NoteCoords;
import org.herac.tuxguitar.gui.editors.tab.SongTrackCoords;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableMeasureGeneric;
import org.herac.tuxguitar.song.models.Chord;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.NoteEffect;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class InsertChordAction extends Action {
    public static final String NAME = "action.insert.chord";
    private ChordEditor editor;
    private ChordSelector selector;
    private ChordCustomList custom;
    private ChordList list;
    
    public InsertChordAction(TablatureEditor tablatureEditor) {
        super(NAME,true, tablatureEditor);
    }

    public boolean doAction(TypedEvent e) {
        Caret caret = getEditor().getTablature().getCaret();
        SongTrackCoords trackCoords = caret.getSongTrackCoords();
        MeasureCoords measureCoords = caret.getMeasureCoords();
        MeasureComponent component = caret.getSelectedComponent();    	
        if (trackCoords != null && measureCoords != null && component != null) {
        	//Si el acorde llego en el data del widget solo lo agrego
        	if(e.widget.getData() instanceof Chord){    
        		insertChord((Chord)e.widget.getData(), trackCoords, measureCoords, component);
        	}
        	//sino muestro el editor de acordes
        	else{
        		Shell shell = TuxGuitar.instance().getShell();    		
        		showInsertDialog(shell,trackCoords,measureCoords,component);
        	}
        }
        return true;
    }

    protected void updateTablature() {
        fireUpdate(getEditor().getTablature().getCaret().getMeasureCoords().getMeasure().getNumber());
        redraw();
    }

    public void showInsertDialog(Shell shell,final SongTrackCoords trackCoords,final MeasureCoords measureCoords,final MeasureComponent component) {        
    	final Shell dialog = new Shell(shell, SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);

        dialog.setLayout(new GridLayout());            
        dialog.setText(TuxGuitar.getProperty("chord.editor"));

        Composite topComposite = new Composite(dialog, SWT.NONE);  
        topComposite.setLayout(new GridLayout(3,false));
        topComposite.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));  
            
        Composite bottomComposite = new Composite(dialog, SWT.NONE);  
        bottomComposite.setLayout(new GridLayout());
        bottomComposite.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));               
            
        //---------------SELECTOR--------------------------------            
        this.selector = new ChordSelector(topComposite,SWT.NONE);
        this.selector.pack();            
        //---------------EDITOR--------------------------------            
        this.editor = new ChordEditor(topComposite, SWT.NONE,(short)trackCoords.getTrack().getStrings().size());
        this.editor.pack();
        //---------------CUSTOM CHORDS---------------------------------
        this.custom = new ChordCustomList(topComposite, SWT.NONE,Math.max(selector.getBounds().height,editor.getBounds().height),this.editor);            
        //---------------LIST--------------------------------
        Composite listComposite = new Composite(bottomComposite, SWT.NONE);
        listComposite.setLayout(new GridLayout());
        listComposite.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));

        this.list = new ChordList(listComposite);                        
        this.selector.setEditor(this.editor);
        this.selector.setList(this.list);
        this.selector.setTunning(getTunning(trackCoords));
        this.list.setEditor(this.editor);
        //------------------BUTTONS--------------------------     
        Composite buttons = new Composite(dialog, SWT.NONE);
        buttons.setLayout(new GridLayout(2,false));
        buttons.setLayoutData(new GridData(SWT.END,SWT.FILL,true,true));    	
            
        GridData data = new GridData(SWT.FILL,SWT.FILL,true,true);    
        data.minimumWidth = 80;
        data.minimumHeight = 25;    

        final Button buttonOK = new Button(buttons, SWT.PUSH);
        buttonOK.setText(TuxGuitar.getProperty("ok"));
        buttonOK.setLayoutData(data);
        buttonOK.addSelectionListener(new SelectionAdapter() {
        	public void widgetSelected(SelectionEvent arg0) {            
                insertChord(editor.getCurrentChord(), trackCoords, measureCoords, component);
                TuxGuitar.instance().getCustomChordManager().write();
                dialog.dispose();
            }
        });

        Button buttonCancel = new Button(buttons, SWT.PUSH);
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.setLayoutData(data);
        buttonCancel.addSelectionListener(new SelectionAdapter() {
        	public void widgetSelected(SelectionEvent arg0) {
        		TuxGuitar.instance().getCustomChordManager().write();
                dialog.dispose();
            }
        });

        this.setCurrentChord();
            
        dialog.pack();
        dialog.open();

        int x = shell.getBounds().x + (shell.getBounds().width - dialog.getSize().x) / 2;
        int y = shell.getBounds().y + (shell.getBounds().height - dialog.getSize().y) / 2;
        dialog.setLocation(x, y);
            
    	while (!dialog.isDisposed()) {
    		if (!dialog.getDisplay().readAndDispatch()) {
    			dialog.getDisplay().sleep();
    		}
    	}	          
    }
        
    private int[] getTunning(SongTrackCoords trackCoords){
        int[] tunning = new int[trackCoords.getTrack().getStrings().size()];
        
        Iterator it = trackCoords.getTrack().getStrings().iterator();
        while(it.hasNext()){
            InstrumentString string = (InstrumentString)it.next();
            tunning[(tunning.length - string.getNumber())] = string.getValue();
        }                
        
        return tunning;
    }    
    
    private void insertChord(Chord chord, SongTrackCoords trackCoords, MeasureCoords measureCoords, MeasureComponent component) {
        //comienza el undoable
    	UndoableMeasureGeneric undoable = UndoableMeasureGeneric.startUndo(); 
    	
        getSongManager().getMeasureManager().removeAllComponentsAt(measureCoords.getMeasure(),component.getStart());        
        
        Iterator it = trackCoords.getTrack().getStrings().iterator();
        while (it.hasNext()) {
            InstrumentString string = (InstrumentString) it.next();

            int value = chord.getFretValue(string.getNumber() - 1);
            if (value >= 0) {                
            	int velocity = getEditor().getTablature().getCaret().getVelocity();
                Note note = new Note(value, component.getStart(), (Duration) component.getDuration().clone(),velocity, string.getNumber(),false, new NoteEffect());
                getSongManager().getMeasureManager().addNote(measureCoords.getMeasure(),note);
            }
        }

        fireUpdate(measureCoords.getMeasure().getNumber());
        redraw();
        
        //termia el undoable
        getEditor().getUndoManager().addEdit(undoable.endUndo());   
    }    
    
    private void setCurrentChord(){
        Caret caret = getEditor().getTablature().getCaret();          
        if(caret.getSelectedComponent() instanceof NoteCoords){
            int maxValue = -1;
            int minValue = -1;
            List components = caret.getMeasureCoords().getComponents(caret.getSelectedComponent().getStart());
            
            //verifico el fret
            Iterator it = components.iterator();
            while(it.hasNext()){
                MeasureComponent component = (MeasureComponent)it.next();
                if(component instanceof NoteCoords){
                    NoteCoords noteCoords = (NoteCoords)component; 
                    if(maxValue < 0 || maxValue < noteCoords.getNote().getValue()){
                        maxValue = noteCoords.getNote().getValue();
                    }
                    if(minValue < 0 || minValue > noteCoords.getNote().getValue()){
                        minValue = noteCoords.getNote().getValue();
                    }                    
                }
            }            
            if(maxValue > ChordEditor.VIEWING_FRETS  && minValue >= 0){
                this.editor.setFret((short)(minValue));
            }
            
            //agrego los valores
            it = components.iterator();
            while(it.hasNext()){
                MeasureComponent component = (MeasureComponent)it.next();
                if(component instanceof NoteCoords){
                    NoteCoords noteCoords = (NoteCoords)component; 
                    this.editor.addValue(noteCoords.getNote().getValue(),noteCoords.getNote().getString());              
                }
            }              
        }
                
    }

}