/*
 * Created on 17-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.actions.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.util.ConfirmDialog;
import org.herac.tuxguitar.gui.util.FileChooser;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class ExportMidiAction extends Action {
	public static final String NAME = "action.file.export-midi";

	public ExportMidiAction(TablatureEditor tablatureEditor) {
		super(NAME,tablatureEditor);
	}

	public boolean doAction(TypedEvent e) {		
		Shell parent = getEditor().getTablature().getShell();
		String selectedName = FileChooser.instance().save(parent,FileChooser.EXPORT_MIDI_FORMAT);
		if (selectedName != null) {
			boolean canWrite = true;
			if (!isSuportedFormat(selectedName)) {
				selectedName += getDefaultExtension();
			}
			final String fileName = selectedName;

			File file = new File(fileName);
			if (file.exists()) {
				ConfirmDialog confirm = new ConfirmDialog(getEditor().getTablature().getShell(), TuxGuitar.getProperty("replace-file-question"));

				if (!confirm.confirm()) {
					canWrite = false;
				}
			}

			if (canWrite) {
				getEditor().getTablature().changeCursor(SWT.CURSOR_WAIT);
				new SyncThread(new Runnable() {
					public void run() {
						if(!TuxGuitar.isDisposed()){
							try {							
								TuxGuitar.instance().getPlayer().write(new FileOutputStream(fileName));
								getEditor().getTablature().changeCursor(SWT.CURSOR_ARROW);							
							} catch (FileNotFoundException e) {
								e.printStackTrace();
							}
						}
					}
				}).start();
			}
		}

		return true;
	}	

	private boolean isSuportedFormat(String fileName) {
		return (fileName.endsWith(".mid"));
	}

	private String getDefaultExtension() {
		return ".mid";
	}

}
