/*
 * Created on 17-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.actions.dispose;

import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.editors.fretboard.FretBoard;
import org.herac.tuxguitar.gui.system.config.ConfigKeys;
import org.herac.tuxguitar.gui.table.SongTableInfo;


/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class DisposeAction extends Action {
    public static final String NAME = "action.main.dispose";

    public DisposeAction(TablatureEditor tablatureEditor) {
        super(NAME, tablatureEditor);
    }

    public boolean doAction(TypedEvent e) {
    	saveConfig();
    	closeModules();
    	dispose();
        return false;
    }

	private void saveConfig(){
        TuxGuitar.instance().getConfig().setProperty(ConfigKeys.LAYOUT_MODE,getEditor().getTablature().getViewLayout().getMode());        
        TuxGuitar.instance().getConfig().setProperty(ConfigKeys.SHOW_SCORE,getEditor().getTablature().getViewLayout().isScoreEnabled());
        TuxGuitar.instance().getConfig().setProperty(ConfigKeys.SHOW_MULTITRACK,getEditor().getTablature().getViewLayout().isMultitrack());
        TuxGuitar.instance().getConfig().setProperty(ConfigKeys.SHOW_MIXER,!TuxGuitar.instance().getMixer().isDisposed());
        TuxGuitar.instance().getConfig().setProperty(ConfigKeys.SHOW_TRANSPORT,!TuxGuitar.instance().getTransport().isDisposed());
        TuxGuitar.instance().getConfig().setProperty(ConfigKeys.SHOW_FRETBOARD,TuxGuitar.instance().getFretBoardEditor().isVisible());
        TuxGuitar.instance().getConfig().setProperty(ConfigKeys.SHOW_PIANO,TuxGuitar.instance().getPianoEditor().isVisible());          
        TuxGuitar.instance().getConfig().setProperty(ConfigKeys.MAXIMIZED,TuxGuitar.instance().getShell().getMaximized());
        TuxGuitar.instance().getConfig().setProperty(ConfigKeys.WIDTH,TuxGuitar.instance().getShell().getClientArea().width);
        TuxGuitar.instance().getConfig().setProperty(ConfigKeys.HEIGHT,TuxGuitar.instance().getShell().getClientArea().height);                
        TuxGuitar.instance().getConfig().setProperty(ConfigKeys.EDITOR_MOUSE_MODE,getEditor().getTablature().getEditorKit().getMouseMode());
        TuxGuitar.instance().getConfig().setProperty(ConfigKeys.EDITOR_NATURAL_KEY_MODE,getEditor().getTablature().getEditorKit().isNatural());        
        
        TuxGuitar.instance().getConfig().save();
	}

	public void closeModules(){
		TuxGuitar.instance().getPlayer().close();
		TuxGuitar.instance().getPluginManager().closePLugins();
	}
	
    private void dispose(){
    	TuxGuitar.instance().getTablatureEditor().getTablature().dispose();
    	SystemImages.disposeImages();    	
    	SongTableInfo.disposeColors();
    	FretBoard.disposeColors();
    }
	
}