/*
 * Created on 17-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.actions.composition;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.song.models.Song;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class ChangeInfoAction extends Action{
    public static final String NAME = "action.composition.change-info";
    
    private static final int TEXT_WIDTH = 300;
    
    public ChangeInfoAction(TablatureEditor tablatureEditor) {
        super(NAME,true,tablatureEditor);       
    }

    public boolean doAction(TypedEvent e) {
        showDialog(getEditor().getTablature().getShell());
        return true;
    }

    
    public void showDialog(Shell shell) {
        Song song = getEditor().getSongManager().getSong();
        if (song != null) {
            final Shell dialog = new Shell(shell, SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);

            dialog.setLayout(new GridLayout());            
            dialog.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));
            dialog.setText(TuxGuitar.getProperty("composition.properties"));
            
            Group group = new Group(dialog,SWT.SHADOW_ETCHED_IN);            
            group.setLayout(makeGroupLayout(5));
            group.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));
            group.setText(TuxGuitar.getProperty("composition.properties"));
            
            //-------NAME------------------------------------
            Label nameLabel = new Label(group, SWT.NULL);
            nameLabel.setLayoutData(makeLabelData()); 
            nameLabel.setText(TuxGuitar.getProperty("composition.name") + ":");            
            
            final Text name = new Text(group, SWT.BORDER);
            name.setLayoutData(makeTextData());
            name.setText(song.getName());            
            //-------INTERPRET------------------------------------
            Label interpretLabel = new Label(group, SWT.NULL);
            interpretLabel.setLayoutData(makeLabelData());
            interpretLabel.setText(TuxGuitar.getProperty("composition.interpret") + ":");
            
            final Text interpret = new Text(group, SWT.BORDER);
            interpret.setLayoutData(makeTextData());
            interpret.setText(song.getInterpret());                        
            //-------ALBUM------------------------------------
            Label albumLabel = new Label(group, SWT.NULL);
            albumLabel.setLayoutData(makeLabelData());
            albumLabel.setText(TuxGuitar.getProperty("composition.album") + ":");
            
            final Text album = new Text(group, SWT.BORDER);
            album.setLayoutData(makeTextData());
            album.setText(song.getAlbum());                          
            //-------AUTHOR------------------------------------
            Label authorLabel = new Label(group, SWT.NULL);
            authorLabel.setLayoutData(makeLabelData());
            authorLabel.setText(TuxGuitar.getProperty("composition.author") + ":");
            
            final Text author = new Text(group, SWT.BORDER);
            author.setLayoutData(makeTextData());
            author.setText(song.getAuthor());  
                       
            //------------------BUTTONS--------------------------            
            Composite buttons = new Composite(dialog, SWT.NONE);
            buttons.setLayout(new GridLayout(2,false));
            buttons.setLayoutData(new GridData(SWT.RIGHT,SWT.FILL,true,true));    	
            
            GridData data = new GridData(SWT.FILL,SWT.FILL,true,true);    
            data.minimumWidth = 80;
            data.minimumHeight = 25;     
          
            
            final Button buttonOK = new Button(buttons, SWT.PUSH);
            buttonOK.setText(TuxGuitar.getProperty("ok"));
            buttonOK.setLayoutData(data);
            buttonOK.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent arg0) {      
                    setProperties(name.getText(),interpret.getText(),album.getText(),author.getText());
                    dialog.dispose();
                }
            });

            Button buttonCancel = new Button(buttons, SWT.PUSH);
            buttonCancel.setText(TuxGuitar.getProperty("cancel"));
            buttonCancel.setLayoutData(data);
            buttonCancel.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent arg0) {
                    dialog.dispose();
                }
            });

            dialog.pack();
            dialog.open();

            int x = shell.getBounds().x + (shell.getBounds().width - dialog.getSize().x) / 2;
            int y = shell.getBounds().y + (shell.getBounds().height - dialog.getSize().y) / 2;
            dialog.setLocation(x, y);
        }
    }
 
    private GridLayout makeGroupLayout(int spacing){
    	GridLayout layout = new GridLayout(2,false);    	
    	layout.marginTop = spacing;
    	layout.marginBottom = spacing;
    	layout.marginLeft = spacing;
    	layout.marginRight = spacing;    	
    	layout.verticalSpacing = spacing;
    	layout.horizontalSpacing = spacing;
    	return layout;
    }
    
    private GridData makeTextData(){
    	return new GridData(TEXT_WIDTH,SWT.DEFAULT);
    }

    private GridData makeLabelData(){
    	return new GridData(SWT.RIGHT,SWT.CENTER,true,true);
    }
    
    
    private void setProperties(String name,String interpret,String album,String author){
        getEditor().getSongManager().setProperties(name,interpret,album,author);   
        TuxGuitar.instance().showTitle();
        redraw();
    }    

}
