/*
 * Created on 18-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.actions.caret.GoDownAction;
import org.herac.tuxguitar.gui.actions.caret.GoLeftAction;
import org.herac.tuxguitar.gui.actions.caret.GoRightAction;
import org.herac.tuxguitar.gui.actions.caret.GoUpAction;
import org.herac.tuxguitar.gui.actions.composition.ChangeClefAction;
import org.herac.tuxguitar.gui.actions.composition.ChangeInfoAction;
import org.herac.tuxguitar.gui.actions.composition.ChangeKeySignatureAction;
import org.herac.tuxguitar.gui.actions.composition.ChangeTempoAction;
import org.herac.tuxguitar.gui.actions.composition.ChangeTimeSignatureAction;
import org.herac.tuxguitar.gui.actions.composition.ChangeTripletFeelAction;
import org.herac.tuxguitar.gui.actions.dispose.DisposeAction;
import org.herac.tuxguitar.gui.actions.duration.ChangeDottedDurationAction;
import org.herac.tuxguitar.gui.actions.duration.ChangeDoubleDottedDurationAction;
import org.herac.tuxguitar.gui.actions.duration.ChangeTupletoDurationAction;
import org.herac.tuxguitar.gui.actions.duration.DecrementDurationAction;
import org.herac.tuxguitar.gui.actions.duration.IncrementDurationAction;
import org.herac.tuxguitar.gui.actions.duration.SetEighthDurationAction;
import org.herac.tuxguitar.gui.actions.duration.SetHalfDurationAction;
import org.herac.tuxguitar.gui.actions.duration.SetQuarterDurationAction;
import org.herac.tuxguitar.gui.actions.duration.SetSixteenthDurationAction;
import org.herac.tuxguitar.gui.actions.duration.SetSixtyFourthDurationAction;
import org.herac.tuxguitar.gui.actions.duration.SetThirtySecondDurationAction;
import org.herac.tuxguitar.gui.actions.duration.SetWholeDurationAction;
import org.herac.tuxguitar.gui.actions.edit.RedoAction;
import org.herac.tuxguitar.gui.actions.edit.SetMouseModeEditionAction;
import org.herac.tuxguitar.gui.actions.edit.SetMouseModeSelectionAction;
import org.herac.tuxguitar.gui.actions.edit.SetNaturalKeyAction;
import org.herac.tuxguitar.gui.actions.edit.UndoAction;
import org.herac.tuxguitar.gui.actions.effects.ChangeAccentuatedNoteAction;
import org.herac.tuxguitar.gui.actions.effects.ChangeBendNoteAction;
import org.herac.tuxguitar.gui.actions.effects.ChangeDeadNoteAction;
import org.herac.tuxguitar.gui.actions.effects.ChangeFadeInAction;
import org.herac.tuxguitar.gui.actions.effects.ChangeGhostNoteAction;
import org.herac.tuxguitar.gui.actions.effects.ChangeGraceNoteAction;
import org.herac.tuxguitar.gui.actions.effects.ChangeHammerNoteAction;
import org.herac.tuxguitar.gui.actions.effects.ChangeHarmonicNoteAction;
import org.herac.tuxguitar.gui.actions.effects.ChangeHeavyAccentuatedNoteAction;
import org.herac.tuxguitar.gui.actions.effects.ChangePalmMuteAction;
import org.herac.tuxguitar.gui.actions.effects.ChangePoppingAction;
import org.herac.tuxguitar.gui.actions.effects.ChangeSlappingAction;
import org.herac.tuxguitar.gui.actions.effects.ChangeSlideNoteAction;
import org.herac.tuxguitar.gui.actions.effects.ChangeStaccatoAction;
import org.herac.tuxguitar.gui.actions.effects.ChangeTappingAction;
import org.herac.tuxguitar.gui.actions.effects.ChangeTremoloBarAction;
import org.herac.tuxguitar.gui.actions.effects.ChangeTremoloPickingAction;
import org.herac.tuxguitar.gui.actions.effects.ChangeTrillNoteAction;
import org.herac.tuxguitar.gui.actions.effects.ChangeVibratoNoteAction;
import org.herac.tuxguitar.gui.actions.file.ExportASCIIAction;
import org.herac.tuxguitar.gui.actions.file.ExportMidiAction;
import org.herac.tuxguitar.gui.actions.file.ExportPDFAction;
import org.herac.tuxguitar.gui.actions.file.ImportMidiAction;
import org.herac.tuxguitar.gui.actions.file.NewFileAction;
import org.herac.tuxguitar.gui.actions.file.OpenFileAction;
import org.herac.tuxguitar.gui.actions.file.PrintAction;
import org.herac.tuxguitar.gui.actions.file.PrintPreviewAction;
import org.herac.tuxguitar.gui.actions.file.SaveAsFileAction;
import org.herac.tuxguitar.gui.actions.file.SaveFileAction;
import org.herac.tuxguitar.gui.actions.help.ShowAboutDialogAction;
import org.herac.tuxguitar.gui.actions.insert.CloseRepeatAction;
import org.herac.tuxguitar.gui.actions.insert.InsertChordAction;
import org.herac.tuxguitar.gui.actions.insert.OpenRepeatAction;
import org.herac.tuxguitar.gui.actions.layout.SetLinearLayoutAction;
import org.herac.tuxguitar.gui.actions.layout.SetMultitrackViewAction;
import org.herac.tuxguitar.gui.actions.layout.SetPageLayoutAction;
import org.herac.tuxguitar.gui.actions.layout.SetScoreEnabledAction;
import org.herac.tuxguitar.gui.actions.marker.AddMarkerAction;
import org.herac.tuxguitar.gui.actions.marker.GoFirstMarkerAction;
import org.herac.tuxguitar.gui.actions.marker.GoLastMarkerAction;
import org.herac.tuxguitar.gui.actions.marker.GoNextMarkerAction;
import org.herac.tuxguitar.gui.actions.marker.GoPreviousMarkerAction;
import org.herac.tuxguitar.gui.actions.marker.ListMarkersAction;
import org.herac.tuxguitar.gui.actions.measure.AddMeasureAction;
import org.herac.tuxguitar.gui.actions.measure.CleanMeasureAction;
import org.herac.tuxguitar.gui.actions.measure.CopyMeasureAction;
import org.herac.tuxguitar.gui.actions.measure.GoFirstMeasureAction;
import org.herac.tuxguitar.gui.actions.measure.GoLastMeasureAction;
import org.herac.tuxguitar.gui.actions.measure.GoNextMeasureAction;
import org.herac.tuxguitar.gui.actions.measure.GoPreviousMeasureAction;
import org.herac.tuxguitar.gui.actions.measure.PasteMeasureAction;
import org.herac.tuxguitar.gui.actions.measure.RemoveMeasureAction;
import org.herac.tuxguitar.gui.actions.note.ChangeNoteAction;
import org.herac.tuxguitar.gui.actions.note.ChangeTiedNoteAction;
import org.herac.tuxguitar.gui.actions.note.ChangeVelocityAction;
import org.herac.tuxguitar.gui.actions.note.CleanBeatAction;
import org.herac.tuxguitar.gui.actions.note.DecrementNoteSemitoneAction;
import org.herac.tuxguitar.gui.actions.note.IncrementNoteSemitoneAction;
import org.herac.tuxguitar.gui.actions.note.InsertNoteAction;
import org.herac.tuxguitar.gui.actions.note.RemoveNoteAction;
import org.herac.tuxguitar.gui.actions.note.ShiftNoteDownAction;
import org.herac.tuxguitar.gui.actions.note.ShiftNoteUpAction;
import org.herac.tuxguitar.gui.actions.player.PlaySongAction;
import org.herac.tuxguitar.gui.actions.player.StopSongAction;
import org.herac.tuxguitar.gui.actions.settings.ConfigureKeyBindingsAction;
import org.herac.tuxguitar.gui.actions.settings.EditConfigAction;
import org.herac.tuxguitar.gui.actions.tools.SelectScaleAction;
import org.herac.tuxguitar.gui.actions.track.AddTrackAction;
import org.herac.tuxguitar.gui.actions.track.ChangeTrackPropertiesAction;
import org.herac.tuxguitar.gui.actions.track.CloneTrackAction;
import org.herac.tuxguitar.gui.actions.track.EditLyricsAction;
import org.herac.tuxguitar.gui.actions.track.GoFirstTrackAction;
import org.herac.tuxguitar.gui.actions.track.GoLastTrackAction;
import org.herac.tuxguitar.gui.actions.track.GoNextTrackAction;
import org.herac.tuxguitar.gui.actions.track.GoPreviousTrackAction;
import org.herac.tuxguitar.gui.actions.track.GoToTrackAction;
import org.herac.tuxguitar.gui.actions.track.MoveTrackDownAction;
import org.herac.tuxguitar.gui.actions.track.MoveTrackUpAction;
import org.herac.tuxguitar.gui.actions.track.RemoveTrackAction;
import org.herac.tuxguitar.gui.actions.view.ShowFretBoardAction;
import org.herac.tuxguitar.gui.actions.view.ShowMixerAction;
import org.herac.tuxguitar.gui.actions.view.ShowPianoAction;
import org.herac.tuxguitar.gui.actions.view.ShowTransportAction;
import org.herac.tuxguitar.gui.editors.TablatureEditor;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class ActionContainer {
    private Map actions;    
    private TablatureEditor tablatureEditor;
    private TypedEvent lastEvent;
    
    public ActionContainer(TablatureEditor tablatureEditor){
        this.tablatureEditor = tablatureEditor;
        this.actions = new HashMap();        
    }
    
    public void initActions(){                
        //file actions
        addAction(new NewFileAction(this.tablatureEditor));
        addAction(new OpenFileAction(this.tablatureEditor));
        addAction(new SaveFileAction(this.tablatureEditor));
        addAction(new SaveAsFileAction(this.tablatureEditor));
        addAction(new ImportMidiAction(this.tablatureEditor));
        addAction(new ExportMidiAction(this.tablatureEditor));
        addAction(new ExportPDFAction(this.tablatureEditor));
        addAction(new ExportASCIIAction(this.tablatureEditor));
        addAction(new PrintAction(this.tablatureEditor));
        addAction(new PrintPreviewAction(this.tablatureEditor));
        
        //edit actions
        addAction(new UndoAction(this.tablatureEditor));
        addAction(new RedoAction(this.tablatureEditor));
        addAction(new SetMouseModeSelectionAction(this.tablatureEditor));
        addAction(new SetMouseModeEditionAction(this.tablatureEditor));
        addAction(new SetNaturalKeyAction(this.tablatureEditor));
        
        //layout actions
        addAction(new SetPageLayoutAction(this.tablatureEditor));
        addAction(new SetLinearLayoutAction(this.tablatureEditor));
        addAction(new SetMultitrackViewAction(this.tablatureEditor));
        addAction(new SetScoreEnabledAction(this.tablatureEditor));
        
        //view actions
        addAction(new ShowFretBoardAction(this.tablatureEditor));
        addAction(new ShowPianoAction(this.tablatureEditor));
        addAction(new ShowMixerAction(this.tablatureEditor));
        addAction(new ShowTransportAction(this.tablatureEditor));
        
        //composition actions
        addAction(new ChangeTimeSignatureAction(this.tablatureEditor));
        addAction(new ChangeTempoAction(this.tablatureEditor));
        addAction(new ChangeClefAction(this.tablatureEditor));
        addAction(new ChangeKeySignatureAction(this.tablatureEditor));
        addAction(new ChangeTripletFeelAction(this.tablatureEditor));
        addAction(new ChangeInfoAction(this.tablatureEditor));
        
        //track actions
        addAction(new AddTrackAction(this.tablatureEditor));
        addAction(new RemoveTrackAction(this.tablatureEditor));
        addAction(new CloneTrackAction(this.tablatureEditor));
        addAction(new GoFirstTrackAction(this.tablatureEditor));
        addAction(new GoLastTrackAction(this.tablatureEditor));
        addAction(new GoNextTrackAction(this.tablatureEditor));
        addAction(new GoToTrackAction(this.tablatureEditor));
        addAction(new GoPreviousTrackAction(this.tablatureEditor));
        addAction(new MoveTrackUpAction(this.tablatureEditor));
        addAction(new MoveTrackDownAction(this.tablatureEditor));
        addAction(new EditLyricsAction((this.tablatureEditor)));
        addAction(new ChangeTrackPropertiesAction((this.tablatureEditor)));
        
        //measure actions
        addAction(new AddMeasureAction(this.tablatureEditor));
        addAction(new RemoveMeasureAction(this.tablatureEditor));
        addAction(new CopyMeasureAction(this.tablatureEditor));
        addAction(new PasteMeasureAction(this.tablatureEditor));
        addAction(new GoFirstMeasureAction(this.tablatureEditor));
        addAction(new GoLastMeasureAction(this.tablatureEditor));
        addAction(new GoNextMeasureAction(this.tablatureEditor));
        addAction(new GoPreviousMeasureAction(this.tablatureEditor));
        addAction(new CleanMeasureAction(this.tablatureEditor));
        
        //note actions
        addAction(new ChangeNoteAction(this.tablatureEditor));        
        addAction(new InsertNoteAction(this.tablatureEditor));
        addAction(new RemoveNoteAction(this.tablatureEditor));
        addAction(new CleanBeatAction(this.tablatureEditor));
        addAction(new ChangeTiedNoteAction(this.tablatureEditor));        
        addAction(new ChangeVelocityAction(this.tablatureEditor));        
        addAction(new ShiftNoteUpAction(this.tablatureEditor));
        addAction(new ShiftNoteDownAction(this.tablatureEditor));
        addAction(new IncrementNoteSemitoneAction(this.tablatureEditor));
        addAction(new DecrementNoteSemitoneAction(this.tablatureEditor));
        
        //duration actions
        addAction(new SetWholeDurationAction(this.tablatureEditor));
        addAction(new SetHalfDurationAction(this.tablatureEditor));
        addAction(new SetQuarterDurationAction(this.tablatureEditor));
        addAction(new SetEighthDurationAction(this.tablatureEditor));
        addAction(new SetSixteenthDurationAction(this.tablatureEditor));
        addAction(new SetThirtySecondDurationAction(this.tablatureEditor));
        addAction(new SetSixtyFourthDurationAction(this.tablatureEditor));
        addAction(new ChangeDottedDurationAction(this.tablatureEditor));
        addAction(new ChangeDoubleDottedDurationAction(this.tablatureEditor));
        addAction(new ChangeTupletoDurationAction(this.tablatureEditor));
        addAction(new IncrementDurationAction(this.tablatureEditor));
        addAction(new DecrementDurationAction(this.tablatureEditor));
        
        //insert actions
        addAction(new OpenRepeatAction(this.tablatureEditor));
        addAction(new CloseRepeatAction(this.tablatureEditor));         
        addAction(new InsertChordAction(this.tablatureEditor));
        
        //note effects action
        addAction(new ChangeVibratoNoteAction(this.tablatureEditor));     
        addAction(new ChangeBendNoteAction(this.tablatureEditor));
        addAction(new ChangeDeadNoteAction(this.tablatureEditor));
        addAction(new ChangeSlideNoteAction(this.tablatureEditor));
        addAction(new ChangeHammerNoteAction(this.tablatureEditor));
        addAction(new ChangeGhostNoteAction(this.tablatureEditor));
        addAction(new ChangeAccentuatedNoteAction(this.tablatureEditor));
        addAction(new ChangeHeavyAccentuatedNoteAction(this.tablatureEditor));
        addAction(new ChangeHarmonicNoteAction(this.tablatureEditor));
        addAction(new ChangeGraceNoteAction(this.tablatureEditor));
        addAction(new ChangeTrillNoteAction(this.tablatureEditor));
        addAction(new ChangeTremoloPickingAction(this.tablatureEditor));
        addAction(new ChangePalmMuteAction(this.tablatureEditor));        
        addAction(new ChangeStaccatoAction(this.tablatureEditor));
        addAction(new ChangeTappingAction(this.tablatureEditor));
        addAction(new ChangeSlappingAction(this.tablatureEditor));
        addAction(new ChangePoppingAction(this.tablatureEditor));
        addAction(new ChangeTremoloBarAction(this.tablatureEditor));
        addAction(new ChangeFadeInAction(this.tablatureEditor));
        
        //marker actions
        addAction(new AddMarkerAction(this.tablatureEditor));
        addAction(new ListMarkersAction(this.tablatureEditor));
        addAction(new GoPreviousMarkerAction(this.tablatureEditor));
        addAction(new GoNextMarkerAction(this.tablatureEditor));
        addAction(new GoFirstMarkerAction(this.tablatureEditor));        
        addAction(new GoLastMarkerAction(this.tablatureEditor));
        
        //player actions
        addAction(new PlaySongAction(this.tablatureEditor));
        addAction(new StopSongAction(this.tablatureEditor));        
        
        //language actions
        //addAction(new ChangeLanguageAction(this.tablatureEditor)); 

        //setting actions
        addAction(new EditConfigAction(this.tablatureEditor)); 
        addAction(new ConfigureKeyBindingsAction(this.tablatureEditor)); 
        
        //caret actions
        addAction(new GoRightAction(this.tablatureEditor));
        addAction(new GoLeftAction(this.tablatureEditor));
        addAction(new GoUpAction(this.tablatureEditor));
        addAction(new GoDownAction(this.tablatureEditor));        
        
        //help actions
        addAction(new ShowAboutDialogAction(this.tablatureEditor));
        
        //mouse actions
        //addAction(new SelectComponentAction(this.tablatureEditor));
        
        //tools
        addAction(new SelectScaleAction(this.tablatureEditor));
        
        //dispose
        addAction(new DisposeAction(this.tablatureEditor));
    }
    
    
    private void addAction(Action action){
        this.actions.put(action.getName(),action);
    }
 
    public Action getAction(String name){
        return (Action)this.actions.get(name);
    }    
    
    public List getAvailableKeyBindingActions(){
    	List availableKeyBindingActions = new ArrayList();
    	Iterator it = this.actions.keySet().iterator();
    	while(it.hasNext()){
    		String actionName = (String)it.next();
    		if(getAction(actionName).isEditableKeyBinding()){
    			availableKeyBindingActions.add(actionName);
    		}
    	}        
    	return availableKeyBindingActions;
    }  
    
    public TypedEvent getLastEvent() {
        return lastEvent;
    }
    
    public void setLastEvent(TypedEvent lastEvent) {
        this.lastEvent = lastEvent;
    }
}
