#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "interface.h"

#include "treedata.h"

static tpanel menubar;
static tpmenu mfile, medit, mutil, mabout;
static tpitem iabout, ihelp;
static tpitem iload, isave, iprint, iquit, iundo, icut, icopy, ipaste;
static tpitem idelete, iadd;
static tpitem ifind, izin, izout, inode, itree, ibranch, iscale;
static tpitem ishowhandles, ishowpagelines;

int m_help(m, mi, e)
tpmenu m;
tpitem mi;
tevent e;
{
	seteventloc(e);
	show_help_frame(0);
}

int m_about(m, mi, e)
tpmenu m;
tpitem mi;
tevent e;
{
	seteventloc(e);
	show_about_frame();
}

int m_load(m, mi, e)
tpmenu m;
tpitem mi;
tevent e;
{
	seteventloc(e);
	show_load_dialog();
}

int m_save(m, mi, e)
tpmenu m;
tpitem mi;
tevent e;
{
	seteventloc(e);
	show_save_dialog();
}

int m_print(m, mi, e)
tpmenu m;
tpitem mi;
tevent e;
{
	seteventloc(e);
	show_printer_frame();
}

int m_quit(m, mi, e)
tpmenu m;
tpitem mi;
tevent e;
{
	seteventloc(e);
	if(quit(e))
		exit(0);
}

int m_undo(m, mi, e)
tpmenu m;
tpitem mi;
tevent e;
{
	seteventloc(e);
	do_command(Undo,NULL,NULL,0.0,0.0,0,0,0,0,0);
}

int m_cut(m, mi, e)
tpmenu m;
tpitem mi;
tevent e;
{
	seteventloc(e);
	if(do_command(Copy,NULL,NULL,0.0,0.0,0,0,0,0,0))
		do_command(Cut,NULL,NULL,0.0,0.0,0,0,0,0,0);
}

int m_delete(m, mi, e)
tpmenu m;
tpitem mi;
tevent e;
{
	seteventloc(e);
	do_command(Delete,NULL,NULL,0.0,0.0,0,0,0,0,0);
}

int m_copy(m, mi, e)
tpmenu m;
tpitem mi;
tevent e;
{
	seteventloc(e);
	do_command(Copy,NULL,NULL,0.0,0.0,0,0,0,0,0);
}

int m_paste(m, mi, e)
tpmenu m;
tpitem mi;
tevent e;
{
	seteventloc(e);
	do_command(Paste,NULL,NULL,0.0,0.0,0,0,0,0,0);
}

int m_add(m, mi, e)
tpmenu m;
tpitem mi;
tevent e;
{
	seteventloc(e);
	do_command(PasteSubtree,NULL,NULL,0.0,0.0,0,0,0,0,0);
}

int m_find(m, mi, e)
tpmenu m;
tpitem mi;
tevent e;
{
	seteventloc(e);
	show_find_frame();
}

int m_zin(m, mi, e)
tpmenu m;
tpitem mi;
tevent e;
{
	seteventloc(e);
	canvas_zoom_in();
}

int m_zout(m, mi, e)
tpmenu m;
tpitem mi;
tevent e;
{
	seteventloc(e);
	canvas_zoom_out();
}

int m_node_info(m, mi, e)
tpmenu m;
tpitem mi;
tevent e;
{
	seteventloc(e);
	show_node_info_frame();
}

int m_scale_info(m, mi, e)
tpmenu m;
tpitem mi;
tevent e;
{
	seteventloc(e);
	show_scale_info_frame();
}

int m_tree_info(m, mi, e)
tpmenu m;
tpitem mi;
tevent e;
{
	seteventloc(e);
	show_tree_info_frame();
}

int m_branch_info(m, mi, e)
tpmenu m;
tpitem mi;
tevent e;
{
	seteventloc(e);
	show_branch_info_frame();
}

create_menu_items()
{
	iabout=tpitem_new("About Treetool...", m_about);
	ihelp=tpitem_new("Help...", m_help);
	iload=tpitem_new("Load...", m_load);
	isave=tpitem_new("Save...", m_save);
	iprint=tpitem_new("Print...", m_print);
	iquit=tpitem_new("Quit", m_quit);
	iundo=tpitem_new("Undo", m_undo);
	icut=tpitem_new("Cut", m_cut);
	icopy=tpitem_new("Copy", m_copy);
	ipaste=tpitem_new("Paste", m_paste);
	idelete=tpitem_new("Delete", m_delete);
	iadd=tpitem_new("Add", m_add);
	ifind=tpitem_new("Find...", m_find);
	izin=tpitem_new("Zoom In", m_zin);
	izout=tpitem_new("Zoom Out", m_zout);
	inode=tpitem_new("Node Settings...", m_node_info);
	itree=tpitem_new("Tree Settings...", m_tree_info);
	ibranch=tpitem_new("Branch Settings...", m_branch_info);
	iscale=tpitem_new("Scale Bar Settings...", m_scale_info);
	create_extras_menu_items();
}

create_menus(p)
tpanel p;
{
	create_menu_items();
	mabout=tpmenu_new(p, 10, 10, 0, 0, NULL, NULL, "Help");
	mfile=tpmenu_new(p, 10, 10, 0, 0, mabout, NULL, "File");
	medit=tpmenu_new(p, 10, 10, 0, 0, mfile, NULL, "Edit");
	mutil=tpmenu_new(p, 10, 10, 0, 0, medit, NULL, "Utilities");
	tpmenu_add(mabout, iabout, NULL);
	tpmenu_add(mabout, ihelp, NULL);
	tpmenu_add(mfile, iload, NULL);
	tpmenu_add(mfile, isave, NULL);
	tpmenu_add(mfile, iprint, NULL);
	tpmenu_add(mfile, iquit, NULL);
	tpmenu_add(medit, iundo, NULL);
	tpitem_disable(iundo);
	tpmenu_add(medit, icut, NULL);
	tpmenu_add(medit, icopy, NULL);
	tpmenu_add(medit, ipaste, NULL);
	tpmenu_add(medit, iadd, NULL);
	tpmenu_add(medit, idelete, NULL);
	tpmenu_add(mutil, ifind, NULL);
	tpmenu_add(mutil, izin, NULL);
	tpmenu_add(mutil, izout, NULL);
	tpmenu_add(mutil, itree, NULL);
	tpmenu_add(mutil, inode, NULL);
	tpmenu_add(mutil, ibranch, NULL);
	tpmenu_add(mutil, iscale, NULL);
	create_extras_menu(p, mutil);
	create_tool_buttons(p, mabout);
}

grey_menus(numtrees, clip, multi, subtrees, nodes, branches)
int numtrees, clip, multi, subtrees, nodes, branches;
{
	tpitem_disable(iundo);
	if(multi==1 && (nodes || subtrees))
		tpitem_enable(icut);
	else
		tpitem_disable(icut);
	if(multi==1 && subtrees)
		tpitem_enable(icopy);
	else
		tpitem_disable(icopy);
	if(clip)
		tpitem_enable(ipaste);
	else
		tpitem_disable(ipaste);
/* debugging, delete doesn't work right now
	if(nodes || subtrees)
		tpitem_enable(idelete);
	else
*/
		tpitem_disable(idelete);
	if(multi==1 && (branches || nodes || subtrees) && clip)
		tpitem_enable(iadd);
	else
		tpitem_disable(iadd);
}

