#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* find.c:
 *
 * routines for handling the dialog boxes associated with searching the
 * tree for particular node names.
 */

#include "interface.h"

#include "treedata.h"

static tframe info;
static tpanel p;
static tpcheck replacecheck;
static tptext find;
static tpbutton findb, selectallb, cancelb;
static int replacing;

int find_find(b, e)
	/* callback for the find button on the find window.  Gets the string to 
	 * search for and searches for it, calling the MoveOnscreen command */
tpbutton b;
tevent e;
{
	char *s;

	s=tptext_get_val(find);
	if(s!=NULL)
		if(strlen(s)>0)
		{
			do_command(MoveOnscreen, s, NULL, 0.0, 0.0,
				replacing, 0, 0, 0, 0);
		}
	hide_find_frame();
}

int find_cancel(b, e)
	/* cancels the find request, just hides the window */
tpbutton b;
tevent e;
{
	tframe_pull_pin(info);
	tframe_hide(info);
}

int find_selectall(b, e)
	/* callback for the select all button on the find window.  Gets the
	 * string to search for and searches for it, calling the MoveAllOnscreen
	 * command */
tpbutton b;
tevent e;
{
	char *s;

	s=tptext_get_val(find);
	if(s!=NULL)
		if(strlen(s)>0)
		{
			do_command(MoveAllOnscreen, s, NULL, 0.0, 0.0,
				replacing, 0, 0, 0, 0);
		}
	hide_find_frame();
}

int find_enter_name(t, e)
	/* callback for the text field where user enters the name to look for.
	 * Just calls the procedure for the find button when the user hits
	 * return.
	 */
tptext t;
tevent e;
{
    char *s;
    double d;
    int i;

    if(tevent_type(e)==te_keydown)
    {
		s=tevent_string(e);
		if(s[0]=='\n' || s[0]=='\r')
		{
			find_find(findb, e);
			return(tptext_next);
		}
		return(tptext_insert);
    }
	return(tptext_dontknow);
}

int find_check_replace(s, e, v)
	/* when the user toggles the replace checkbox, the value of replacing is
	 * changed.  If replacing is 1 when Move[All]Onscreen is called, then
	 * the original selection will be replaced.  Otherwise the nodes found
	 * by the search will be added to the selection.
	 */
tpcheck s;
tevent e;
int v;
{
	replacing=v;
}

int create_find_frame(parent, args)
	/* create the frame */
tframe parent;
targs args;
{
    info=tframe_new(parent, 580,100,50,50,0,1,0, "Find Node", args);
    if(info==NULL)
		return(0);
    p=tframe_dialog_panel(info);
    if(p==NULL)
		return(0);

	findb=tpbutton_new(p, 10, 10, 0, 0, NULL, NULL, "Find");
	tpbutton_set_event_procedure(findb, find_find);
	selectallb=tpbutton_new(p, 10, 10, 0, 0, findb, NULL, "Find All");
	tpbutton_set_event_procedure(selectallb, find_selectall);
	cancelb=tpbutton_new(p, 10, 10, 0, 0, selectallb, NULL, "Cancel");
	tpbutton_set_event_procedure(cancelb, find_cancel);
	replacecheck=tpcheck_new(p, 10, 10, 0, 0, NULL, findb,
		"Replace Current Selection");
	tpcheck_set_event_procedure(replacecheck, find_check_replace);
	tpcheck_set(replacecheck, 1);
	replacing=1;
    find=tptext_new(p, 10, 10, 100, 0, NULL, replacecheck,
		"Node name:");
	tptext_set_displayed_characters(find, 50);
    tptext_set_event_procedure(find, find_enter_name);

    tpanel_fit(p);
    tframe_fit(info);
    tframe_hide(info);
	tframe_pull_pin(info);
    return(1);
}

int show_find_frame()
{
	moveframetoloc(info);
    tframe_show(info);
}

int hide_find_frame()
{
    tframe_hide(info);
}

find_busy()
{
	if(info!=NULL)
		tframe_set_busy(info);
}

find_notbusy()
{
	if(info!=NULL)
		tframe_set_notbusy(info);
}
