#include "list.h"

typedef enum {		/* type of object */
	tr_tree,
	tr_node,
	tr_branch
	} data_type;

typedef struct TREEBRANCH *treebranch;
typedef struct TREE *tree;
typedef struct TREENODE *treenode;

typedef struct {
	data_type type;			/* type of object */
	tree t;					/* tree it's in */
	void *intdata;			/* internal data */
	void *data;				/* user data */
	} treegend, *treegen;

typedef struct TREEBRANCH {
	treegend gen;
	int specified;			/* 1 if this distance was specified */
	double distance;		/* distance of branch */
	treenode up;			/* node up in tree */
	treenode down;			/* node down in tree */
	} treebranchd;

typedef struct TREE {
	treegend gen;
	char *name;			/* name */
	int rooted;				/* 1 if this should be a rooted tree */
	treenode root;			/* root node */
	list branches;			/* list of all branches */
	list nodes;				/* list of all nodes */
	double unspecdist;		/* distance to use when unspecified */
	} treed;

typedef struct TREENODE {
	treegend gen;
	char *name;				/* name */
	list branches;			/* list of branches */
		/* parent is the one that doesn't have this node as 'up' */
	list currentbranch;		/* the current one, for first/nextsubtree */
	list bn;				/* list of comments before node */
	list al;				/* list of comments after node list */
	list an;				/* list of comments after name */
	list bd;				/* list of comments before distance */
	list ad;				/* list of comments after distance */
	treenode duped;			/* for duplicating subtrees, temp data */
	} treenoded;

typedef enum {
	BEFORE_NODE,
	AFTER_LIST,
	AFTER_NAME,
	BEFORE_DISTANCE,
	AFTER_DISTANCE,
	NOWHERE
	} where_in_tree;

extern int (*tdup)();			/* data duplication routine */
extern int (*tinit)();			/* data initialization routine */
extern int (*tfree)();			/* data freeing routine */

extern tree tree_get_tree();
extern void *tree_get_data();
extern treenode parent();
extern treebranch getparentandbranch();
extern treebranch branchtonode();

#define QUOTE '\''		/* constants for files */
#define INDENT "  "

#define Comments 1		/* for whether to use comments or functions */
#define Functions 2

#define tree_get_type(i) ((i)==NULL?0:((treegen)(i))->type)
#define tree_get_intdata(i) ((i)==NULL?NULL:((treegen)(i))->intdata)
#define tree_set_type(i, d) ((i)==NULL?0:(((treegen)(i))->type=(d)))
#define tree_set_intdata(i, d) ((i)==NULL?NULL:(((treegen)(i))->intdata=(d)))
#define t_data(i) ((treegen)(i))->data
#define tree_get_data(i) ((i)==NULL?NULL:(((treegen)(i))->data))
#define tree_set_data(i, d) ((i)==NULL?NULL:(((treegen)(i))->data=(d)))
#define tree_set_dup(d) (tdup=d)
#define tree_set_init(d) (tinit=d)
#define tree_set_free(d) (tfree=d)

#define notbranch(i) ((i)==NULL?0:((treegen)(i))->type!=tr_branch)
#define notnode(i) ((i)==NULL?0:((treegen)(i))->type!=tr_node)
#define nottree(i) ((i)==NULL?0:((treegen)(i))->type!=tr_tree)

#define subtree(i) (((treebranch)nodeobj(i))->down)
#define tforsubtree(n, c) for(firstsubtree(n, &c);c!=NULL;nextsubtree(n, &c))

#define othernode(n, i) ((i)->up==(n)?(i)->down:(i)->up)

extern int findnodebyname();
extern treegen newspace();
extern tree tree_get_tree();
extern void *tree_get_tree_data();
extern int tree_set_tree();
extern char *tree_get_name();
extern tree readrootedtree();
extern list newlist();
extern list addnode();
extern list findnode();
extern list rmnode();
extern list rmcurr();
extern int setcurr();
extern void freelist();
extern list listnode();
extern list setnode();
extern list endlist();
extern list startlist();
extern list listgonext();
extern list lastnode();
extern list listgoprev();
extern void *listnext();
extern void *listprev();
extern void *listcurr();
extern int listlastp();
extern int listfirstp();
extern int listemptyp();
extern printlist();
extern error();
extern tree maketree();
extern treenode makenode();
extern node_set_name();
extern addsubtreetotree();
extern treebranch addsubtree();
extern treebranch replacesubtree();
extern removesubtreefromtree();
extern int removesubtree();
extern list dupcommentlist();
extern treenode dupnode();
extern treenode duplicatenode();
extern treebranch dupbranch();
extern treebranch duplicatebranch();
extern treenode duplicatesubtree1();
extern treenode duplicatesubtree();
extern freecommentlist();
extern freenode();
extern freebranch();
extern freesubtree1();
extern int freesubtree();
extern int freetree();
extern tree duplicatetree();
extern int treereroot();
extern int fliplist();
extern treenode break_branch();
extern treenode merge_branch();
extern treenode change_outgroup();
extern char *new_string();
extern char *dstring();
extern int dlength();
extern int del_string();
extern int ins_string();
extern int ins_char();
extern int add_string();
extern int add_char();
extern char *dup_string();
extern char *freeze_string();
extern t_memory();
extern writecommentlist();
extern writeshift();
extern writetreenode();
extern writetree();
extern writetree_prolog();
extern wtdo();
extern treenode treeroot();
extern firstsubtree();
extern lastsubtree();
extern nextsubtree();
extern prevsubtree();
extern treenode parent();
extern int treeleaf();
extern int treechildren();
extern int treeleaves();
extern treebranch getparentandbranch();
extern treebranch branchtonode1();
extern treebranch branchtonode();
extern int ascendant();
extern int descendant();
extern int parentdistance();
extern int branchdistance();
extern int setparentdistance();
extern double searchdistance();
extern int nodedistance();
