/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.drda;

import java.io.PrintWriter;
import java.net.InetAddress;
import java.util.Properties;
import org.apache.derby.impl.drda.NetworkServerControlImpl;

public class NetworkServerControl {
    public static final int DEFAULT_PORTNUMBER = 1527;
    private NetworkServerControlImpl serverImpl;

    public NetworkServerControl(InetAddress inetAddress, int n) throws Exception {
        this.serverImpl = new NetworkServerControlImpl(inetAddress, n);
    }

    public NetworkServerControl() throws Exception {
        this.serverImpl = new NetworkServerControlImpl();
    }

    public static void main(String[] stringArray) {
        NetworkServerControlImpl networkServerControlImpl = null;
        try {
            networkServerControlImpl = new NetworkServerControlImpl();
            networkServerControlImpl.executeWork(stringArray);
        }
        catch (Exception exception) {
            if (exception.getMessage() == null || !exception.getMessage().equals("Unexpected exception")) {
                if (networkServerControlImpl != null) {
                    networkServerControlImpl.consoleExceptionPrint(exception);
                } else {
                    exception.printStackTrace();
                }
            }
            System.exit(1);
        }
        System.exit(0);
    }

    public void start(PrintWriter printWriter) throws Exception {
        this.serverImpl.start(printWriter);
    }

    public void shutdown() throws Exception {
        this.serverImpl.shutdown();
    }

    public void ping() throws Exception {
        this.serverImpl.ping();
    }

    public void trace(boolean bl) throws Exception {
        this.serverImpl.trace(bl);
    }

    public void trace(int n, boolean bl) throws Exception {
        this.serverImpl.trace(n, bl);
    }

    public void logConnections(boolean bl) throws Exception {
        this.serverImpl.logConnections(bl);
    }

    public void setTraceDirectory(String string) throws Exception {
        this.serverImpl.sendSetTraceDirectory(string);
    }

    public String getSysinfo() throws Exception {
        return this.serverImpl.sysinfo();
    }

    public String getRuntimeInfo() throws Exception {
        return this.serverImpl.runtimeInfo();
    }

    public void setMaxThreads(int n) throws Exception {
        this.serverImpl.netSetMaxThreads(n);
    }

    public int getMaxThreads() throws Exception {
        String string = this.serverImpl.getCurrentProperties().getProperty("derby.drda.maxThreads");
        return Integer.parseInt(string);
    }

    public void setTimeSlice(int n) throws Exception {
        this.serverImpl.netSetTimeSlice(n);
    }

    public int getTimeSlice() throws Exception {
        String string = this.serverImpl.getCurrentProperties().getProperty("derby.drda.timeSlice");
        return Integer.parseInt(string);
    }

    public Properties getCurrentProperties() throws Exception {
        return this.serverImpl.getCurrentProperties();
    }

    protected void setClientLocale(String string) {
        this.serverImpl.clientLocale = string;
    }
}

