/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.internal.project;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.core.SpringCoreUtils;
import org.springframework.ide.eclipse.core.project.IProjectBuilder;

public class SpringProjectBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDERS_EXTENSION_POINT = "org.springframework.ide.eclipse.core.builders";
    private List builders;

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) throws CoreException {
        super.setInitializationData(cfig, propertyName, data);
        this.builders = new ArrayList();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtension[] extensions = registry.getExtensionPoint(BUILDERS_EXTENSION_POINT).getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                try {
                    IConfigurationElement element = elements[j];
                    Object builder = element.createExecutableExtension("class");
                    if (builder instanceof IProjectBuilder) {
                        this.builders.add(builder);
                    }
                }
                catch (CoreException e) {
                    SpringCore.log(e);
                }
                ++j;
            }
            ++i;
        }
    }

    protected final IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        IResourceDelta delta;
        IProject project = this.getProject();
        IResourceDelta iResourceDelta = delta = kind != 6 ? this.getDelta(project) : null;
        if (delta == null || kind == 6) {
            if (SpringCoreUtils.isSpringProject((IResource)project)) {
                project.accept((IResourceVisitor)new Visitor(monitor));
            }
        } else {
            delta.accept((IResourceDeltaVisitor)new DeltaVisitor(monitor));
        }
        return null;
    }

    private void build(IFile file, IProgressMonitor monitor) {
        Iterator builders = this.builders.iterator();
        while (builders.hasNext()) {
            IProjectBuilder builder = (IProjectBuilder)builders.next();
            builder.build(file, monitor);
        }
    }

    private class Visitor
    implements IResourceVisitor {
        private IProgressMonitor monitor;

        public Visitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public boolean visit(IResource resource) {
            if (resource instanceof IFile) {
                SpringProjectBuilder.this.build((IFile)resource, this.monitor);
            }
            return true;
        }
    }

    private class DeltaVisitor
    implements IResourceDeltaVisitor {
        private IProgressMonitor monitor;

        public DeltaVisitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public boolean visit(IResourceDelta aDelta) {
            boolean visitChildren = false;
            IResource resource = aDelta.getResource();
            if (resource instanceof IProject) {
                visitChildren = SpringCoreUtils.isSpringProject((IResource)((IProject)resource));
            } else if (resource instanceof IFolder) {
                visitChildren = true;
            } else if (resource instanceof IFile) {
                switch (aDelta.getKind()) {
                    case 1: 
                    case 4: {
                        if (resource instanceof IFile) {
                            SpringProjectBuilder.this.build((IFile)resource, this.monitor);
                        }
                        visitChildren = true;
                        break;
                    }
                }
            }
            return visitChildren;
        }
    }
}

