/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.graph.actions;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.ui.actions.EditorPartAction;
import org.eclipse.jdt.core.IType;
import org.eclipse.ui.IEditorPart;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.ui.graph.BeansGraphPlugin;
import org.springframework.ide.eclipse.beans.ui.graph.editor.GraphEditor;
import org.springframework.ide.eclipse.beans.ui.graph.model.Bean;
import org.springframework.ide.eclipse.beans.ui.graph.parts.BeanPart;
import org.springframework.ide.eclipse.ui.SpringUIUtils;

public class OpenJavaType
extends EditorPartAction {
    public OpenJavaType(IEditorPart editor) {
        super(editor);
    }

    protected void init() {
        this.setId("open_type");
        this.setText(BeansGraphPlugin.getResourceString("ContextMenu.OpenType.text"));
    }

    protected boolean calculateEnabled() {
        return true;
    }

    public boolean isEnabled() {
        EditPart part = this.getFirstSelectedEditPart();
        return part instanceof BeanPart && ((BeanPart)part).getBean().isRootBean();
    }

    public void run() {
        IProject project;
        IType type;
        Bean bean = ((BeanPart)this.getFirstSelectedEditPart()).getBean();
        String className = bean.getClassName();
        if (className != null && (type = BeansModelUtils.getJavaType((IProject)(project = bean.getConfigFile().getProject()), (String)className)) != null) {
            SpringUIUtils.openInEditor((IType)type);
        }
    }

    protected EditPart getFirstSelectedEditPart() {
        GraphicalViewer viewer = ((GraphEditor)this.getWorkbenchPart()).getGraphicalViewer();
        List list = viewer.getSelectedEditParts();
        if (!list.isEmpty()) {
            return (EditPart)list.get(0);
        }
        return null;
    }
}

