/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.graph;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.springframework.ide.eclipse.beans.ui.graph.BeansGraphPlugin;

public class BeansGraphImages {
    private static final String ICON_PATH_PREFIX = "icons/full/";
    private static final String NAME_PREFIX = "org.springframework.ide.eclipse.beans.ui.graph.";
    private static final int NAME_PREFIX_LENGTH = "org.springframework.ide.eclipse.beans.ui.graph.".length();
    private static URL ICON_BASE_URL = null;
    private static Map imageDescriptors;
    private static ImageRegistry imageRegistry;
    public static final String IMG_OBJS_ROOT_BEAN = "org.springframework.ide.eclipse.beans.ui.graph.rootbean_obj.gif";
    public static final String IMG_OBJS_CHILD_BEAN = "org.springframework.ide.eclipse.beans.ui.graph.childbean_obj.gif";
    public static final String IMG_OBJS_CONSTRUCTOR = "org.springframework.ide.eclipse.beans.ui.graph.constructor_obj.gif";
    public static final String IMG_OBJS_PROPERTY = "org.springframework.ide.eclipse.beans.ui.graph.property_obj.gif";
    public static final String IMG_OBJS_SPRING = "org.springframework.ide.eclipse.beans.ui.graph.spring_obj.gif";
    public static final String IMG_OBJS_ERROR = "org.springframework.ide.eclipse.beans.ui.graph.error_obj.gif";
    private static final String OBJECT = "obj16/";
    public static final ImageDescriptor DESC_OBJS_ROOT_BEAN;
    public static final ImageDescriptor DESC_OBJS_CHILD_BEAN;
    public static final ImageDescriptor DESC_OBJS_CONSTRUCTOR;
    public static final ImageDescriptor DESC_OBJS_PROPERTY;
    public static final ImageDescriptor DESC_OBJS_SPRING;
    public static final ImageDescriptor DESC_OBJS_ERROR;

    static {
        try {
            ICON_BASE_URL = new URL(BeansGraphPlugin.getDefault().getBundle().getEntry("/"), ICON_PATH_PREFIX);
        }
        catch (MalformedURLException e) {
            BeansGraphPlugin.log(e);
        }
        DESC_OBJS_ROOT_BEAN = BeansGraphImages.createManaged(OBJECT, IMG_OBJS_ROOT_BEAN);
        DESC_OBJS_CHILD_BEAN = BeansGraphImages.createManaged(OBJECT, IMG_OBJS_CHILD_BEAN);
        DESC_OBJS_CONSTRUCTOR = BeansGraphImages.createManaged(OBJECT, IMG_OBJS_CONSTRUCTOR);
        DESC_OBJS_PROPERTY = BeansGraphImages.createManaged(OBJECT, IMG_OBJS_PROPERTY);
        DESC_OBJS_SPRING = BeansGraphImages.createManaged(OBJECT, IMG_OBJS_SPRING);
        DESC_OBJS_ERROR = BeansGraphImages.createManaged(OBJECT, IMG_OBJS_ERROR);
    }

    public static Image getImage(String key) {
        return BeansGraphImages.getImageRegistry().get(key);
    }

    public static void setToolImageDescriptors(IAction action, String iconName) {
        BeansGraphImages.setImageDescriptors(action, "tool16", iconName);
    }

    public static void setLocalImageDescriptors(IAction action, String iconName) {
        BeansGraphImages.setImageDescriptors(action, "lcl16", iconName);
    }

    static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry();
            Iterator iter = imageDescriptors.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                imageRegistry.put(key, (ImageDescriptor)imageDescriptors.get(key));
            }
            imageDescriptors = null;
        }
        return imageRegistry;
    }

    private static void setImageDescriptors(IAction action, String type, String relPath) {
        try {
            ImageDescriptor id = ImageDescriptor.createFromURL((URL)BeansGraphImages.makeIconFileURL("d" + type, relPath));
            if (id != null) {
                action.setDisabledImageDescriptor(id);
            }
        }
        catch (MalformedURLException e) {
            BeansGraphPlugin.log(e);
        }
        action.setImageDescriptor(BeansGraphImages.create("e" + type, relPath));
    }

    private static ImageDescriptor createManaged(String prefix, String name) {
        try {
            ImageDescriptor result = ImageDescriptor.createFromURL((URL)BeansGraphImages.makeIconFileURL(prefix, name.substring(NAME_PREFIX_LENGTH)));
            if (imageDescriptors == null) {
                imageDescriptors = new HashMap();
            }
            imageDescriptors.put(name, result);
            if (imageRegistry != null) {
                BeansGraphPlugin.log("Image registry already defined", null);
            }
            return result;
        }
        catch (MalformedURLException e) {
            BeansGraphPlugin.log(e);
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static ImageDescriptor create(String prefix, String name) {
        try {
            return ImageDescriptor.createFromURL((URL)BeansGraphImages.makeIconFileURL(prefix, name));
        }
        catch (MalformedURLException e) {
            BeansGraphPlugin.log(e);
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static URL makeIconFileURL(String prefix, String name) throws MalformedURLException {
        if (ICON_BASE_URL == null) {
            throw new MalformedURLException();
        }
        StringBuffer buffer = new StringBuffer(prefix);
        buffer.append('/');
        buffer.append(name);
        return new URL(ICON_BASE_URL, buffer.toString());
    }
}

