/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.texteditor.ITextEditor;
import org.springframework.ide.eclipse.beans.ui.BeansUIUtils;
import org.springframework.ide.eclipse.beans.ui.views.BeansViewLocation;
import org.springframework.ide.eclipse.ui.SpringUIUtils;

public class ShowInView
extends Action
implements IEditorActionDelegate,
IWorkbenchWindowActionDelegate {
    private ITextEditor editor;
    private IFile file;

    public void init(IWorkbenchWindow window) {
        IWorkbenchPage page = window.getActivePage();
        IEditorPart editor = page != null ? page.getActiveEditor() : null;
        this.setActiveEditor((IAction)this, editor);
    }

    public void dispose() {
    }

    public void setActiveEditor(IAction action, IEditorPart part) {
        this.editor = SpringUIUtils.getTextEditor((IEditorPart)part);
        if (this.editor != null) {
            this.file = BeansUIUtils.getConfigFile((IEditorPart)this.editor);
        } else {
            this.editor = null;
            this.file = null;
        }
        action.setEnabled(this.file != null);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.setActiveEditor(action, SpringUIUtils.getActiveEditor());
    }

    public void run(IAction action) {
        BeansViewLocation location;
        if (this.editor != null && this.file != null && (location = this.guessBeansViewLocation()) != null) {
            location.show();
        }
    }

    private BeansViewLocation guessBeansViewLocation() {
        BeansViewLocation location = new BeansViewLocation();
        location.setProjectName(this.file.getProject().getName());
        location.setConfigName(this.file.getProjectRelativePath().toString());
        int caretOffset = SpringUIUtils.getCaretOffset((ITextEditor)this.editor);
        IDocument doc = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
        BeansViewLocationGuesser guesser = new BeansViewLocationGuesser(doc, caretOffset);
        if (guesser.hasBeanName()) {
            location.setBeanName(guesser.getBeanName());
            if (guesser.hasPropertyName()) {
                location.setPropertyName(guesser.getPropertyName());
            }
        }
        return location;
    }

    private class BeansViewLocationGuesser {
        private IDocument doc;
        private int caretOffset;
        private int nameOffset;
        private String name;
        private int beanOffset;
        private List beanTokens;
        private String beanName;
        private int propertyOffset;
        private List propertyTokens;
        private String propertyName;

        public BeansViewLocationGuesser(IDocument doc, int caretOffset) {
            this.doc = doc;
            this.caretOffset = caretOffset;
            this.guessName();
            this.createBeanTokens();
            this.guessBeanName();
            this.createPropertyTokens();
            this.guessPropertyName();
        }

        private void guessName() {
            String name = null;
            int nameOffset = -1;
            try {
                int offset;
                int startOffset = this.caretOffset;
                while (startOffset > 0) {
                    char c = this.doc.getChar(startOffset - 1);
                    if (c == '\"' || c == '<' || c == '>' || c == '/') break;
                    --startOffset;
                }
                int endOffset = this.caretOffset;
                int length = endOffset - startOffset;
                int max = this.doc.getLength() - startOffset;
                while (length < max) {
                    char c = this.doc.getChar(endOffset);
                    if (c == '\"' || c == '<' || c == '>' || c == '/') break;
                    ++endOffset;
                    ++length;
                }
                if (startOffset > 0 && length < max && this.doc.getChar(offset = startOffset - 1) == '\"' && this.doc.getChar(endOffset) == '\"') {
                    while (offset > 0 && Character.isWhitespace(this.doc.getChar(--offset))) {
                    }
                    if (this.doc.getChar(offset) == '=') {
                        name = this.doc.get(startOffset, length);
                        nameOffset = startOffset;
                    }
                }
            }
            catch (BadLocationException badLocationException) {}
            this.name = name;
            this.nameOffset = nameOffset;
        }

        private void createBeanTokens() {
            ArrayList<String> beanTokens = null;
            if (this.nameOffset != -1) {
                try {
                    this.beanOffset = this.searchBackward(this.doc, this.nameOffset, "<bean");
                    if (this.beanOffset != -1) {
                        String beanText = this.doc.get(this.beanOffset, this.nameOffset - this.beanOffset - 1);
                        String[] tokens = beanText.split("[=\\s]");
                        beanTokens = new ArrayList<String>(Arrays.asList(tokens));
                        Iterator iter = beanTokens.iterator();
                        while (iter.hasNext()) {
                            String token = (String)iter.next();
                            if (token.length() != 0) continue;
                            iter.remove();
                        }
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
            this.beanTokens = beanTokens;
        }

        private void guessBeanName() {
            String beanName = null;
            if (this.beanTokens != null) {
                Iterator iter = this.beanTokens.iterator();
                while (iter.hasNext()) {
                    String token = (String)iter.next();
                    if (!token.equals("id") && !token.equals("name")) continue;
                    if (iter.hasNext()) {
                        int pos;
                        token = (String)iter.next();
                        if (token.length() > 1 && token.charAt(0) == '\"') {
                            token = token.substring(1);
                        }
                        if ((pos = token.indexOf(34)) != -1) {
                            token = token.substring(0, pos);
                        }
                        beanName = token;
                        break;
                    }
                    beanName = this.name;
                    break;
                }
            }
            this.beanName = beanName;
        }

        private void createPropertyTokens() {
            ArrayList<String> propertyTokens = null;
            if (this.nameOffset != -1) {
                try {
                    this.propertyOffset = this.searchBackward(this.doc, this.nameOffset, "<property");
                    if (this.propertyOffset > this.beanOffset) {
                        String propertyText = this.doc.get(this.propertyOffset, this.nameOffset - this.propertyOffset - 1);
                        String[] tokens = propertyText.split("[=\\s]");
                        propertyTokens = new ArrayList<String>(Arrays.asList(tokens));
                        Iterator iter = propertyTokens.iterator();
                        while (iter.hasNext()) {
                            String token = (String)iter.next();
                            if (token.length() != 0) continue;
                            iter.remove();
                        }
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
            this.propertyTokens = propertyTokens;
        }

        private void guessPropertyName() {
            String propertyName = null;
            if (this.propertyTokens != null && !this.beanName.equals(this.name)) {
                Iterator iter = this.propertyTokens.iterator();
                while (iter.hasNext()) {
                    String token = (String)iter.next();
                    if (!token.equals("name")) continue;
                    if (iter.hasNext()) {
                        int pos;
                        token = (String)iter.next();
                        if (token.length() > 1 && token.charAt(0) == '\"') {
                            token = token.substring(1);
                        }
                        if ((pos = token.indexOf(34)) != -1) {
                            token = token.substring(0, pos);
                        }
                        propertyName = token;
                        break;
                    }
                    propertyName = this.name;
                    break;
                }
            }
            this.propertyName = propertyName;
        }

        public int searchBackward(IDocument doc, int startPosition, String findString) throws BadLocationException {
            if (findString == null || findString.length() == 0) {
                return -1;
            }
            if (startPosition < -1 || startPosition > doc.getLength()) {
                throw new BadLocationException();
            }
            char[] fs = new char[findString.length()];
            findString.getChars(0, fs.length, fs, 0);
            if (startPosition == -1) {
                startPosition = doc.getLength();
            }
            return this.lastIndexOf(doc, fs, startPosition);
        }

        private int lastIndexOf(IDocument doc, char[] str, int fromIndex) throws BadLocationException {
            int start;
            int len;
            if (fromIndex < 0) {
                return -1;
            }
            int count = doc.getLength();
            int rightIndex = count - (len = str.length);
            if (fromIndex > rightIndex) {
                fromIndex = rightIndex;
            }
            if (len == 0) {
                return fromIndex;
            }
            int lastIndex = len - 1;
            char lastChar = str[lastIndex];
            int min = len - 1;
            int i = min + fromIndex;
            block0: while (true) {
                if (i >= min && doc.getChar(i) != lastChar) {
                    --i;
                    continue;
                }
                if (i < min) {
                    return -1;
                }
                int j = i - 1;
                start = j - (len - 1);
                int k = lastIndex - 1;
                while (j > start) {
                    if (doc.getChar(j--) == str[k--]) continue;
                    --i;
                    continue block0;
                }
                break;
            }
            return start + 1;
        }

        public String getBeanName() {
            return this.beanName;
        }

        public boolean hasBeanName() {
            return this.beanName != null;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public boolean hasPropertyName() {
            return this.propertyName != null;
        }

        public String toString() {
            return "NodeGuesser: name=" + this.name + ", beanName=" + this.beanName + ", propertyName=" + this.propertyName;
        }
    }
}

